#include "contact_map_window.h"
#include <QDesktopWidget>
#include <QScrollArea>

Contact_Map_Window::Contact_Map_Window(QWidget *parent, const Unit *u)
 : QMainWindow(parent),
   Unit0(u),
   MenuBar(menuBar()),
   WidgetDraw(u)
{
 setWindowModality(Qt::WindowModal);
 setWindowFlags(windowFlags() | Qt::WindowStaysOnTopHint);

 //メニューバー
 MenuFile = new QMenu("ファイル(&F)", MenuBar);
 MenuBar->addMenu(MenuFile);

 ActionQuit = new QAction("終了(&Q)", MenuFile);
 MenuFile->addAction(ActionQuit);
 connect(ActionQuit, SIGNAL(triggered()), this, SLOT(close()));

 //セントラルウィジェット
 WidgetCentral = new QWidget(this);
 setCentralWidget(WidgetCentral);
 LayoutCentral = new QHBoxLayout(WidgetCentral);

 //描画ウィジェット．スクロールバーを付ける
 QScrollArea *scroll_area = new QScrollArea(WidgetCentral);
 scroll_area->setWidget(&WidgetDraw);
 LayoutCentral->addWidget(scroll_area);
 WidgetDraw.setFocus();

 //ツールウィジェット
 WidgetTool = new QWidget(WidgetCentral);
 WidgetTool->setMaximumWidth(200);
 LayoutTool = new QVBoxLayout(WidgetTool);
 LayoutTool->setAlignment(Qt::AlignTop);
 LayoutCentral->addWidget(WidgetTool);

 //コンボボックス
 ComboPept = new QComboBox(WidgetTool);
 LayoutTool->addWidget(ComboPept);

 //ボタン
 ButtonMap0 = new QPushButton("コンタクトマップ", WidgetTool);
 connect(ButtonMap0, SIGNAL(clicked()), this, SLOT(slot_map0()));
 LayoutTool->addWidget(ButtonMap0);
/*
 ButtonMap1 = new QPushButton("+ 距離要素", WidgetTool);
 connect(ButtonMap1, SIGNAL(clicked()), this, SLOT(slot_map1()));
 LayoutTool->addWidget(ButtonMap1);
*/
 create_combo_pept();
}

void Contact_Map_Window::create_combo_pept() {
 //分子とペプチドの番号を取得
 std::array<int, 2> row{0, 0};
 int mol_cnt = Unit0->mol_cnt();
 for(int i = 0; i < mol_cnt; ++i) {
  row[0] = i;
  int pept_cnt = Unit0->pept_cnt(i);
  for(int j = 0; j < pept_cnt; ++j) {
   row[1] = j;
   AaNum.push_back(row);
  }
 }

 //コンボボックスを作成
 ComboPept->clear();
 for(const std::array<int, 2> &row : AaNum) {
  ComboPept->addItem(
        QString("Mol:") + QString::number(row[0])
        + QString(", pept：") + QString::number(row[1]));
 }
}

void Contact_Map_Window::set_window_size(int aa_cnt) {
 QDesktopWidget screen;
 int screen_width = screen.width();
 int screen_height = screen.height();

 int data_width = aa_cnt +200;
 if(data_width < 300)
  data_width = 300;
 int data_height = aa_cnt + 50;

 if(screen_width < data_width || screen_height < data_height)
  setWindowState(windowState() ^ Qt::WindowMaximized);
 else
  setMinimumSize(data_width, data_height);
}

void Contact_Map_Window::slot_map0() {
 int aa_cnt = 0;
 int idx = ComboPept->currentIndex();
 int mol = AaNum[idx][0];
 int pept = AaNum[idx][1];
 aa_cnt = Unit0->aa_cnt(mol, pept);

 set_window_size(aa_cnt);
 WidgetDraw.plot_contact_map_0(mol, pept);
}

void Contact_Map_Window::slot_map1() {
 int aa_cnt = 0;
 int idx = ComboPept->currentIndex();
 int mol = AaNum[idx][0];
 int pept = AaNum[idx][1];
 aa_cnt = Unit0->aa_cnt(mol, pept);

 set_window_size(aa_cnt);
 WidgetDraw.plot_contact_map_1(mol, pept);
}

