#ifndef ___CONTACT_MAP_WINDOW_H
#define ___CONTACT_MAP_WINDOW_H

#include "contact_map_draw.h"
#include <QBoxLayout>
#include <QComboBox>
#include <QMainWindow>
#include <QMenuBar>
#include <QPushButton>

class Contact_Map_Window : public QMainWindow {
 Q_OBJECT  //シグナルとスロットを使う場合に記述する

 private:
  //Unit が 1 個で Draw が QWidget 継承・・・コンタクトマップなど

  const Unit *Unit0;
  std::vector<std::array<int, 2>> AaNum;

  QMenuBar *MenuBar;
  QMenu *MenuFile;
  QAction *ActionQuit;

  QWidget *WidgetCentral;
  QHBoxLayout *LayoutCentral;

  Contact_Map_Draw WidgetDraw;  //QWidget を継承

  QWidget *WidgetTool;
  QVBoxLayout *LayoutTool;

  QComboBox *ComboPept;
  QPushButton *ButtonMap0;
  QPushButton *ButtonMap1;

  void create_combo_pept();
  void set_window_size(int aa_cnt = 0);  //アミノ酸数で決める

 private slots:
  void slot_map0();
  void slot_map1();

 public:
  Contact_Map_Window(QWidget *parent, const Unit *u);
};

#endif

