#include "deep_draw.h"

Deep_Draw::Deep_Draw(QWidget *parent,
        std::vector<Atom> *atom,
        const std::vector<Mol> *mol,
        const std::map<int, int> *serial,
        const Shared_Prm *prm)
 : Draw_Base(parent, atom, mol, serial, prm)
{
 create_objects();
}

void Deep_Draw::create_sphere() {
 SphereForDraw.clear();
 SphereForDraw.shrink_to_fit();

 Level.clear();
 Level.shrink_to_fit();

 calc_level();

 Atom_Distance distance;
 const std::array<double, ELMT_CNT> &VdwRadius
        = distance.vdw_radius();
 Sphere sphere;
 sphere.Color[1] = 0.0;

 int atom_cnt = AtomVect->size();
 for(int i = 0; i < atom_cnt; ++i) {
  const Atom &atom = (*AtomVect)[i];
  sphere.Serial = atom.serialNum;
  sphere.Pos = &atom.XYZ;
  sphere.Radius = VdwRadius[atom.Elmt];

  //深度に応じてカラーリング
  sphere.Color[2] = Level[i];
//  sphere.Color[2] = Level[i] * Level[i];
//  sphere.Color[2] = sqrt(Level[i]);
  sphere.Color[0] = 1.0 - sphere.Color[2];

  SphereForDraw.push_back(sphere);
 }
}

void Deep_Draw::calc_level() {
 int atom_cnt = AtomVect->size();
 Level.assign(atom_cnt, 0.0);

 const Eigen::Vector3d *center = Affine.get_center();
 for(int i = 0; i < atom_cnt; ++i)
  Level[i] = ((*AtomVect)[i].XYZ - *center).norm();

 double max = 0.0;
 for(int i = 0; i < atom_cnt; ++i)
  if(Level[i] > max)
   max = Level[i];

 for(int i = 0; i < atom_cnt; ++i)
  Level[i] = Level[i] / max;

}
