#ifndef ___DETRIAL_DRAW_H
#define ___DETRIAL_DRAW_H

#include "global.h"
#include <builcule/mol.h>
#include <GL/glu.h>
#include <QLabel>
#include <QOpenGLWidget>
#include <QMouseEvent>
#include <QWheelEvent>

class Detrial_Draw : public QOpenGLWidget {
 private:
  //クラス内部のオブジェクト
  int unitNum;
  Eigen::Vector3d drawCenter;  //回転時の計算量減少を期待して，基本的に原点とする
  double drawRadius;
  Eigen::Vector3d eyePos;
  GLdouble Front;  //視点から「上面」までの距離（座標ではない）
  GLdouble Back;  //視点から「下面」までの距離（座標ではない）
  GLint Slices;  //オブジェクトの分割数（経度）
  GLint Stacks;  //オブジェクトの分割数（緯度）
  GLUquadricObj *QSurface;
  int mouseX;
  int mouseY;
  double mouseMoveLength;
  Qt::MouseButton pressedButton;
  QWidget *popupWidget;
  QLabel *popupLabel;

  //クラス外部のオブジェクト
  const Shared_Prm *sharedPrm;
  const std::vector<int> *selectedMol;
  //Detrial_Main のコンストラクタから設定するように変更
  std::array<std::vector<Sphere>, 3> *atomSphere;  //pick で編集する
  const std::array<std::vector<Cylinder>, 2> *bondCylinder;
  const std::vector<Triangle> *peptTriangle;

 private:
  std::vector<Atom> *atomVect;
  const std::vector<Mol> *molVect;  //回転用
  const std::map<int, int> *serialToIdx;
  Detrial_Draw *altDraw;  //連携して回転する際の再描画用
  std::vector<Atom> *altAtomVect;  //連携して回転する際の再描画用

  void mousePressEvent(QMouseEvent *event) override;
  void mouseMoveEvent(QMouseEvent *event) override;
  void mouseReleaseEvent(QMouseEvent *event) override;
  void wheelEvent(QWheelEvent *event) override;
  void move_eye(int ox, int oy);
  void rotate(int unit, int ox, int oy);

  //OpenGL 関連
  void initializeGL() override;
  void resizeGL(int width, int height) override;
  void set_projection();
  void set_lookat();
  void paintGL() override;  //条件を設定し，描画用の関数を呼ぶ
  void draw_sphere(int idx);
  void draw_cylinder(int idx);
  void draw_triangle();
  void draw_wire(int idx);
  int pick();
  int picked_pos(int serial);  //atomSphere[2] での順番
  void draw_sphere_for_pick(int idx);

 public:
  Detrial_Draw(QWidget *parent = nullptr);
  void clear();

  void set_layer_num(int layer) { unitNum = layer; }
  void set_shared_prm(const Shared_Prm *prm) { sharedPrm = prm; }
  void set_atom_vect(std::vector<Atom> *vect) { atomVect = vect; }
  void set_mol_vect(const std::vector<Mol> *vect) { molVect = vect; }
  void set_selected_mol(const std::vector<int> *selected)
      { selectedMol = selected; }
  void set_serial_to_idx(const std::map<int, int> *map)
      { serialToIdx = map; }
  void set_alt(std::vector<Atom> *vect, Detrial_Draw *draw);

  void set_atom_sphere(std::array<std::vector<Sphere>, 3> *atom)
      { atomSphere = atom; }
  void set_bond_cylinder(const std::array<std::vector<Cylinder>, 2> *bond) { bondCylinder = bond; }
  void set_pept_triangle(const std::vector<Triangle> *pept)
      { peptTriangle = pept; }

  void set_center(const Eigen::Vector3d *c) { drawCenter = *c; }
  void set_radius(double r) { drawRadius = r + 2.75; }
  void init_eye_pos();
  void clear_pick();
  void pick(int idx);
};

#endif

/*
半透明化はきれいに描画できなかった
void Detrial_Draw::draw_sphere_selection_mode() {
 //glDisable(GL_CULL_FACE);
 //glDisable(GL_DEPTH_TEST);
 //glDepthMask(GL_FALSE);
 //glEnable(GL_BLEND);
 //glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

 for(const Sphere &sphere : *atomSphere) {
  glMaterialfv(GL_FRONT, GL_DIFFUSE, sphere.Color);
  glPushMatrix();
  const Eigen::Vector3d *xyz = sphere.Pos;
  glTranslated((*xyz)[0], (*xyz)[1], (*xyz)[2]);
  gluSphere(quadricSurface, sphere.Radius, Slices, Stacks);
  glPopMatrix();
 }

 //glDisable(GL_BLEND);
 //glDepthMask(GL_TRUE);
 //glEnable(GL_DEPTH_TEST);
 //glEnable(GL_CULL_FACE);
 //glDisable(GL_ALPHA_TEST);
}
*/
