#include "detrial_main.h"
#include "domain_window.h"
#include "statistics_window.h"
#include "deep_window.h"
#include "charge_window.h"
#include "vdw_contact_window.h"
#include "h_bond_window.h"
#include "aa_color_window.h"
#include "contact_map_window.h"
#include <QFileDialog>

void Detrial_Main::closeEvent(QCloseEvent *event) {
 widgetSel.close();
 event->accept();
}

void Detrial_Main::slot_close() {
 widgetSel.close();
 close();
}

int Detrial_Main::unit_num() {
 int layer_num = -1;
 int unit0 = detrialDraw[0].isVisible();
 int unit1 = detrialDraw[1].isVisible();
 if(unit0 && unit1)
  layer_num = 2;
 else
  layer_num = unit0 ? 0 : 1;
 return layer_num;
}

void Detrial_Main::slot_waals_cpk() {
 for(int i = 0; i < 2; ++i) {
  if(detrialDraw[i].isVisible()) {
   sharedPrm.drawDivideMode = 0;
   sharedPrm.Quadric[i][0] = GLU_FILL;
   sharedPrm.Model[i][0].assign(1, VDW);
   sharedPrm.Color[i][0] = CPK;
   dUnit[i].init_alpha_val(0);
   dUnit[i].set_atom_sphere_radius(0, VDW);
   dUnit[i].set_atom_sphere_color(0, CPK);
  }
 }
 repaint();
}

void Detrial_Main::slot_waals_mol() {
 for(int i = 0; i < 2; ++i) {
  if(detrialDraw[i].isVisible()) {
   sharedPrm.drawDivideMode = 0;
   sharedPrm.Quadric[i][0] = GLU_FILL;
   sharedPrm.Model[i][0].assign(1, VDW);
   sharedPrm.Color[i][0] = MOL;
   dUnit[i].init_alpha_val(0);
   dUnit[i].set_atom_sphere_radius(0, VDW);
   dUnit[i].set_atom_sphere_color(0, MOL);
  }
 }
 repaint();
}

void Detrial_Main::slot_waals_aa() {
 for(int i = 0; i < 2; ++i) {
  if(detrialDraw[i].isVisible()) {
   sharedPrm.drawDivideMode = 0;
   sharedPrm.Quadric[i][0] = GLU_FILL;
   sharedPrm.Model[i][0].assign(1, VDW);
   sharedPrm.Color[i][0] = AA;
   dUnit[i].init_alpha_val(0);
   dUnit[i].set_atom_sphere_radius(0, VDW);
   dUnit[i].set_atom_sphere_color(0, AA);
  }
 }
 repaint();
}

void Detrial_Main::slot_bs_cpk() {
 for(int i = 0; i < 2; ++i) {
  if(detrialDraw[i].isVisible()) {
   sharedPrm.drawDivideMode = 0;
   sharedPrm.Quadric[i][0] = GLU_FILL;
   sharedPrm.Model[i][0].assign(1, BALL);
   sharedPrm.Model[i][0].push_back(STICK);
   sharedPrm.Color[i][0] = CPK;
   dUnit[i].create_bond_cylinder();  //シリンダが作成されていなければ作成
   dUnit[i].init_alpha_val(0);
   dUnit[i].set_atom_sphere_radius(0, BALL);
   dUnit[i].set_atom_sphere_color(0, CPK);
   dUnit[i].set_bond_cylinder_radius(0, STICK);
  }
 }
 repaint();
}

void Detrial_Main::slot_ribbon_secondary() {
 for(int i = 0; i < 2; ++i) {
  if(detrialDraw[i].isVisible()) {
   sharedPrm.drawDivideMode = 0;
   sharedPrm.Quadric[i][0] = GLU_FILL;
   sharedPrm.Model[i][0].assign(1, RIBBON);
   sharedPrm.Color[i][0] = SECONDARY;
   dUnit[i].create_pept_triangle();  //リボンが作成されていなければ作成
   dUnit[i].set_pept_triangle_color(SECONDARY);
  }
 }
 repaint();
}

void Detrial_Main::slot_repaint() {
 for(int i = 0; i < 2; ++i)
  if(detrialDraw[i].isVisible())
   detrialDraw[i].repaint();
}

void Detrial_Main::slot_layer0() {
 if(!detrialDraw[1].isVisible())
  return;

 //両方表示していた場合
 if(detrialDraw[0].isVisible()) {
  detrialDraw[1].hide();
  SelectorMolAA[1].hide();
  resize(width() / 2, height());
  widgetSel.setFixedWidth(300);
  return;
 }

 //1 のみ表示していた場合
 if(detrialDraw[1].isVisible()) {
  detrialDraw[1].hide();
  SelectorMolAA[1].hide();
  detrialDraw[0].show();
  SelectorMolAA[0].show();
  return;
 }
}

void Detrial_Main::slot_layer1() {
 if(!detrialDraw[0].isVisible())
  return;

 //両方表示していた場合
 if(detrialDraw[1].isVisible()) {
  detrialDraw[0].hide();
  SelectorMolAA[0].hide();
  resize(width() / 2, height());
  widgetSel.setFixedWidth(300);
  return;
 }

 //0 のみ表示していた場合
 if(detrialDraw[0].isVisible()) {
  detrialDraw[0].hide();
  SelectorMolAA[0].hide();
  detrialDraw[1].show();
  SelectorMolAA[1].show();
  return;
 }
}

void Detrial_Main::slot_layer01() {
 if(detrialDraw[0].isVisible() && detrialDraw[1].isVisible())
  return;

 for(int i = 0; i < 2; ++i) {
  if(!detrialDraw[i].isVisible()) {
   detrialDraw[i].show();
   SelectorMolAA[i].show();
  }
 }

 widgetSel.setFixedWidth(600);
 resize(width() * 2, height());
}

void Detrial_Main::keyPressEvent(QKeyEvent *event) {
 if(event->key() == Qt::Key_A &&
    !dUnit[0].atom_vect()->empty() &&
    !dUnit[1].atom_vect()->empty()) {
  sharedPrm.KeyA = true;
  sharedPrm.KeyX = false;
  sharedPrm.KeyZ = false;
 }
 else if(event->key() == Qt::Key_X) {
  sharedPrm.KeyA = false;
  sharedPrm.KeyX = true;
  sharedPrm.KeyZ = false;
 }
 else if(event->key() == Qt::Key_Z) {
  sharedPrm.KeyA = false;
  sharedPrm.KeyX = false;
  sharedPrm.KeyZ = true;
 }
}

void Detrial_Main::keyReleaseEvent(QKeyEvent *event) {
 if(event->key() == Qt::Key_A && sharedPrm.KeyA)
  sharedPrm.KeyA = false;
 else if(event->key() == Qt::Key_X)
  sharedPrm.KeyX = false;
 else if(event->key() == Qt::Key_Z)
  sharedPrm.KeyZ = false;
}

void Detrial_Main::slot_centering() {
 for(int i = 0; i < 2; ++i)
  if(detrialDraw[i].isVisible()) {
   unitAffine[i].calc_center();
   unitAffine[i].calc_radius();
   detrialDraw[i].set_center(unitAffine[i].get_center());
   detrialDraw[i].set_radius(unitAffine[i].get_radius());
   detrialDraw[i].init_eye_pos();
  }
 slot_repaint();
}

void Detrial_Main::slot_pick_mode(bool on) {
 sharedPrm.pickMode = on;
 slot_repaint();
}

void Detrial_Main::slot_clear_pick() {
 for(int i = 0; i < 2; ++i)
  if(detrialDraw[i].isVisible())
   dUnit[i].clear_pick();
 slot_repaint();
}

void Detrial_Main::slot_measure_distance() {
 bool l0 = detrialDraw[0].isVisible();
 bool l1 = detrialDraw[1].isVisible();
 if(l0 && l1) {
  QMessageBox::warning(this, "警告", "描画領域が 1 個の場合のみ測定します．");
  return;
 }
 int layer = l0 ? 0 : 1;
 const std::vector<Sphere> &picked = (*dUnit[layer].atom_sphere())[2];
 if(picked.size() != 2) {
  QMessageBox::warning(this, "警告", "2 原子をピックして下さい．");
  return;
 }
 double val = (*picked[1].Pos - *picked[0].Pos).norm();
 QMessageBox::information(this, "距離", QString::number(val) + " Å");
}

void Detrial_Main::slot_measure_angle() {
 bool l0 = detrialDraw[0].isVisible();
 bool l1 = detrialDraw[1].isVisible();
 if(l0 && l1) {
  QMessageBox::warning(this, "警告", "描画領域が 1 個の場合のみ測定します．");
  return;
 }

 int layer = l0 ? 0 : 1;
 const std::vector<Sphere> &picked = (*dUnit[layer].atom_sphere())[2];
 if(picked.size() != 3) {
  QMessageBox::warning(this, "警告", "3 原子をピックして下さい．");
  return;
 }

 double val = measure_angle(picked[0].Pos, picked[1].Pos, picked[2].Pos) * RAD_to_DEG;
 QMessageBox::information(this, "角度", QString::number(val) + " °");
}

void Detrial_Main::slot_measure_diheadral() {
 bool l0 = detrialDraw[0].isVisible();
 bool l1 = detrialDraw[1].isVisible();
 if(l0 && l1) {
  QMessageBox::warning(this, "警告", "描画領域が 1 個の場合のみ測定します．");
  return;
 }

 int layer = l0 ? 0 : 1;
 const std::vector<Sphere> &picked = (*dUnit[layer].atom_sphere())[2];
 if(picked.size() != 4) {
  QMessageBox::warning(this, "警告", "4 原子をピックして下さい．");
  return;
 }

 double val = measure_diheadral(picked[0].Pos, picked[1].Pos, picked[2].Pos, picked[3].Pos) * RAD_to_DEG;
 QMessageBox::information(this, "二面角", QString::number(val) + " °");
}

void Detrial_Main::slot_aa_or_other() {
 int layer = unit_num();
 if(layer == 2) {
  QMessageBox::warning(this, "警告", "片方の描画領域のみを表示して下さい．");
  return;
 }

 dUnit[layer].create_bond_cylinder();  //未作成なら作成
 dUnit[layer].create_pept_triangle();  //未作成なら作成
 dUnit[layer].divide_sphere_and_cylinder_by_aa();

 widgetAAorOther = new Widget_AA_Or_Other(&sharedPrm, this);;
 widgetAAorOther->setAttribute(Qt::WA_DeleteOnClose);
 connect(widgetAAorOther, SIGNAL(aa_or_other_config()), this, SLOT(slot_aa_or_other_config()));
 widgetAAorOther->show();
 widgetAAorOther->import_shared_prm(layer);
}

void Detrial_Main::slot_aa_or_other_config() {
 int layer = unit_num();
 if(layer == 2) {
  QMessageBox::warning(this, "警告", "片方の描画領域のみを表示して下さい．");
  return;
 }

 widgetAAorOther->export_shared_prm(layer);
 sharedPrm.drawDivideMode = 1;

 //アミノ酸側のモデル
 const std::vector<MODEL> &aa_model = sharedPrm.Model[layer][0];
 int model_cnt = aa_model.size();

 if(model_cnt == 3) {
  dUnit[layer].set_atom_sphere_radius(0, BALL);
  dUnit[layer].set_bond_cylinder_radius(0, STICK);
 }
 else if(model_cnt == 2) {
  dUnit[layer].set_atom_sphere_radius(0, BALL);
  dUnit[layer].set_bond_cylinder_radius(0, STICK);
 }
 else if(aa_model[0] == ROD) {
  dUnit[layer].set_atom_sphere_radius(0, ROD);
  dUnit[layer].set_bond_cylinder_radius(0, ROD);
  dUnit[layer].set_atom_sphere_radius(1, BALL);
  dUnit[layer].set_bond_cylinder_radius(1, STICK);
 }
 else if(aa_model[0] == VDW)
  dUnit[layer].set_atom_sphere_radius(0, VDW);
 else
  dUnit[layer].set_bond_cylinder_radius(0, WIRE);

 //アミノ酸側の色
 COLOR aa_color = sharedPrm.Color[layer][0];
 //球の場合分け
 dUnit[layer].set_atom_sphere_color(0, aa_color);
 //共有結合の場合分け
 if(aa_model[0] == ROD || aa_model[0] == WIRE)
  dUnit[layer].set_bond_cylinder_color(0, aa_color);
 else if(model_cnt > 1)  //BALL_STICK || BALL_STICK_RIBBON
  dUnit[layer].set_bond_cylinder_color(0, MONO);
 //リボンの場合分け
 if(model_cnt == 3)  //ball_stick_ribbon
  dUnit[layer].set_pept_triangle_color(SECONDARY);
 if(aa_model[0] == RIBBON)
  dUnit[layer].set_pept_triangle_color(aa_color);

 //非アミノ酸側のモデル
 const std::vector<MODEL> &non_model = sharedPrm.Model[layer][1];
 model_cnt = non_model.size();
 if(model_cnt == 2) {
  dUnit[layer].set_atom_sphere_radius(1, BALL);
  dUnit[layer].set_bond_cylinder_radius(1, STICK);
 }
 else if(non_model[0] == ROD) {
  dUnit[layer].set_atom_sphere_radius(1, ROD);
  dUnit[layer].set_bond_cylinder_radius(1, ROD);
 }
 else if(non_model[0] == VDW)
  dUnit[layer].set_atom_sphere_radius(1, VDW);
 else
  dUnit[layer].set_bond_cylinder_radius(1, WIRE);
 //非アミノ酸側の色
 COLOR non_color = sharedPrm.Color[layer][1];
 dUnit[layer].set_atom_sphere_color(1, non_color);
 if(non_color == MOL)
  dUnit[layer].set_bond_cylinder_color(1, MOL);
 else
 dUnit[layer].set_bond_cylinder_color(1, MONO);

 slot_repaint();
}

void Detrial_Main::slot_mol_selection() {
 int layer = unit_num();
 if(layer == 2) {
  QMessageBox::warning(this, "警告", "片方の描画領域のみを表示して下さい．");
  return;
 }

 dUnit[layer].create_bond_cylinder();  //未作成なら作成
 dUnit[layer].divide_sphere_and_cylinder_by_mol_selection
        (SelectorMolAA[layer].selected_mol());

 widgetMolSelection = new Widget_Mol_Selection(&sharedPrm, this);
 widgetMolSelection->setAttribute(Qt::WA_DeleteOnClose);
 connect(widgetMolSelection, SIGNAL(mol_selection_config()), this, SLOT(slot_mol_selection_config()));
 widgetMolSelection->show();
 widgetMolSelection->import_shared_prm(layer);
}

void Detrial_Main::slot_mol_selection_config() {
 int layer = unit_num();
 if(layer == 2) {
  QMessageBox::warning(this, "警告", "片方の描画領域のみを表示して下さい．");
  return;
 }

 widgetMolSelection->export_shared_prm(layer);
 sharedPrm.drawDivideMode = 1;

 //非選択側のモデル
 const std::vector<MODEL> &sel_model = sharedPrm.Model[layer][0];
 int model_cnt = sel_model.size();
 if(model_cnt == 2) {
  dUnit[layer].set_atom_sphere_radius(0, BALL);
  dUnit[layer].set_bond_cylinder_radius(0, STICK);
 }
 else if(sel_model[0] == ROD) {
  dUnit[layer].set_atom_sphere_radius(0, ROD);
  dUnit[layer].set_bond_cylinder_radius(0, ROD);
 }
 else if(sel_model[0] == VDW)
  dUnit[layer].set_atom_sphere_radius(0, VDW);
 else
  dUnit[layer].set_bond_cylinder_radius(0, WIRE);

 //非選択側の色
 COLOR &sel_color = sharedPrm.Color[layer][0];
 dUnit[layer].set_atom_sphere_color(0, sel_color);
 if(sel_color != MOL)
  dUnit[layer].set_bond_cylinder_color(0, MONO);
 else
  dUnit[layer].set_bond_cylinder_color(0, MOL);

 //選択側のモデル
 const std::vector<MODEL> &non_model = sharedPrm.Model[layer][1];
 model_cnt = non_model.size();
 if(model_cnt == 2) {
  dUnit[layer].set_atom_sphere_radius(1, BALL);
  dUnit[layer].set_bond_cylinder_radius(1, STICK);
 }
 else if(non_model[0] == ROD) {
  dUnit[layer].set_atom_sphere_radius(1, ROD);
  dUnit[layer].set_bond_cylinder_radius(1, ROD);
 }
 else if(non_model[0] == VDW)
  dUnit[layer].set_atom_sphere_radius(1, VDW);
 else
  dUnit[layer].set_bond_cylinder_radius(1, WIRE);

 //選択側の色
 COLOR non_color = sharedPrm.Color[layer][1];
 dUnit[layer].set_atom_sphere_color(1, non_color);
 if(non_color != MOL)
  dUnit[layer].set_bond_cylinder_color(1, MONO);
 else
  dUnit[layer].set_bond_cylinder_color(1, MOL);

 slot_repaint();
}

void Detrial_Main::slot_aa_selection() {
 int layer = unit_num();
 if(layer == 2) {
  QMessageBox::warning(this, "警告", "片方の描画領域のみを表示して下さい．");
  return;
 }

 dUnit[layer].create_bond_cylinder();  //未作成なら作成
 dUnit[layer].create_pept_triangle();  //未作成なら作成
 dUnit[layer].divide_sphere_by_aa_selection(SelectorMolAA[layer].selected_aa());

 widgetAASelection = new Widget_AA_Selection(&sharedPrm, this);
 widgetAASelection->setAttribute(Qt::WA_DeleteOnClose);
 connect(widgetAASelection, SIGNAL(aa_selection_config()), this, SLOT(slot_aa_selection_config()));
 widgetAASelection->show();
 widgetAASelection->import_shared_prm(layer);
}

void Detrial_Main::slot_aa_selection_config() {
 int layer = unit_num();
 if(layer == 2) {
  QMessageBox::warning(this, "警告", "片方の描画領域のみを表示して下さい．");
  return;
 }

 widgetAASelection->export_shared_prm(layer);
 sharedPrm.drawDivideMode = 1;

 //非選択アミノ酸側のモデル
 const std::vector<MODEL> &non_model = sharedPrm.Model[layer][0];
 int model_cnt = non_model.size();
 if(model_cnt == 3) {
  dUnit[layer].set_atom_sphere_radius(0, BALL);
  dUnit[layer].set_bond_cylinder_radius(0, STICK);
  dUnit[layer].set_bond_cylinder_radius(1, STICK);
 }
 else if(model_cnt == 2) {
  dUnit[layer].set_atom_sphere_radius(0, BALL);
  dUnit[layer].set_bond_cylinder_radius(0, STICK);
  dUnit[layer].set_bond_cylinder_radius(1, STICK);
 }
 else if(non_model[0] == ROD) {
  dUnit[layer].set_atom_sphere_radius(0, ROD);
  dUnit[layer].set_bond_cylinder_radius(0, ROD);
  dUnit[layer].set_bond_cylinder_radius(1, ROD);
 }
 else if(non_model[0] == VDW)
  dUnit[layer].set_atom_sphere_radius(0, VDW);
 else {
  dUnit[layer].set_bond_cylinder_radius(0, WIRE);
  dUnit[layer].set_bond_cylinder_radius(1, WIRE);
 }

 //非選択アミノ酸側の色
 COLOR aa_color = sharedPrm.Color[layer][0];
 //球の場合分け
 dUnit[layer].set_atom_sphere_color(0, aa_color);
 //共有結合の場合分け
 if(non_model[0] == ROD || non_model[0] == WIRE) {
  dUnit[layer].set_bond_cylinder_color(0, aa_color);
  dUnit[layer].set_bond_cylinder_color(1, aa_color);
 }
 else if(model_cnt > 1)  {  //BALL_STICK || BALL_STICK_RIBBON
  dUnit[layer].set_bond_cylinder_color(0, MONO);
  dUnit[layer].set_bond_cylinder_color(1, MONO);
 }
 //リボンの場合分け
 if(model_cnt == 3)  //ball_stick_ribbon
  dUnit[layer].set_pept_triangle_color(SECONDARY);
 if(non_model[0] == RIBBON)
  dUnit[layer].set_pept_triangle_color(aa_color);

 //選択アミノ酸側の原子モデル
 dUnit[layer].set_atom_sphere_radius(1, sharedPrm.Model[layer][1][0]);

 //選択アミノ酸側の原子色
 dUnit[layer].set_atom_sphere_color(1, sharedPrm.Color[layer][1]);

 slot_repaint();
}

void Detrial_Main::slot_pick_by_id() {
 int unit = unit_num();
 if(unit == 2) return;
 int atom_cnt = dUnit[unit].atom_cnt();
 if(!atom_cnt) return;

 QInputDialog dialog(this);
 dialog.setLabelText("行順位（最小値は 0）でピック");
 dialog.setInputMode(QInputDialog::IntInput);
 dialog.setCancelButtonText("キャンセル");
 dialog.setOkButtonText("実行");
 dialog.setIntMaximum(atom_cnt - 1);
 dialog.setIntMinimum(0);
 dialog.setIntValue(0);
 if(!dialog.exec())  //enum QDialog::DialogCode が返る
  return;
 detrialDraw[unit].pick(dialog.intValue());
}

void Detrial_Main::slot_pick_to_neighbor_aa() {
 int unit = unit_num();
 if(unit == 2) {
  QMessageBox::warning(this, "警告", "片方のユニットのみを表示させてください．");
  return;
 }

 if(dUnit[unit].picked_empty()) {
  QMessageBox::warning(this, "警告", "原子がピックされていません．");
  return;
 }

 QInputDialog dialog(this);
 dialog.setLabelText("近傍(1.0 〜 10.0 Å)アミノ酸の検知");
 dialog.setInputMode(QInputDialog::DoubleInput);
 dialog.setCancelButtonText("キャンセル");
 dialog.setOkButtonText("実行");
 dialog.setDoubleMaximum(10.0);
 dialog.setDoubleMinimum(1.0);
 dialog.setDoubleValue(1.0);
 if(!dialog.exec())  //enum QDialog::DialogCode が返る
  return;

 const std::vector<std::array<int, 3>> *selected_aa = dUnit[unit].pick_to_neighbor_aa(dialog.doubleValue());
 SelectorMolAA[unit].select_aa(selected_aa);
}

void Detrial_Main::slot_aa_to_neighbor_aa() {
 int unit = unit_num();
 if(unit == 2) {
  QMessageBox::warning(this, "警告", "片方のユニットのみを表示させてください．");
  return;
 }

 const std::vector<std::array<int, 3>> *selected_aa = SelectorMolAA[unit].selected_aa();
 if(selected_aa->empty()) {
  QMessageBox::warning(this, "警告", "アミノ酸が選択されていません．");
  return;
 }

 QInputDialog dialog(this);
 dialog.setLabelText("近傍(1.0 〜 10.0 Å)アミノ酸の検知");
 dialog.setInputMode(QInputDialog::DoubleInput);
 dialog.setCancelButtonText("キャンセル");
 dialog.setOkButtonText("実行");
 dialog.setDoubleMaximum(10.0);
 dialog.setDoubleMinimum(1.0);
 dialog.setDoubleValue(1.0);
 if(!dialog.exec())  //enum QDialog::DialogCode が返る
  return;

 double val = dialog.doubleValue();
 selected_aa = dUnit[unit].aa_to_neighbor_aa(selected_aa, val);
 SelectorMolAA[unit].select_aa(selected_aa);
}

void Detrial_Main::slot_mol_to_neighbor_aa() {
 int unit = unit_num();
 if(unit == 2) {
  QMessageBox::warning(this, "警告", "片方のユニットのみを表示させてください．");
  return;
 }

 const std::vector<int> *selected_mol = SelectorMolAA[unit].selected_mol();
 if(selected_mol->size() != 1) {
  QMessageBox::warning(this, "警告", "分子を 1 個選択してください．");
  return;
 }

 QInputDialog dialog(this);
 dialog.setLabelText("近傍(1.0 〜 10.0 Å)アミノ酸の検知");
 dialog.setInputMode(QInputDialog::DoubleInput);
 dialog.setCancelButtonText("キャンセル");
 dialog.setOkButtonText("実行");
 dialog.setDoubleMaximum(10.0);
 dialog.setDoubleMinimum(1.0);
 dialog.setDoubleValue(1.0);
 if(!dialog.exec())  //enum QDialog::DialogCode が返る
  return;

 double val = dialog.doubleValue();
 const std::vector<std::array<int, 3>> *selected_aa = dUnit[unit].mol_to_neighbor_aa((*selected_mol)[0], val);
 SelectorMolAA[unit].select_aa(selected_aa);
}

void Detrial_Main::slot_mol_to_mol() {
 int unit = unit_num();
 if(unit == 2) {
  QMessageBox::warning(this, "警告", "片方のユニットのみを表示させてください．");
  return;
 }

 const std::vector<int> *selected_mol = SelectorMolAA[unit].selected_mol();
 if(selected_mol->size() != 2) {
  QMessageBox::warning(this, "警告", "分子を 2 個選択してください．");
  return;
 }

 QInputDialog dialog(this);
 dialog.setLabelText("近傍(1.0 〜 10.0 Å)原子の検知");
 dialog.setInputMode(QInputDialog::DoubleInput);
 dialog.setCancelButtonText("キャンセル");
 dialog.setOkButtonText("実行");
 dialog.setDoubleMaximum(10.0);
 dialog.setDoubleMinimum(1.0);
 dialog.setDoubleValue(1.0);
 if(!dialog.exec())  //enum QDialog::DialogCode が返る
  return;

 double val = dialog.doubleValue();
 const std::vector<int> *selected_atom = dUnit[unit].mol_to_neighbor_atom((*selected_mol)[0], (*selected_mol)[1], val);

 sharedPrm.drawDivideMode = 0;
 sharedPrm.Quadric[unit][0] = GLU_FILL;
 sharedPrm.Model[unit][0].assign(1, VDW);
 sharedPrm.Model[unit][0].push_back(WIRE);
 sharedPrm.Color[unit][0] = MOL;
 dUnit[unit].create_bond_cylinder();  //シリンダが作成されていなければ作成
 dUnit[unit].set_atom_sphere_radius(0, VDW);
 dUnit[unit].set_bond_cylinder_radius(0, WIRE);
 dUnit[unit].set_bond_cylinder_color(0, DEFAULT_COLOR);
 dUnit[unit].set_atom_sphere_color(0, MOL);
 dUnit[unit].set_alpha_val(0, selected_atom);

 slot_repaint();
}
void Detrial_Main::slot_mol_to_mol_charge() {
 int unit = unit_num();
 if(unit == 2) {
  QMessageBox::warning(this, "警告", "片方のユニットのみを表示させてください．");
  return;
 }

 const std::vector<int> *selected_mol = SelectorMolAA[unit].selected_mol();
 if(selected_mol->size() != 2) {
  QMessageBox::warning(this, "警告", "分子を 2 個選択してください．");
  return;
 }

 QInputDialog dialog(this);
 dialog.setLabelText("近傍(1.0 〜 10.0 Å)原子の検知");
 dialog.setInputMode(QInputDialog::DoubleInput);
 dialog.setCancelButtonText("キャンセル");
 dialog.setOkButtonText("実行");
 dialog.setDoubleMaximum(10.0);
 dialog.setDoubleMinimum(1.0);
 dialog.setDoubleValue(1.0);
 if(!dialog.exec())  //enum QDialog::DialogCode が返る
  return;

 double val = dialog.doubleValue();
 const std::vector<int> *selected_atom = dUnit[unit].mol_to_neighbor_atom((*selected_mol)[0], (*selected_mol)[1], val);

 if(!dUnit[unit].charge_calced()) {
  dUnit[unit].set_orbital();
  dUnit[unit].calc_charge();
 }
 dUnit[unit].set_charge_calced(true);

 sharedPrm.drawDivideMode = 0;
 sharedPrm.Quadric[unit][0] = GLU_FILL;
 sharedPrm.Model[unit][0].assign(1, VDW);
 sharedPrm.Model[unit][0].push_back(WIRE);
 sharedPrm.Color[unit][0] = CHARGE;
 dUnit[unit].create_bond_cylinder();  //シリンダが作成されていなければ作成
 dUnit[unit].set_atom_sphere_radius(0, VDW);
 dUnit[unit].set_bond_cylinder_radius(0, WIRE);
 dUnit[unit].set_bond_cylinder_color(0, DEFAULT_COLOR);
 dUnit[unit].set_atom_sphere_color(0, CHARGE);
 dUnit[unit].set_alpha_val(0, selected_atom);

 slot_repaint();
}

void Detrial_Main::slot_align() {
//アラインメントウィンドウを作成する
 if(!dUnit[0].contain_peptide()) {
  QMessageBox::warning(this, "警告", "ユニット 0 にはペプチドが含まれていません．");
  return;
 }
 if(!dUnit[1].contain_peptide()) {
  QMessageBox::warning(this, "警告", "ユニット 1 にはペプチドが含まれていません．");
  return;
 }
 AlignWindow
        = new Align_Window(this, &sharedPrm, &dUnit[0], &dUnit[1]);
 AlignWindow->setAttribute(Qt::WA_DeleteOnClose);
 connect(AlignWindow, SIGNAL(align_calced()), this,
        SLOT(slot_align_calced()));
 connect(AlignWindow, SIGNAL(superimpose_by_align()), this,
        SLOT(slot_superimpose_by_align()));
}

void Detrial_Main::slot_align_calced() {
 SelectorMolAA[0].aa_selection_clear();
 SelectorMolAA[1].aa_selection_clear();

 //アラインメントされたアミノ酸を選択する
 int mol0 = AlignWindow->mol_num(0);
 int pept0 = AlignWindow->pept_num(0);
 int mol1 = AlignWindow->mol_num(1);
 int pept1 = AlignWindow->pept_num(1);
 const std::array<std::vector<int>, 2> *aa_num
        = AlignWindow->get_aligned_aa_num();

 int cnt = (*aa_num)[0].size();
 for(int i = 0; i < cnt; ++i) {
  int num0 = (*aa_num)[0][i];
  int num1 = (*aa_num)[1][i];
  if(num0 > 0 && num1 > 0) {
   SelectorMolAA[0].select_aa(mol0, pept0, num0);
   SelectorMolAA[1].select_aa(mol1, pept1, num1);
  }
 }
}

void Detrial_Main::slot_superimpose_by_align()
{
 detrialDraw[0].set_center(unitAffine[1].get_center());
 detrialDraw[0].set_radius(unitAffine[1].get_radius());
 detrialDraw[0].init_eye_pos();
 detrialDraw[0].repaint();
}

void Detrial_Main::slot_superinpose_by_pick0() {
//Affine は，1 個の atomVect しか持たないので，ここで処理する


 if(!dUnit[0].atom_cnt()) {
  QMessageBox::warning(this, "警告",
        "ユニット 0 に分子が作成されていません．");
  return;
 }

 if(!dUnit[1].atom_cnt()) {
  QMessageBox::warning(this, "警告",
        "ユニット 1 に分子が作成されていません．");
  return;
 }

 const std::vector<Sphere> &picked0
        = (*dUnit[0].atom_sphere())[2];
 const std::vector<Sphere> &picked1
        = (*dUnit[1].atom_sphere())[2];
 int cnt0 = picked0.size();
 int cnt1 = picked1.size();
 if(cnt0 != cnt1) {
  QMessageBox::warning(this, "警告", "ユニット 0 と 1 とで同数の原子をピックしてください．");
  return;
 }

 //1 個めの原子を重ね合わせる（ユニット 0 を移動）
 const Eigen::Vector3d *v00
   = dUnit[0].get_xyz(picked0[0].Serial);
 const Eigen::Vector3d *v10
   = dUnit[1].get_xyz(picked1[0].Serial);
 unitAffine[0].move(v00, v10);

 //2 個めの原子を重ね合わせる（ユニット 0 を回転）
 const Eigen::Vector3d *v01 = new Eigen::Vector3d(0.0, 0.0, 0.0);
 const Eigen::Vector3d *v11 = new Eigen::Vector3d(0.0, 0.0, 0.0);
 Eigen::Vector3d axis;
 double radian;
 if(cnt0 > 1) {
  v01 = dUnit[0].get_xyz(picked0[1].Serial);
  v11 = dUnit[1].get_xyz(picked1[1].Serial);
  radian = measure_angle(v11, v00, v01);
  unitAffine[0].set_center(v00);
  axis = (*v11 - *v10).cross(*v01 - *v00);
  axis.normalize();
  unitAffine[0].create_rotation_matrix(&axis, radian);
  unitAffine[0].rotate_unit();
 }

 //3 個めの原子を重ね合わせる（ユニット 0 を回転）
 const Eigen::Vector3d *v02 = new Eigen::Vector3d(0.0, 0.0, 0.0);
 const Eigen::Vector3d *v12 = new Eigen::Vector3d(0.0, 0.0, 0.0);
 if(cnt0 > 2) {
  v02 = dUnit[0].get_xyz(picked0[2].Serial);
  v12 = dUnit[1].get_xyz(picked1[2].Serial);
  unitAffine[0].set_center(v11);
  axis = *v11 - *v10;
  axis.normalize();
  radian = measure_diheadral(v02, v01, v10, v12);
  unitAffine[0].create_rotation_matrix(&axis, -radian);
  unitAffine[0].rotate_unit();
 }

 //Builcule_Draw を再描画
 unitAffine[1].calc_center();
 unitAffine[0].set_center(unitAffine[1].get_center());
 slot_superimpose_by_align();
}

void Detrial_Main::slot_superinpose_by_pick1() {
//Unit1 を基準にして，Unit0 を回転

 if(!dUnit[0].atom_cnt()) {
  QMessageBox::warning(this, "警告",
        "ユニット 0 に分子が作成されていません．");
  return;
 }

 if(!dUnit[1].atom_cnt()) {
  QMessageBox::warning(this, "警告",
        "ユニット 1 に分子が作成されていません．");
  return;
 }

 const std::vector<Sphere> &picked0
        = (*dUnit[0].atom_sphere())[2];
 const std::vector<Sphere> &picked1
        = (*dUnit[1].atom_sphere())[2];
 int cnt0 = picked0.size();
 int cnt1 = picked1.size();
 if(cnt0 != cnt1) {
  QMessageBox::warning(this, "警告", "ユニット 0 と 1 とで同数の原子をピックしてください．");
  return;
 }
 if(cnt0 < 4) {
  QMessageBox::warning(this, "警告", "4 原子以上をピックしてください．");
  return;
 }

 std::vector<Eigen::Vector3d> target;
 std::vector<Eigen::Vector3d> standard;
 for(int i = 0; i < cnt0; ++i) {
  target.push_back(*picked0[i].Pos);  //こちらを 平行移動して回転
  standard.push_back(*picked1[i].Pos);  //こちらは動かさない
 }

 Superimpose sup;

 //ピックされた領域について，中心を合わせ，回転行列を作成
 sup.set_target(&target);
 sup.set_standard(&standard);
 const Eigen::Vector3d *align_center0 = sup.get_align_center(0);
 const Eigen::Vector3d *align_center1 = sup.get_align_center(1);
 unitAffine[0].move(align_center0, align_center1);
 if(!sup.create_rotation_matrix()) {
  QMessageBox::warning(this, "警告", "回転行列が作成できません．");
  return;
 }

 //重ね合わせ
 sup.rotate(dUnit[0].atom_vect());

 //Builcule_Draw を再描画
 unitAffine[1].calc_center();
 unitAffine[0].set_center(unitAffine[1].get_center());
 slot_superimpose_by_align();
}

void Detrial_Main::slot_vdw_contact() {
 int layer = unit_num();
 if(layer == 2) {
  QMessageBox::warning(this, "警告", "片方の描画領域のみを表示して下さい．");
  return;
 }

 std::vector<Atom> *atom = dUnit[layer].atom_vect();
 if(atom->empty())
  return;

 const std::vector<Mol> *mol = dUnit[layer].mol_vect();
 const std::map<int, int> *serial = dUnit[layer].serial_to_idx();
 VDW_Contact_Window *window
    = new VDW_Contact_Window(this, atom, mol, serial, &sharedPrm);
 window->setAttribute(Qt::WA_DeleteOnClose);
 connect(window, SIGNAL(destroyed()), this, SLOT(repaint()));
 window->show();
}

void Detrial_Main::slot_domain() {
 int layer = unit_num();
 if(layer == 2) {
  QMessageBox::warning(this, "警告", "片方の描画領域のみを表示して下さい．");
  return;
 }

 std::vector<Atom> *atom = dUnit[layer].atom_vect();
 if(atom->empty())
  return;

 const std::vector<Mol> *mol = dUnit[layer].mol_vect();
 const std::map<int, int> *serial = dUnit[layer].serial_to_idx();
 Domain_Window *window
    = new Domain_Window(this, atom, mol, serial, &sharedPrm);
 window->setAttribute(Qt::WA_DeleteOnClose);
 connect(window, SIGNAL(destroyed()), this, SLOT(repaint()));
 window->show();
}

void Detrial_Main::slot_statistics() {
 int layer = unit_num();
 if(layer == 2) {
  QMessageBox::warning(this, "警告", "片方の描画領域のみを表示して下さい．");
  return;
 }

 std::vector<Atom> *atom = dUnit[layer].atom_vect();
 if(atom->empty())
  return;

 const std::vector<Mol> *mol = dUnit[layer].mol_vect();
 const std::map<int, int> *serial = dUnit[layer].serial_to_idx();
 Statistics_Window *window
    = new Statistics_Window(this, atom, mol, serial, &sharedPrm);
 window->setAttribute(Qt::WA_DeleteOnClose);
 connect(window, SIGNAL(destroyed()), this, SLOT(repaint()));
 window->show();
}

void Detrial_Main::slot_deep() {
 int layer = unit_num();
 if(layer == 2) {
  QMessageBox::warning(this, "警告", "片方の描画領域のみを表示して下さい．");
  return;
 }

 std::vector<Atom> *atom = dUnit[layer].atom_vect();
 if(atom->empty())
  return;

 const std::vector<Mol> *mol = dUnit[layer].mol_vect();
 const std::map<int, int> *serial = dUnit[layer].serial_to_idx();
 Deep_Window *window
    = new Deep_Window(this, atom, mol, serial, &sharedPrm);
 window->setAttribute(Qt::WA_DeleteOnClose);
 connect(window, SIGNAL(destroyed()), this, SLOT(repaint()));
 window->show();
}

void Detrial_Main::slot_calc_charge() {
 for(int i = 0; i < 2; ++i) {
  if(detrialDraw[i].isVisible()) {
   sharedPrm.drawDivideMode = 0;
   sharedPrm.Quadric[i][0] = GLU_FILL;
   sharedPrm.Model[i][0].clear();
   sharedPrm.Model[i][0].shrink_to_fit();
   sharedPrm.Model[i][0].push_back(VDW);
   sharedPrm.Color[i][0] = CHARGE;
   if(!dUnit[i].charge_calced()) {
    dUnit[i].set_orbital();
    dUnit[i].calc_charge();
   }
   dUnit[i].set_charge_calced(true);
   sharedPrm.drawDivideMode = 0;
   dUnit[i].set_atom_sphere_radius(0, VDW);
   dUnit[i].set_atom_sphere_color(0, CHARGE);
  }
 }
 repaint();
}

void Detrial_Main::slot_import_charge() {
 int layer = unit_num();
 if(layer == 2) {
  QMessageBox::warning(this, "警告", "片方の描画領域のみを表示して下さい．");
  return;
 }

 std::vector<Atom> *atom = dUnit[layer].atom_vect();
 if(atom->empty())
  return;

 QFileDialog dialog(this);
 dialog.setDirectory(sharedPrm.Dir);

 if(!dialog.exec())  //enum QDialog::DialogCode が返る
  return;

 QStringList path_list = dialog.selectedFiles();
 QString qpath = path_list[0];
 QFile file(qpath);
 if (!file.open(QIODevice::ReadOnly)) {
  QMessageBox::critical(this, "エラー", "ファイルを開くことができません．");
  return;
 }
 sharedPrm.Dir = dialog.directory();
 const std::string path = qpath.toStdString();

 if(!dUnit[layer].read_1_col_data(&path)) {
  QMessageBox::critical(this, "エラー", "ファイルを開くことができません．");
  return;
 }

 const std::vector<Mol> *mol = dUnit[layer].mol_vect();
 const std::map<int, int> *serial = dUnit[layer].serial_to_idx();
 Charge_Window *window
    = new Charge_Window(this, atom, mol, serial, &sharedPrm);
 window->setAttribute(Qt::WA_DeleteOnClose);
 connect(window, SIGNAL(destroyed()), this, SLOT(repaint()));
 window->show();

 //電荷未計算のフラグ
 dUnit[layer].set_charge_calced(true);

 connect(window, SIGNAL(destroyed()), this, SLOT(repaint()));
 window->show();
}

void Detrial_Main::slot_h_bond() {
 int layer = unit_num();
 if(layer == 2) {
  QMessageBox::warning(this, "警告", "片方の描画領域のみを表示して下さい．");
  return;
 }

 std::vector<Atom> *atom = dUnit[layer].atom_vect();
 if(atom->empty())
  return;

 const std::vector<Mol> *mol = dUnit[layer].mol_vect();
 const std::map<int, int> *serial = dUnit[layer].serial_to_idx();
 H_Bond_Window *window
    = new H_Bond_Window(this, atom, mol, serial, &sharedPrm);
 window->setAttribute(Qt::WA_DeleteOnClose);
 connect(window, SIGNAL(destroyed()), this, SLOT(repaint()));
 window->show();
}

void Detrial_Main::slot_aa_color() {
 int layer = unit_num();
 if(layer == 2) {
  QMessageBox::warning(this, "警告", "片方の描画領域のみを表示して下さい．");
  return;
 }

 std::vector<Atom> *atom = dUnit[layer].atom_vect();
 if(atom->empty())
  return;

 const std::vector<Mol> *mol = dUnit[layer].mol_vect();
 const std::map<int, int> *serial = dUnit[layer].serial_to_idx();
 AA_Color_Window *window
    = new AA_Color_Window(this, atom, mol, serial, &sharedPrm);
 window->setAttribute(Qt::WA_DeleteOnClose);
 connect(window, SIGNAL(destroyed()), this, SLOT(repaint()));
 window->show();
}

void Detrial_Main::slot_contact_map() {
 int layer = unit_num();
 if(layer == 2) {
  QMessageBox::warning(this, "警告", "片方の描画領域のみを表示して下さい．");
  return;
 }

 std::vector<Atom> *atom = dUnit[layer].atom_vect();
 if(atom->empty())
  return;

 Contact_Map_Window *window
    = new Contact_Map_Window(this, &dUnit[layer]);
 window->setAttribute(Qt::WA_DeleteOnClose);
 window->show();
}

