#ifndef ___DETRIAL_MAIN_H
#define ___DETRIAL_MAIN_H

#include "align_window.h"
#include "detrial_draw.h"
#include "detrial_unit.h"
#include "global.h"
#include "selector.h"
#include "widget_aa_or_other.h"
#include "widget_mol_selection.h"
#include "widget_aa_selection.h"
#include <QInputDialog>
#include <QMainWindow>
#include <QMessageBox>
#include <QMenuBar>

class Detrial_Main : public QMainWindow {
 Q_OBJECT

 public:
  Detrial_Main(QWidget *parent = nullptr);

 private:
  Shared_Prm sharedPrm;
  std::array<Detrial_Unit, 2> dUnit;
  std::array<Detrial_Draw, 2> detrialDraw;
  QWidget widgetSel;
  std::array<Selector, 2> SelectorMolAA;

  Widget_AA_Or_Other *widgetAAorOther;
  Widget_Mol_Selection *widgetMolSelection;
  Widget_AA_Selection *widgetAASelection;
  Align_Window *AlignWindow;

  QAction *actionPickMode;

  int unit_num();

  const QString prep_suffix(const QString &filter) const;
  bool compare_suffix_and_type(const QString &name, const QString &type) const;

  //修飾キーイベントは，メインウィンドウでないと動作しなかった
  //マウスプレスイベント等は，最上位のウィジェット（Detrial_Draw）でないと動作しなかった
  void keyPressEvent(QKeyEvent *event) override;
  void keyReleaseEvent(QKeyEvent *event) override;
  //メインウィンドウの「閉じる」ボタンをクリックしたときに子ウィジェットを閉じるには closeEvent() をオーバーライドする
  void closeEvent(QCloseEvent *event) override;
  void set_window_size(const std::vector<std::vector<double>> *mtx);

 private slots:
  void slot_repaint();
  //メニューバー ファイル
  void slot_file_open();
  void slot_file_save();
  void slot_export_fasta();
  void slot_import_via_babel();
  void slot_export_via_babel();
  void slot_save_image();
  void slot_close();
  //メニューバー ウィジェット
  void slot_layer0();
  void slot_layer1();
  void slot_layer01();
  void slot_selector_show() { widgetSel.show(); }
  //メニューバー 編集
  void slot_superinpose_by_pick0();
  void slot_superinpose_by_pick1();
  void slot_centering();
  //メニューバー 表示
  void slot_waals_cpk();
  void slot_waals_mol();
  void slot_waals_aa();
  void slot_bs_cpk();
  void slot_ribbon_secondary();
  void slot_aa_or_other();
  void slot_aa_or_other_config();
  void slot_mol_selection();
  void slot_mol_selection_config();
  void slot_aa_selection();
  void slot_aa_selection_config();
  void slot_calc_charge();
  void slot_import_charge();
  //メニューバー 検知
  void slot_pick_by_id();
  void slot_pick_to_neighbor_aa();
  void slot_mol_to_mol();
  void slot_mol_to_mol_charge();
  void slot_aa_to_neighbor_aa();
  void slot_mol_to_neighbor_aa();

  void slot_align();
  void slot_align_calced();
  void slot_superimpose_by_align();
  void slot_domain();
  void slot_vdw_contact();
  void slot_statistics();
  void slot_deep();
  void slot_h_bond();
  void slot_aa_color();
  void slot_contact_map();

  //ツールバー
  void slot_pick_mode(bool on);
  void slot_clear_pick();
  void slot_measure_distance();
  void slot_measure_angle();
  void slot_measure_diheadral();
};

#endif
