#include "detrial_main.h"
#include <QBoxLayout>
#include <QDesktopWidget>
#include <QToolBar>

Detrial_Main::Detrial_Main(QWidget *parent)
 : QMainWindow(parent),
   widgetAAorOther(nullptr),
   widgetMolSelection(nullptr),
   widgetAASelection(nullptr),
   AlignWindow(nullptr),
   actionPickMode(nullptr)
{
 for(int i = 0; i != 2; ++i)
  dUnit[i].set_unit_num(i);

  //アフィン変換
 for(int i = 0; i < 2; ++i) {
  unitAffine[i].set_atom_vect(dUnit[i].atom_vect());
  unitAffine[i].set_serial_to_idx(dUnit[i].serial_to_idx());
 }

 //サイズポリシー
 QDesktopWidget screen;
 int max_width = screen.width();
 int max_height = screen.height();
 int min_width = max_width / 2;
 int min_height = max_height/ 2;
 if(min_width < min_height)
  setMinimumSize(min_width, min_width);
 else
  setMinimumSize(min_height, min_height);

 //セントラルウィジェット
 QWidget *widget_central = new QWidget(this);
 setCentralWidget(widget_central);
 QHBoxLayout *layout_central = new QHBoxLayout(widget_central);

 //メニューバー
 QMenuBar *menu_Bar(menuBar());

 //ツールバー
 QToolBar *tool_bar = addToolBar("ツールバー");

 //メニュー詳細
 QMenu *menuFile = new QMenu("ファイル(&F)", menu_Bar);
 menu_Bar->addMenu(menuFile);

 QAction *actionFileOpen = new QAction("開く(&O)", menuFile);
 menuFile->addAction(actionFileOpen);
 connect(actionFileOpen, SIGNAL(triggered()),
   this, SLOT(slot_file_open()));

 QAction *actionImportViaBabel
        = new QAction("Open Babel でインポート", menuFile);
 menuFile->addAction(actionImportViaBabel);
 connect(actionImportViaBabel, SIGNAL(triggered()),
        this, SLOT(slot_import_via_babel()));

 QAction *actionSave = new QAction("保存(&S)", menuFile);
 menuFile->addAction(actionSave);
 connect(actionSave, SIGNAL(triggered()),
   this, SLOT(slot_file_save()));

 QAction *actionExportViaBabel
        = new QAction("Open Babel でエクスポート", menuFile);
 menuFile->addAction(actionExportViaBabel);
 connect(actionExportViaBabel, SIGNAL(triggered()),
        this, SLOT(slot_export_via_babel()));

 QAction *actionFASTA = new QAction("FASTA 形式で出力(&F)", menuFile);
 menuFile->addAction(actionFASTA);
 connect(actionFASTA, SIGNAL(triggered()),
   this, SLOT(slot_export_fasta()));

 QAction *actionSaveImage = new QAction("画像として保存(&I)", menuFile);
 menuFile->addAction(actionSaveImage);
 connect(actionSaveImage, SIGNAL(triggered()),
   this, SLOT(slot_save_image()));

 QAction *actionQuit = new QAction("終了(&Q)", menuFile);
 menuFile->addAction(actionQuit);
 connect(actionQuit, SIGNAL(triggered()), this, SLOT(slot_close()));


 QMenu *menuWidget = new QMenu("ウィジェット(&W)", menu_Bar);
 menu_Bar->addMenu(menuWidget);

 QAction *actionLayer0 = new QAction("レイヤ 0", menuWidget);
 menuWidget->addAction(actionLayer0);
 connect(actionLayer0, SIGNAL(triggered()),
   this, SLOT(slot_layer0()));

 QAction *actionLayer1 = new QAction("レイヤ 1", menuWidget);
 menuWidget->addAction(actionLayer1);
 connect(actionLayer1, SIGNAL(triggered()),
   this, SLOT(slot_layer1()));

 QAction *actionLayer01 = new QAction("レイヤ 01", menuWidget);
 menuWidget->addAction(actionLayer01);
 connect(actionLayer01, SIGNAL(triggered()),
   this, SLOT(slot_layer01()));

 QAction *actionSelShow = new QAction("セレクタを表示", menuWidget);
 menuWidget->addAction(actionSelShow);
 connect(actionSelShow, SIGNAL(triggered()),
   this, SLOT(slot_selector_show()));


 QMenu *menuEdit = new QMenu("編集(&E)", menu_Bar);
 menu_Bar->addMenu(menuEdit);

 QAction *actionSuperinposeByPick0
    = new QAction("ピックした原子を重ね合わせ（平面上）", menu_Bar);
 connect(actionSuperinposeByPick0, SIGNAL(triggered()),
   this, SLOT(slot_superinpose_by_pick0()));
 menuEdit->addAction(actionSuperinposeByPick0);

 QAction *actionSuperinposeByPick1
    = new QAction("ピックした原子を重ね合わせ（非平面上）", menu_Bar);
 connect(actionSuperinposeByPick1, SIGNAL(triggered()),
   this, SLOT(slot_superinpose_by_pick1()));
 menuEdit->addAction(actionSuperinposeByPick1);

 QAction *actionCentering = new QAction("センタリング", menuEdit);
 menuEdit->addAction(actionCentering);
 connect(actionCentering, SIGNAL(triggered()),
   this, SLOT(slot_centering()));


 QMenu *menuView = new QMenu("表示(&V)", menu_Bar);
 menu_Bar->addMenu(menuView);

 QMenu *submenuWaals = new QMenu("空間充填", menuView);
 menuView->addMenu(submenuWaals);

 QAction *actionWaalsCPK = new QAction("CPK", submenuWaals);
 submenuWaals->addAction(actionWaalsCPK);
 connect(actionWaalsCPK, SIGNAL(triggered()),
   this, SLOT(slot_waals_cpk()));

 QAction *actionWaalsMol = new QAction("分子", submenuWaals);
 submenuWaals->addAction(actionWaalsMol);
 connect(actionWaalsMol, SIGNAL(triggered()),
   this, SLOT(slot_waals_mol()));

 QAction *actionWaalsAA = new QAction("アミノ酸", submenuWaals);
 submenuWaals->addAction(actionWaalsAA);
 connect(actionWaalsAA, SIGNAL(triggered()),
   this, SLOT(slot_waals_aa()));

 QAction *actionBSCPK = new QAction("棒球 + CPK色", menuView);
 menuView->addAction(actionBSCPK);
 connect(actionBSCPK, SIGNAL(triggered()),
   this, SLOT(slot_bs_cpk()));

 QAction *actionRibbonSecondary = new QAction("リボン + 二次構造色", menuView);
 menuView->addAction(actionRibbonSecondary);
 connect(actionRibbonSecondary, SIGNAL(triggered()),
   this, SLOT(slot_ribbon_secondary()));

 QMenu *submenuSeparateDraw = new QMenu("描き分け", menuView);
 menuView->addMenu(submenuSeparateDraw);

 QAction *actionAAandOther = new QAction("アミノ酸/非アミノ酸", submenuSeparateDraw);
 submenuSeparateDraw->addAction(actionAAandOther);
 connect(actionAAandOther, SIGNAL(triggered()),
   this, SLOT(slot_aa_or_other()));

 QAction *actionMolSelected = new QAction("選択分子/非選択分子", submenuSeparateDraw);
 submenuSeparateDraw->addAction(actionMolSelected);
 connect(actionMolSelected, SIGNAL(triggered()),
   this, SLOT(slot_mol_selection()));

 QAction *actionSelectedAA = new QAction("選択アミノ酸/その他", submenuSeparateDraw);
 submenuSeparateDraw->addAction(actionSelectedAA);
 connect(actionSelectedAA, SIGNAL(triggered()),
   this, SLOT(slot_aa_selection()));

 QAction *actionCalcCharge = new QAction("電荷を簡易計算", menuView);
 menuView->addAction(actionCalcCharge);
 connect(actionCalcCharge, SIGNAL(triggered()),
   this, SLOT(slot_calc_charge()));

 QAction *actionImportCharge = new QAction("電荷をインポート", menuView);
 menuView->addAction(actionImportCharge);
 connect(actionImportCharge, SIGNAL(triggered()),
   this, SLOT(slot_import_charge()));


 QMenu *menuDetect = new QMenu("検知(&D)", menu_Bar);
 menu_Bar->addMenu(menuDetect);

 QAction *actionPickByID
    = new QAction("行順位を指定してピック", menu_Bar);
 connect(actionPickByID, SIGNAL(triggered()),
   this, SLOT(slot_pick_by_id()));
 menuDetect->addAction(actionPickByID);

 QAction *actionPickToNeighborAA
    = new QAction("ピックした原子の近傍アミノ酸を選択", menu_Bar);
 connect(actionPickToNeighborAA, SIGNAL(triggered()),
   this, SLOT(slot_pick_to_neighbor_aa()));
 menuDetect->addAction(actionPickToNeighborAA);

 QAction *actionMolToNeighborAA
    = new QAction("選択した分子の近傍アミノ酸を選択", menu_Bar);
 connect(actionMolToNeighborAA, SIGNAL(triggered()),
   this, SLOT(slot_mol_to_neighbor_aa()));
 menuDetect->addAction(actionMolToNeighborAA);

 QAction *actionAAToNeighborAA
    = new QAction("選択したアミノ酸の近傍アミノ酸を選択", menu_Bar);
 connect(actionAAToNeighborAA, SIGNAL(triggered()),
   this, SLOT(slot_aa_to_neighbor_aa()));
 menuDetect->addAction(actionAAToNeighborAA);

 QMenu *submenuMolToMol = new QMenu("選択した 2 分子間の近傍原子を検知", menuDetect);
 menuDetect->addMenu(submenuMolToMol);

 QAction *actionMolToMol
    = new QAction("分子別に色分け", menu_Bar);
 connect(actionMolToMol, SIGNAL(triggered()),
   this, SLOT(slot_mol_to_mol()));
 submenuMolToMol->addAction(actionMolToMol);

 QAction *actionMolToMolCharge
    = new QAction("電荷を計算して着色", menu_Bar);
 connect(actionMolToMolCharge, SIGNAL(triggered()),
   this, SLOT(slot_mol_to_mol_charge()));
 submenuMolToMol->addAction(actionMolToMolCharge);

 QAction *actionAlign = new QAction("アラインメント", menuDetect);
 menuDetect->addAction(actionAlign);
 connect(actionAlign, SIGNAL(triggered()),
   this, SLOT(slot_align()));

 QAction *actionKMeans = new QAction("ドメイン", menuDetect);
 menuDetect->addAction(actionKMeans);
 connect(actionKMeans, SIGNAL(triggered()),
   this, SLOT(slot_domain()));

 QAction *actionVdwContact = new QAction("接触原子", menuDetect);
 menuDetect->addAction(actionVdwContact);
 connect(actionVdwContact, SIGNAL(triggered()),
   this, SLOT(slot_vdw_contact()));

 QAction *actionStatistics = new QAction("固有ベクトル", menuDetect);
 menuDetect->addAction(actionStatistics);
 connect(actionStatistics, SIGNAL(triggered()),
   this, SLOT(slot_statistics()));

 QAction *actionDeep = new QAction("深度", menuDetect);
 menuDetect->addAction(actionDeep);
 connect(actionDeep, SIGNAL(triggered()),
   this, SLOT(slot_deep()));

 QAction *actionHBond = new QAction("水素結合", menuDetect);
 menuDetect->addAction(actionHBond);
 connect(actionHBond, SIGNAL(triggered()),
   this, SLOT(slot_h_bond()));

 QAction *actionAAColor = new QAction("アミノ酸の種類を指定", menuDetect);
 menuDetect->addAction(actionAAColor);
 connect(actionAAColor, SIGNAL(triggered()),
   this, SLOT(slot_aa_color()));

 QAction *actionContactMap = new QAction("コンタクトマップ", menuDetect);
 menuDetect->addAction(actionContactMap);
 connect(actionContactMap, SIGNAL(triggered()),
   this, SLOT(slot_contact_map()));


 //ツールボタン詳細
 const QIcon icon_pick_mode("://icon/pick_mode.png");
 actionPickMode = new QAction(icon_pick_mode, "ピックモードの ON/OFF", this);
 actionPickMode->setCheckable(true);
 connect(actionPickMode, SIGNAL(toggled(bool)),
   this, SLOT(slot_pick_mode(bool)));
 tool_bar->addAction(actionPickMode);

 const QIcon icon_clear_pick("://icon/clear_pick.png");
 QAction *action_clear_pick = new QAction(icon_clear_pick, "ピックモードと独立にピックをクリア", this);
 connect(action_clear_pick, SIGNAL(triggered()),
   this, SLOT(slot_clear_pick()));
 tool_bar->addAction(action_clear_pick);

 const QIcon icon_measure_distance("://icon/measure_distance.png");
 QAction *action_measure_distance = new QAction(icon_measure_distance, "ピックした 2 原子間の距離を測定", this);
 connect(action_measure_distance, SIGNAL(triggered()),
   this, SLOT(slot_measure_distance()));
 tool_bar->addAction(action_measure_distance);

 const QIcon icon_measure_angle("://icon/measure_angle.png");
 QAction *action_measure_angle = new QAction(icon_measure_angle, "ピックした 3 原子のなす角度を測定", this);
 connect(action_measure_angle, SIGNAL(triggered()),
   this, SLOT(slot_measure_angle()));
 tool_bar->addAction(action_measure_angle);

 const QIcon icon_measure_diheadral("://icon/measure_diheadral.png");
 QAction *action_measure_diheadral = new QAction(icon_measure_diheadral, "ピックした 4 原子のなす二面角を測定", this);
 connect(action_measure_diheadral, SIGNAL(triggered()),
   this, SLOT(slot_measure_diheadral()));
 tool_bar->addAction(action_measure_diheadral);

 //描画ウィジェット
 for(int i = 0; i != 2; ++i) {
  layout_central->addWidget(&detrialDraw[i]);
  detrialDraw[i].setParent(widget_central);
  detrialDraw[i].set_layer_num(i);
  detrialDraw[i].set_shared_prm(&sharedPrm);
  detrialDraw[i].set_mol_vect(dUnit[i].mol_vect());  //回転用
  detrialDraw[i].set_selected_mol(SelectorMolAA[i].selected_mol());
  detrialDraw[i].set_atom_sphere(dUnit[i].atom_sphere());
  detrialDraw[i].set_bond_cylinder(dUnit[i].bond_cylinder());
  detrialDraw[i].set_pept_triangle(dUnit[i].pept_triangle());
  detrialDraw[i].set_atom_vect(dUnit[i].atom_vect());
  detrialDraw[i].set_serial_to_idx(dUnit[i].serial_to_idx());
 }
 detrialDraw[1].set_alt(dUnit[0].atom_vect(), &detrialDraw[0]);
 detrialDraw[0].set_alt(dUnit[1].atom_vect(), &detrialDraw[1]);
 detrialDraw[1].hide();

 //分子およびアミノ酸セレクタ．メインウィンドウからは独立したウィンドウとする
 QHBoxLayout *layout_sel = new QHBoxLayout(&widgetSel);
 for(int i = 0; i < 2; ++i) {
  layout_sel->addWidget(&SelectorMolAA[i]);
  SelectorMolAA[i].set_label(i);
  SelectorMolAA[i].set_atom_vect(dUnit[i].atom_vect());
  const std::map<int, int> *map = dUnit[i].serial_to_idx();
  SelectorMolAA[i].set_serial_to_atom_idx(map);
  const std::array<std::vector<Sphere>, 3> *sphere
      = dUnit[i].atom_sphere();
  SelectorMolAA[i].set_picked_sphere(&(*sphere)[2]);
 }
 SelectorMolAA[1].hide();
 widgetSel.setMaximumWidth(600);
 widgetSel.setMinimumWidth(300);

 widgetSel.setMinimumHeight(max_height * 0.8);
}

