#include "detrial_main.h"
#include "dialog_babel.h"
#include <QFileDialog>

const QString Detrial_Main::prep_suffix(const QString &filter) const {
 int space = 0;
 while(filter[space++] != ' ');
 QString suffix = filter.mid(0, space - 1);
 return suffix;
}

bool Detrial_Main::compare_suffix_and_type(const QString &name, const QString &type) const {
 int cnt_name = name.count();  //フルパスの名前
 int cnt_suffix = type.count();  //拡張子（ドットなし）

 for(int i = 1; i <= cnt_suffix; ++i) {
  if(type[cnt_suffix - i] != name[cnt_name - i])
   return false;
 }

 if(name[cnt_name - cnt_suffix - 1] != '.')
  return false;

 return true;

/*
 //参考
 std::wstring str_name = name.toStdWString();
 std::wstring str_type = type.toStdWString();
 for(int i = 1; i <= cnt_suffix; ++i) {
  std::cout << (char)str_type[cnt_suffix - i] << ' ';
  std::cout << (char)str_name[cnt_name - i] << '\n';
 }
 std::cout << (char)str_name[cnt_name - cnt_suffix - 1] << '\n';
*/
}

void Detrial_Main::slot_file_open() {
 int layer = unit_num();
 if(layer == 2) {
  QMessageBox::warning(this, "警告", "片方の描画領域のみを表示して下さい．");
  return;
 }

 QFileDialog dialog(this);
 dialog.setDirectory(sharedPrm.Dir);
 dialog.setNameFilter("bcl 形式 *.bcl;;cif 形式（PDBx/mmCif） *.cif;;pdb 形式 *.pdb;;xyz 形式 *.xyz");
/*
 const QStringList filters({
        "bcl 形式 (*.bcl)",
        "PDBx/mmCif 形式 (*.cif)",
        "pdb 形式 (*.pdb)",
        "xyz 形式 (*.xyz)"
});
 dialog.setNameFilters(filters);
*/
 if(!dialog.exec())  //enum QDialog::DialogCode が返る
  return;

 QStringList path_list = dialog.selectedFiles();
 QString qpath = path_list[0];
 QFile file(qpath);
 if (!file.open(QIODevice::ReadOnly)) {
  QMessageBox::critical(this, "エラー", "ファイルを開くことができません．");
  return;
 }
 sharedPrm.Dir = dialog.directory();
 const std::string path = qpath.toStdString();
 QString filter = dialog.selectedNameFilter().left(3);

 sharedPrm.fileName[layer] = QFileInfo(qpath).fileName();

 dUnit[layer].clear();

 std::string filter_std = filter.toStdString();
 if(!dUnit[layer].read_file(&path, &filter_std)) {
  QMessageBox::critical(this, "エラー", "ファイルを開くことができません．");
  dUnit[layer].clear();
  return;
 }
 dUnit[layer].create_data_structure();

 //電荷未計算のフラグ
 dUnit[layer].set_charge_calced(false);

 //セレクタの作成
 int mol_cnt = dUnit[layer].mol_cnt();
 SelectorMolAA[layer].create_mol_selector(mol_cnt);
 SelectorMolAA[layer].create_aa_selector(dUnit[layer].mol_vect());

 actionPickMode->setChecked(false);

 //描画
 unitAffine[layer].calc_center();
 unitAffine[layer].calc_radius();
 detrialDraw[layer].set_center(unitAffine[layer].get_center());
 detrialDraw[layer].set_radius(unitAffine[layer].get_radius());
 detrialDraw[layer].init_eye_pos();
 dUnit[layer].create_atom_sphere();
 slot_waals_cpk();
 //リサイズイベントを発生させないと，表示の縦横比がおかしくなる（原因不明）
 resize(width() + 1, height());
 resize(width() - 1, height());
 repaint();
}

void Detrial_Main::slot_file_save() {
 int layer = unit_num();
 if(layer == 2) {
  QMessageBox::warning(this, "警告", "片方の描画領域のみを表示して下さい．");
  return;
 }

 QFileDialog dialog(this);
 dialog.setAcceptMode(QFileDialog::AcceptSave);
 dialog.setDirectory(sharedPrm.Dir);
 dialog.selectFile("*.*");
 dialog.setNameFilter("pdb 形式 *.pdb;;bcl 形式 *.bcl;;xyz 形式 *.xyz");
 if(!dialog.exec())  //enum QDialog::DialogCode が返る
  return;

 QStringList path_list = dialog.selectedFiles();
 QString qpath = path_list[0];
 QFile file(qpath);
 if (!file.open(QIODevice::WriteOnly)) {
  QMessageBox::critical(this, "エラー", "QIODevice::WriteOnly で開くことができません．");
  return;
 }

 std::string name = qpath.toStdString();
 std::string type = (qpath.right(3)).toStdString();
 if(!dUnit[layer].save(&name, &type))
  QMessageBox::critical(this, "エラー", "ファイルの保存中にエラーが発生しました．");
}

void Detrial_Main::slot_export_fasta() {
 int layer = unit_num();
 if(layer == 2) {
  QMessageBox::warning(this, "警告", "片方の描画領域のみを表示して下さい．");
  return;
 }

 QFileDialog dialog(this);
 dialog.setAcceptMode(QFileDialog::AcceptSave);
 dialog.setDirectory(sharedPrm.Dir);
 dialog.selectFile("*.txt");
 dialog.setNameFilter("fasta 形式 *.txt");
 if(!dialog.exec())  //enum QDialog::DialogCode が返る
  return;

 QStringList path_list = dialog.selectedFiles();
 QString qpath = path_list[0];
 QFile file(qpath);
 if (!file.open(QIODevice::WriteOnly)) {
  QMessageBox::critical(this, "エラー", "QIODevice::WriteOnly で開くことができません．");
  return;
 }

 std::string name = qpath.toStdString();
 if(!dUnit[layer].export_fasta(&name))
  QMessageBox::critical(this, "エラー", "ファイルの保存中にエラーが発生しました．");
}

void Detrial_Main::slot_import_via_babel()
{
 int layer = unit_num();
 if(layer == 2) {
  QMessageBox::warning(this, "警告", "片方の描画領域のみを表示して下さい．");
  return;
 }

 //ファイル形式の取得
 std::string extention1;
 Dialog_Babel dialog1(this, true, extention1);
 if(dialog1.exec() == 0)  //Cancel ボタンをクリック
  return;
 if(extention1.empty())
  return;

 //ファイル名の取得
 QFileDialog dialog2(this);
 dialog2.setDirectory(sharedPrm.Dir);
 QString extention2(extention1.data());
 extention2 += " 形式 (*.";
 extention2 += extention1.data();
 extention2 += ")";
 const QStringList filters({
        extention2,
        "他の拡張子 (*.*)"});
 dialog2.setNameFilters(filters);
 if(!dialog2.exec())  //enum QDialog::DialogCode が返る
  return;

 QStringList path_list = dialog2.selectedFiles();
 QString qpath = path_list[0];
 QFile file(qpath);
 if (!file.open(QIODevice::ReadOnly)) {
  QMessageBox::critical(this, "エラー", "ファイルを開くことができません．");
  return;
 }

 sharedPrm.Dir = dialog2.directory();
 const std::string path = qpath.toStdString();
 sharedPrm.fileName[layer] = QFileInfo(qpath).fileName();

 //ファイルの読み込み
 dUnit[layer].clear();
 if(!dUnit[layer].import_via_babel(&path, &extention1)) {
  QMessageBox::critical(this, "エラー", "ファイルを開くことができません．");
  dUnit[layer].clear();
 }

 //電荷未計算のフラグ
 dUnit[layer].set_charge_calced(false);

 //セレクタの作成
 int mol_cnt = dUnit[layer].mol_cnt();
 SelectorMolAA[layer].create_mol_selector(mol_cnt);
 SelectorMolAA[layer].create_aa_selector(dUnit[layer].mol_vect());

 actionPickMode->setChecked(false);

 //描画
 unitAffine[layer].calc_center();
 unitAffine[layer].calc_radius();
 detrialDraw[layer].set_center(unitAffine[layer].get_center());
 detrialDraw[layer].set_radius(unitAffine[layer].get_radius());
 detrialDraw[layer].init_eye_pos();
 dUnit[layer].create_atom_sphere();
 slot_waals_cpk();
 //リサイズイベントを発生させないと，表示の縦横比がおかしくなる（原因不明）
 resize(width() + 1, height());
 resize(width() - 1, height());
 repaint();
}

void Detrial_Main::slot_export_via_babel() {
 int curt_unit = unit_num();
 if(!dUnit[curt_unit].atom_cnt())
  return;

 //ファイル形式（拡張子）の取得
 std::string suffix;
 Dialog_Babel dialog1(this, false, suffix);
 if(dialog1.exec() == 0)  //Cancel ボタンをクリック
  return;
 if(suffix.empty())
  return;

 //ファイル名の取得
 QFileDialog dialog2(this);
 dialog2.setAcceptMode(QFileDialog::AcceptSave);
 dialog2.setDirectory(sharedPrm.Dir);
 QString suffix2(suffix.data());
 suffix2 += " 形式 (*.";
 suffix2 += suffix.data();
 suffix2 += ")";
 const QStringList filters({
        suffix2,
        "他の拡張子 (*.*)"});
 dialog2.setNameFilters(filters);
 if(!dialog2.exec())  //enum QDialog::DialogCode が返る
  return;

 QStringList path_list = dialog2.selectedFiles();
 QString qpath = path_list[0];
 QFile file(qpath);
 if (!file.open(QIODevice::WriteOnly)) {
  QMessageBox::critical(this, "エラー", "QIODevice::WriteOnly で開くことができません．");
  return;
 }

 //拡張子とファイル形式がミスマッチの場合の処理を考える
 bool mismatch = false;
 //この名前のファイルが生成するのであとで削除
 std::string old_path = qpath.toStdString();

 QString qsuffix = QString(suffix.data());
 mismatch = !compare_suffix_and_type(qpath, qsuffix);
 //正しい拡張子を追加する
 if(mismatch) {
  qpath += '.';
  qpath += qsuffix;
 }

 std::string name = qpath.toStdString();
 if(!dUnit[curt_unit].export_via_babel(&name, &suffix))
  QMessageBox::critical(this, "エラー", "ファイルの保存中にエラーが発生しました．");

 if(mismatch)
  std::remove(old_path.data());
}

void Detrial_Main::slot_save_image() {
 QFileDialog dialog(this);
 dialog.setDirectory(sharedPrm.Dir);
 dialog.setAcceptMode(QFileDialog::AcceptSave);
 dialog.selectFile("*.png");
 dialog.setNameFilter("png 形式 *.png");
 if(!dialog.exec())  //enum QDialog::DialogCode が返る
  return;

 QStringList path_list = dialog.selectedFiles();
 QString qpath = path_list[0];
 QFile file(qpath);
 const std::string path = qpath.toStdString();
 if(!grab().save(qpath)) {
  QMessageBox::critical(this, "エラー", "保存中にエラーが発生しました．");
 }
}

