#ifndef ___DETRIAL_UNIT_H
#define ___DETRIAL_UNIT_H

#include "global.h"
#include <builcule/unit.h>
#include <GL/glu.h>

class Detrial_Unit : public Unit {
 private:
  bool chargeCalced;
  //描画スタイルに係る定値オブジェクト
  const float Radius_Cylinder_Rod;

  //参照を使い別名を付けると楽そう
  //atomSphere は，塗り分け用に 2 系統，ピック用に 1 系統
  std::array<std::vector<Sphere>, 3> atomSphere;
  //bondCylinder は，塗り分け用に 2 系統
  std::array<std::vector<Cylinder>, 2> bondCylinder;
  std::vector<Triangle> peptTriangle;
  std::vector<int> pickedSerial;

  //Align_3D に渡すデータ構造．アミノ酸数×座標（現在は N，CA，C，O の 4 個）
  std::vector<std::vector<Eigen::Vector3d>> xyzAlign3d;

  void set_atom_sphere_color_aa(int idx, const Amino_Acid *aa, int color);
  void push_bond_cylinder(const Amino_Acid &aa, int mol, int pept);
  void capture_terminal_triangle(int m, int p, int aa_cnt);  //N-末と C-末
  void capture_triangle(int m, int p, int a0, int a1, int a2);
  void push_triangle(int m, int p, int s0, int s1, int s2, int code);
  double measure_diheadral(int serial0, int serial1, int serial2, int serial3);

 public:
  //構築
  Detrial_Unit();

  bool read_1_col_data(const std::string *file_name);

  void create_atom_sphere();
  void create_bond_cylinder();
  void create_pept_triangle();

  void divide_sphere_and_cylinder_by_aa();
  void divide_sphere_and_cylinder_by_mol_selection(const std::vector<int> *selected);
  void divide_sphere_by_aa_selection(const std::vector<std::array<int, 3>> *selected);

  //編集
  void set_atom_sphere_radius(int idx, MODEL model);
  void set_atom_sphere_color(int idx, COLOR color);
  void set_bond_cylinder_radius(int idx, MODEL model);
  void set_bond_cylinder_color(int idx, COLOR color);
  void set_pept_triangle_color(COLOR color);
  //選択/非選択をアルファ値として解釈する
  void set_alpha_val(int idx, const std::vector<int> *val);
  //すべて 1.0 にする
  void init_alpha_val(int idx);

  void create_xyz_for_align3d(int mol, int pept);

  void set_charge_calced(bool val) { chargeCalced = val; }
  bool charge_calced() { return chargeCalced; }
  void clear();
  void clear_pick();

  //情報開示
  std::array<std::vector<Sphere>, 3> *atom_sphere()  //pick で編集する
      { return &atomSphere; }
  const std::array<std::vector<Cylinder>, 2> *bond_cylinder()
      { return &bondCylinder; }
  const std::vector<Triangle> *pept_triangle() { return &peptTriangle; }

  bool picked_empty() { return atomSphere[2].empty(); }
  const std::vector<int> *picked_serial();

  const std::vector<std::vector<Eigen::Vector3d>> *xyz_for_align3d()
      { return &xyzAlign3d; }

  const std::vector<std::array<int, 3>> *pick_to_neighbor_aa(double range);
  const std::vector<int> *mol_to_neighbor_atom(int mol0, int mol1, double range)
      { return AtomNear.mol_to_neighbor_atom(mol0, mol1, range); }
};

#endif
