#include "dialog_babel.h"
#include <QPushButton>

void Dialog_Babel::create_list_widget()
{
 TypeList.clear();
 for(QString str : AnnotVect)
  TypeList.addItem(str);
}

void Dialog_Babel::slot_ok_button_clicked()
{
 int cnt = TypeList.count();
 QListWidgetItem *item;
 for(int i = 0; i < cnt; ++i) {
  item = TypeList.item(i);
  if(item->isSelected()) {
   Extention = ExtVect[i].toStdString();
   accept();
   return;
  }
 }
 Extention = "";
 accept();
}

Dialog_Babel::Dialog_Babel(QWidget *parent, bool open, std::string &ext)
 : QDialog(parent),
   Extention(ext)
{
 //ウィンドウのレイアウト
 setModal(true);
 setWindowTitle("ファイル形式を選択");
 setFixedSize(460, 650);
 TypeList.setFixedSize(450, 600);

 QWidget *central_widget = new QWidget(this);
 QVBoxLayout *CentralLayout = new QVBoxLayout(this);
 central_widget->setLayout(CentralLayout);
 CentralLayout->setContentsMargins(0, 0, 0, 0);

 //ファイル形式のリストビュー
 if(open) {
  create_list_in();
 }
 else {
  create_list_out();
 }
 create_list_widget();
 CentralLayout->addWidget(&TypeList);

 //OK/Cancel ボタンを配置する
 QWidget *ok_widget = new QWidget(this);
 CentralLayout->addWidget(ok_widget);
 QHBoxLayout *ok_layout = new QHBoxLayout(ok_widget);

 QPushButton *cancel_button = new QPushButton("Cancel", this);
 cancel_button->setFixedSize(80, 30);
 connect(cancel_button,
        SIGNAL(clicked()),
        this,
        SLOT(reject()));
 ok_layout->addWidget(cancel_button);

 QPushButton *ok_button = new QPushButton("OK", this);
 ok_button->setFixedSize(80, 30);
 connect(ok_button,
        SIGNAL(clicked()),
        this,
        SLOT(slot_ok_button_clicked()));
 ok_layout->addWidget(ok_button);
}

void Dialog_Babel::create_list_in()
{
 AnnotVect.clear();
 AnnotVect.shrink_to_fit();

 AnnotVect.push_back("abinit -- ABINIT Output Format [Read-only]");
 AnnotVect.push_back("acesout -- ACES output format [Read-only]");
 AnnotVect.push_back("acr -- ACR format [Read-only]");
 AnnotVect.push_back("adfband -- ADF Band output format [Read-only]");
 AnnotVect.push_back("adfdftb -- ADF DFTB output format [Read-only]");
 AnnotVect.push_back("adfout -- ADF output format [Read-only]");
 AnnotVect.push_back("alc -- Alchemy format");
 AnnotVect.push_back("aoforce -- Turbomole AOFORCE output format [Read-only]");
 AnnotVect.push_back("arc -- Accelrys/MSI Biosym/Insight II CAR format [Read-only]");
 AnnotVect.push_back("axsf -- XCrySDen Structure Format [Read-only]");
 AnnotVect.push_back("bgf -- MSI BGF format");
 AnnotVect.push_back("box -- Dock 3.5 Box format");
 AnnotVect.push_back("bs -- Ball and Stick format");
 AnnotVect.push_back("c09out -- Crystal 09 output format [Read-only]");
 AnnotVect.push_back("c3d1 -- Chem3D Cartesian 1 format");
 AnnotVect.push_back("c3d2 -- Chem3D Cartesian 2 format");
 AnnotVect.push_back("caccrt -- Cacao Cartesian format");
 AnnotVect.push_back("can -- Canonical SMILES format");
 AnnotVect.push_back("car -- Accelrys/MSI Biosym/Insight II CAR format [Read-only]");
 AnnotVect.push_back("castep -- CASTEP format [Read-only]");
 AnnotVect.push_back("ccc -- CCC format [Read-only]");
 AnnotVect.push_back("cdjson -- ChemDoodle JSON");
 AnnotVect.push_back("cdx -- ChemDraw binary format [Read-only]");
 AnnotVect.push_back("cdxml -- ChemDraw CDXML format");
 AnnotVect.push_back("cif -- Crystallographic Information File");
 AnnotVect.push_back("ck -- ChemKin format");
 AnnotVect.push_back("cml -- Chemical Markup Language");
 AnnotVect.push_back("cmlr -- CML Reaction format");
 AnnotVect.push_back("cof -- Culgi object file format");
 AnnotVect.push_back("CONFIG -- DL-POLY CONFIG");
 AnnotVect.push_back("CONTCAR -- VASP format");
 AnnotVect.push_back("CONTFF -- MDFF format");
 AnnotVect.push_back("crk2d -- Chemical Resource Kit diagram(2D)");
 AnnotVect.push_back("crk3d -- Chemical Resource Kit 3D format");
 AnnotVect.push_back("ct -- ChemDraw Connection Table format");
 AnnotVect.push_back("cub -- Gaussian cube format");
 AnnotVect.push_back("cube -- Gaussian cube format");
 AnnotVect.push_back("dallog -- DALTON output format [Read-only]");
 AnnotVect.push_back("dalmol -- DALTON input format");
 AnnotVect.push_back("dat -- Generic Output file format [Read-only]");
 AnnotVect.push_back("dmol -- DMol3 coordinates format");
 AnnotVect.push_back("dx -- OpenDX cube format for APBS");
 AnnotVect.push_back("ent -- Protein Data Bank format");
 AnnotVect.push_back("exyz -- Extended XYZ cartesian coordinates format");
 AnnotVect.push_back("fa -- FASTA format");
 AnnotVect.push_back("fasta -- FASTA format");
 AnnotVect.push_back("fch -- Gaussian formatted checkpoint file format [Read-only]");
 AnnotVect.push_back("fchk -- Gaussian formatted checkpoint file format [Read-only]");
 AnnotVect.push_back("fck -- Gaussian formatted checkpoint file format [Read-only]");
 AnnotVect.push_back("feat -- Feature format");
 AnnotVect.push_back("fhiaims -- FHIaims XYZ format");
 AnnotVect.push_back("fract -- Free Form Fractional format");
 AnnotVect.push_back("fs -- Fastsearch format");
 AnnotVect.push_back("fsa -- FASTA format");
 AnnotVect.push_back("g03 -- Gaussian Output [Read-only]");
 AnnotVect.push_back("g09 -- Gaussian Output [Read-only]");
 AnnotVect.push_back("g16 -- Gaussian Output [Read-only]");
 AnnotVect.push_back("g92 -- Gaussian Output [Read-only]");
 AnnotVect.push_back("g94 -- Gaussian Output [Read-only]");
 AnnotVect.push_back("g98 -- Gaussian Output [Read-only]");
 AnnotVect.push_back("gal -- Gaussian Output [Read-only]");
 AnnotVect.push_back("gam -- GAMESS Output [Read-only]");
 AnnotVect.push_back("gamess -- GAMESS Output [Read-only]");
 AnnotVect.push_back("gamin -- GAMESS Input");
 AnnotVect.push_back("gamout -- GAMESS Output [Read-only]");
 AnnotVect.push_back("got -- GULP format [Read-only]");
 AnnotVect.push_back("gpr -- Ghemical format");
 AnnotVect.push_back("gro -- GRO format");
 AnnotVect.push_back("gukin -- GAMESS-UK Input");
 AnnotVect.push_back("gukout -- GAMESS-UK Output");
 AnnotVect.push_back("gzmat -- Gaussian Z-Matrix Input");
 AnnotVect.push_back("hin -- HyperChem HIN format");
 AnnotVect.push_back("HISTORY -- DL-POLY HISTORY [Read-only]");
 AnnotVect.push_back("inchi -- InChI format");
 AnnotVect.push_back("inp -- GAMESS Input");
 AnnotVect.push_back("ins -- ShelX format [Read-only]");
 AnnotVect.push_back("jin -- Jaguar input format");
 AnnotVect.push_back("jout -- Jaguar output format [Read-only]");
 AnnotVect.push_back("log -- Generic Output file format [Read-only]");
 AnnotVect.push_back("lpmd -- LPMD format");
 AnnotVect.push_back("mae -- Maestro format");
 AnnotVect.push_back("maegz -- Maestro format");
 AnnotVect.push_back("mcdl -- MCDL format");
 AnnotVect.push_back("mcif -- Macromolecular Crystallographic Info");
 AnnotVect.push_back("MDFF -- MDFF format");
 AnnotVect.push_back("mdl -- MDL MOL format");
 AnnotVect.push_back("ml2 -- Sybyl Mol2 format");
 AnnotVect.push_back("mmcif -- Macromolecular Crystallographic Info");
 AnnotVect.push_back("mmd -- MacroModel format");
 AnnotVect.push_back("mmod -- MacroModel format");
 AnnotVect.push_back("mol -- MDL MOL format");
 AnnotVect.push_back("mol2 -- Sybyl Mol2 format");
 AnnotVect.push_back("mold -- Molden format");
 AnnotVect.push_back("molden -- Molden format");
 AnnotVect.push_back("molf -- Molden format");
 AnnotVect.push_back("moo -- MOPAC Output format [Read-only]");
 AnnotVect.push_back("mop -- MOPAC Cartesian format");
 AnnotVect.push_back("mopcrt -- MOPAC Cartesian format");
 AnnotVect.push_back("mopin -- MOPAC Internal");
 AnnotVect.push_back("mopout -- MOPAC Output format [Read-only]");
 AnnotVect.push_back("mpc -- MOPAC Cartesian format");
 AnnotVect.push_back("mpo -- Molpro output format [Read-only]");
 AnnotVect.push_back("mpqc -- MPQC output format [Read-only]");
 AnnotVect.push_back("mrv -- Chemical Markup Language");
 AnnotVect.push_back("msi -- Accelrys/MSI Cerius II MSI format [Read-only]");
 AnnotVect.push_back("nwo -- NWChem output format [Read-only]");
 AnnotVect.push_back("orca -- ORCA output format [Read-only]");
 AnnotVect.push_back("out -- Generic Output file format [Read-only]");
 AnnotVect.push_back("outmol -- DMol3 coordinates format");
 AnnotVect.push_back("output -- Generic Output file format [Read-only]");
 AnnotVect.push_back("pc -- PubChem format [Read-only]");
 AnnotVect.push_back("pcjson -- PubChem JSON");
 AnnotVect.push_back("pcm -- PCModel Format");
 AnnotVect.push_back("pdb -- Protein Data Bank format");
 AnnotVect.push_back("pdbqt -- AutoDock PDBQT format");
 AnnotVect.push_back("png -- PNG 2D depiction");
 AnnotVect.push_back("pos -- POS cartesian coordinates format [Read-only]");
 AnnotVect.push_back("POSCAR -- VASP format");
 AnnotVect.push_back("POSFF -- MDFF format");
 AnnotVect.push_back("pqr -- PQR format");
 AnnotVect.push_back("pqs -- Parallel Quantum Solutions format");
 AnnotVect.push_back("prep -- Amber Prep format [Read-only]");
 AnnotVect.push_back("pwscf -- PWscf format [Read-only]");
 AnnotVect.push_back("qcout -- Q-Chem output format [Read-only]");
 AnnotVect.push_back("res -- ShelX format [Read-only]");
 AnnotVect.push_back("rsmi -- Reaction SMILES format");
 AnnotVect.push_back("rxn -- MDL RXN format");
 AnnotVect.push_back("sd -- MDL MOL format");
 AnnotVect.push_back("sdf -- MDL MOL format");
 AnnotVect.push_back("siesta -- SIESTA format [Read-only]");
 AnnotVect.push_back("smi -- SMILES format");
 AnnotVect.push_back("smiles -- SMILES format");
 AnnotVect.push_back("smy -- SMILES format using Smiley parser [Read-only]");
 AnnotVect.push_back("sy2 -- Sybyl Mol2 format");
 AnnotVect.push_back("t41 -- ADF TAPE41 format [Read-only]");
 AnnotVect.push_back("tdd -- Thermo format");
 AnnotVect.push_back("text -- Read and write raw text");
 AnnotVect.push_back("therm -- Thermo format");
 AnnotVect.push_back("tmol -- TurboMole Coordinate format");
 AnnotVect.push_back("txt -- Title format");
 AnnotVect.push_back("txyz -- Tinker XYZ format");
 AnnotVect.push_back("unixyz -- UniChem XYZ format");
 AnnotVect.push_back("VASP -- VASP format");
 AnnotVect.push_back("vmol -- ViewMol format");
 AnnotVect.push_back("wln -- Wiswesser Line Notation [Read-only]");
 AnnotVect.push_back("xml -- General XML format [Read-only]");
 AnnotVect.push_back("xsf -- XCrySDen Structure Format [Read-only]");
 AnnotVect.push_back("xtc -- XTC format [Read-only]");
 AnnotVect.push_back("xyz -- XYZ cartesian coordinates format");
 AnnotVect.push_back("yob -- YASARA.org YOB format");

 ExtVect.clear();
 ExtVect.shrink_to_fit();

 ExtVect.push_back("abinit");
 ExtVect.push_back("acesout");
 ExtVect.push_back("acr");
 ExtVect.push_back("adfband");
 ExtVect.push_back("adfdftb");
 ExtVect.push_back("adfout");
 ExtVect.push_back("alc");
 ExtVect.push_back("aoforce");
 ExtVect.push_back("arc");
 ExtVect.push_back("axsf");
 ExtVect.push_back("bgf");
 ExtVect.push_back("box");
 ExtVect.push_back("bs");
 ExtVect.push_back("c09out");
 ExtVect.push_back("c3d1");
 ExtVect.push_back("c3d2");
 ExtVect.push_back("caccrt");
 ExtVect.push_back("can");
 ExtVect.push_back("car");
 ExtVect.push_back("castep");
 ExtVect.push_back("ccc");
 ExtVect.push_back("cdjson");
 ExtVect.push_back("cdx");
 ExtVect.push_back("cdxml");
 ExtVect.push_back("cif");
 ExtVect.push_back("ck");
 ExtVect.push_back("cml");
 ExtVect.push_back("cmlr");
 ExtVect.push_back("cof");
 ExtVect.push_back("CONFIG");
 ExtVect.push_back("CONTCAR");
 ExtVect.push_back("CONTFF");
 ExtVect.push_back("crk2d");
 ExtVect.push_back("crk3d");
 ExtVect.push_back("ct");
 ExtVect.push_back("cub");
 ExtVect.push_back("cube");
 ExtVect.push_back("dallog");
 ExtVect.push_back("dalmol");
 ExtVect.push_back("dat");
 ExtVect.push_back("dmol");
 ExtVect.push_back("dx");
 ExtVect.push_back("ent");
 ExtVect.push_back("exyz");
 ExtVect.push_back("fa");
 ExtVect.push_back("fasta");
 ExtVect.push_back("fch");
 ExtVect.push_back("fchk");
 ExtVect.push_back("fck");
 ExtVect.push_back("feat");
 ExtVect.push_back("fhiaims");
 ExtVect.push_back("fract");
 ExtVect.push_back("fs");
 ExtVect.push_back("fsa");
 ExtVect.push_back("g03");
 ExtVect.push_back("g09");
 ExtVect.push_back("g16");
 ExtVect.push_back("g92");
 ExtVect.push_back("g94");
 ExtVect.push_back("g98");
 ExtVect.push_back("gal");
 ExtVect.push_back("gam");
 ExtVect.push_back("gamess");
 ExtVect.push_back("gamin");
 ExtVect.push_back("gamout");
 ExtVect.push_back("got");
 ExtVect.push_back("gpr");
 ExtVect.push_back("gro");
 ExtVect.push_back("gukin");
 ExtVect.push_back("gukout");
 ExtVect.push_back("gzmat");
 ExtVect.push_back("hin");
 ExtVect.push_back("HISTORY");
 ExtVect.push_back("inchi");
 ExtVect.push_back("inp");
 ExtVect.push_back("ins");
 ExtVect.push_back("jin");
 ExtVect.push_back("jout");
 ExtVect.push_back("log");
 ExtVect.push_back("lpmd");
 ExtVect.push_back("mae");
 ExtVect.push_back("maegz");
 ExtVect.push_back("mcdl");
 ExtVect.push_back("mcif");
 ExtVect.push_back("MDFF");
 ExtVect.push_back("mdl");
 ExtVect.push_back("ml2");
 ExtVect.push_back("mmcif");
 ExtVect.push_back("mmd");
 ExtVect.push_back("mmod");
 ExtVect.push_back("mol");
 ExtVect.push_back("mol2");
 ExtVect.push_back("mold");
 ExtVect.push_back("molden");
 ExtVect.push_back("molf");
 ExtVect.push_back("moo");
 ExtVect.push_back("mop");
 ExtVect.push_back("mopcrt");
 ExtVect.push_back("mopin");
 ExtVect.push_back("mopout");
 ExtVect.push_back("mpc");
 ExtVect.push_back("mpo");
 ExtVect.push_back("mpqc");
 ExtVect.push_back("mrv");
 ExtVect.push_back("msi");
 ExtVect.push_back("nwo");
 ExtVect.push_back("orca");
 ExtVect.push_back("out");
 ExtVect.push_back("outmol");
 ExtVect.push_back("output");
 ExtVect.push_back("pc");
 ExtVect.push_back("pcjson");
 ExtVect.push_back("pcm");
 ExtVect.push_back("pdb");
 ExtVect.push_back("pdbqt");
 ExtVect.push_back("png");
 ExtVect.push_back("pos");
 ExtVect.push_back("POSCAR");
 ExtVect.push_back("POSFF");
 ExtVect.push_back("pqr");
 ExtVect.push_back("pqs");
 ExtVect.push_back("prep");
 ExtVect.push_back("pwscf");
 ExtVect.push_back("qcout");
 ExtVect.push_back("res");
 ExtVect.push_back("rsmi");
 ExtVect.push_back("rxn");
 ExtVect.push_back("sd");
 ExtVect.push_back("sdf");
 ExtVect.push_back("siesta");
 ExtVect.push_back("smi");
 ExtVect.push_back("smiles");
 ExtVect.push_back("smy");
 ExtVect.push_back("sy2");
 ExtVect.push_back("t41");
 ExtVect.push_back("tdd");
 ExtVect.push_back("text");
 ExtVect.push_back("therm");
 ExtVect.push_back("tmol");
 ExtVect.push_back("txt");
 ExtVect.push_back("txyz");
 ExtVect.push_back("unixyz");
 ExtVect.push_back("VASP");
 ExtVect.push_back("vmol");
 ExtVect.push_back("wln");
 ExtVect.push_back("xml");
 ExtVect.push_back("xsf");
 ExtVect.push_back("xtc");
 ExtVect.push_back("xyz");
 ExtVect.push_back("yob");
}

void Dialog_Babel::create_list_out()
{
 AnnotVect.clear();
 AnnotVect.shrink_to_fit();

 AnnotVect.push_back("acesin -- ACES input format [Write-only]");
 AnnotVect.push_back("adf -- ADF cartesian input format [Write-only]");
 AnnotVect.push_back("alc -- Alchemy format");
 AnnotVect.push_back("ascii -- ASCII format [Write-only]");
 AnnotVect.push_back("bgf -- MSI BGF format");
 AnnotVect.push_back("box -- Dock 3.5 Box format");
 AnnotVect.push_back("bs -- Ball and Stick format");
 AnnotVect.push_back("c3d1 -- Chem3D Cartesian 1 format");
 AnnotVect.push_back("c3d2 -- Chem3D Cartesian 2 format");
 AnnotVect.push_back("cac -- CAChe MolStruct format [Write-only]");
 AnnotVect.push_back("caccrt -- Cacao Cartesian format");
 AnnotVect.push_back("cache -- CAChe MolStruct format [Write-only]");
 AnnotVect.push_back("cacint -- Cacao Internal format [Write-only]");
 AnnotVect.push_back("can -- Canonical SMILES format");
 AnnotVect.push_back("cdjson -- ChemDoodle JSON");
 AnnotVect.push_back("cdxml -- ChemDraw CDXML format");
 AnnotVect.push_back("cht -- Chemtool format [Write-only]");
 AnnotVect.push_back("cif -- Crystallographic Information File");
 AnnotVect.push_back("ck -- ChemKin format");
 AnnotVect.push_back("cml -- Chemical Markup Language");
 AnnotVect.push_back("cmlr -- CML Reaction format");
 AnnotVect.push_back("cof -- Culgi object file format");
 AnnotVect.push_back("com -- Gaussian Input [Write-only]");
 AnnotVect.push_back("confabreport -- Confab report format [Write-only]");
 AnnotVect.push_back("CONFIG -- DL-POLY CONFIG");
 AnnotVect.push_back("CONTCAR -- VASP format");
 AnnotVect.push_back("CONTFF -- MDFF format");
 AnnotVect.push_back("copy -- Copy raw text [Write-only]");
 AnnotVect.push_back("crk2d -- Chemical Resource Kit diagram(2D)");
 AnnotVect.push_back("crk3d -- Chemical Resource Kit 3D format");
 AnnotVect.push_back("csr -- Accelrys/MSI Quanta CSR format [Write-only]");
 AnnotVect.push_back("cssr -- CSD CSSR format [Write-only]");
 AnnotVect.push_back("ct -- ChemDraw Connection Table format");
 AnnotVect.push_back("cub -- Gaussian cube format");
 AnnotVect.push_back("cube -- Gaussian cube format");
 AnnotVect.push_back("dalmol -- DALTON input format");
 AnnotVect.push_back("dmol -- DMol3 coordinates format");
 AnnotVect.push_back("dx -- OpenDX cube format for APBS");
 AnnotVect.push_back("ent -- Protein Data Bank format");
 AnnotVect.push_back("exyz -- Extended XYZ cartesian coordinates format");
 AnnotVect.push_back("fa -- FASTA format");
 AnnotVect.push_back("fasta -- FASTA format");
 AnnotVect.push_back("feat -- Feature format");
 AnnotVect.push_back("fh -- Fenske-Hall Z-Matrix format [Write-only]");
 AnnotVect.push_back("fhiaims -- FHIaims XYZ format");
 AnnotVect.push_back("fix -- SMILES FIX format [Write-only]");
 AnnotVect.push_back("fps -- FPS text fingerprint format (Dalke) [Write-only]");
 AnnotVect.push_back("fpt -- Fingerprint format [Write-only]");
 AnnotVect.push_back("fract -- Free Form Fractional format");
 AnnotVect.push_back("fs -- Fastsearch format");
 AnnotVect.push_back("fsa -- FASTA format");
 AnnotVect.push_back("gamin -- GAMESS Input");
 AnnotVect.push_back("gau -- Gaussian Input [Write-only]");
 AnnotVect.push_back("gjc -- Gaussian Input [Write-only]");
 AnnotVect.push_back("gjf -- Gaussian Input [Write-only]");
 AnnotVect.push_back("gpr -- Ghemical format");
 AnnotVect.push_back("gr96 -- GROMOS96 format [Write-only]");
 AnnotVect.push_back("gro -- GRO format");
 AnnotVect.push_back("gukin -- GAMESS-UK Input");
 AnnotVect.push_back("gukout -- GAMESS-UK Output");
 AnnotVect.push_back("gzmat -- Gaussian Z-Matrix Input");
 AnnotVect.push_back("hin -- HyperChem HIN format");
 AnnotVect.push_back("inchi -- InChI format");
 AnnotVect.push_back("inchikey -- InChIKey [Write-only]");
 AnnotVect.push_back("inp -- GAMESS Input");
 AnnotVect.push_back("jin -- Jaguar input format");
 AnnotVect.push_back("k -- Compare molecules using InChI [Write-only]");
 AnnotVect.push_back("lmpdat -- The LAMMPS data format [Write-only]");
 AnnotVect.push_back("lpmd -- LPMD format");
 AnnotVect.push_back("mae -- Maestro format");
 AnnotVect.push_back("maegz -- Maestro format");
 AnnotVect.push_back("mcdl -- MCDL format");
 AnnotVect.push_back("mcif -- Macromolecular Crystallographic Info");
 AnnotVect.push_back("MDFF -- MDFF format");
 AnnotVect.push_back("mdl -- MDL MOL format");
 AnnotVect.push_back("ml2 -- Sybyl Mol2 format");
 AnnotVect.push_back("mmcif -- Macromolecular Crystallographic Info");
 AnnotVect.push_back("mmd -- MacroModel format");
 AnnotVect.push_back("mmod -- MacroModel format");
 AnnotVect.push_back("mna -- Multilevel Neighborhoods of Atoms (MNA) [Write-only]");
 AnnotVect.push_back("mol -- MDL MOL format");
 AnnotVect.push_back("mol2 -- Sybyl Mol2 format");
 AnnotVect.push_back("mold -- Molden format");
 AnnotVect.push_back("molden -- Molden format");
 AnnotVect.push_back("molf -- Molden format");
 AnnotVect.push_back("molreport -- Open Babel molecule report [Write-only]");
 AnnotVect.push_back("mop -- MOPAC Cartesian format");
 AnnotVect.push_back("mopcrt -- MOPAC Cartesian format");
 AnnotVect.push_back("mopin -- MOPAC Internal");
 AnnotVect.push_back("mp -- Molpro input format [Write-only]");
 AnnotVect.push_back("mpc -- MOPAC Cartesian format");
 AnnotVect.push_back("mpd -- MolPrint2D format [Write-only]");
 AnnotVect.push_back("mpqcin -- MPQC simplified input format [Write-only]");
 AnnotVect.push_back("mrv -- Chemical Markup Language");
 AnnotVect.push_back("msms -- M.F. Sanner's MSMS input format [Write-only]");
 AnnotVect.push_back("nul -- Outputs nothing [Write-only]");
 AnnotVect.push_back("nw -- NWChem input format [Write-only]");
 AnnotVect.push_back("orcainp -- ORCA input format [Write-only]");
 AnnotVect.push_back("outmol -- DMol3 coordinates format");
 AnnotVect.push_back("paint -- Painter format [Write-only]");
 AnnotVect.push_back("pcjson -- PubChem JSON");
 AnnotVect.push_back("pcm -- PCModel Format");
 AnnotVect.push_back("pdb -- Protein Data Bank format");
 AnnotVect.push_back("pdbqt -- AutoDock PDBQT format");
 AnnotVect.push_back("png -- PNG 2D depiction");
 AnnotVect.push_back("pointcloud -- Point cloud on VDW surface [Write-only]");
 AnnotVect.push_back("POSCAR -- VASP format");
 AnnotVect.push_back("POSFF -- MDFF format");
 AnnotVect.push_back("pov -- POV-Ray input format [Write-only]");
 AnnotVect.push_back("pqr -- PQR format");
 AnnotVect.push_back("pqs -- Parallel Quantum Solutions format");
 AnnotVect.push_back("qcin -- Q-Chem input format [Write-only]");
 AnnotVect.push_back("report -- Open Babel report format [Write-only]");
 AnnotVect.push_back("rinchi -- RInChI [Write-only]");
 AnnotVect.push_back("rsmi -- Reaction SMILES format");
 AnnotVect.push_back("rxn -- MDL RXN format");
 AnnotVect.push_back("sd -- MDL MOL format");
 AnnotVect.push_back("sdf -- MDL MOL format");
 AnnotVect.push_back("smi -- SMILES format");
 AnnotVect.push_back("smiles -- SMILES format");
 AnnotVect.push_back("stl -- STL 3D-printing format [Write-only]");
 AnnotVect.push_back("svg -- SVG 2D depiction [Write-only]");
 AnnotVect.push_back("sy2 -- Sybyl Mol2 format");
 AnnotVect.push_back("tdd -- Thermo format");
 AnnotVect.push_back("text -- Read and write raw text");
 AnnotVect.push_back("therm -- Thermo format");
 AnnotVect.push_back("tmol -- TurboMole Coordinate format");
 AnnotVect.push_back("txt -- Title format");
 AnnotVect.push_back("txyz -- Tinker XYZ format");
 AnnotVect.push_back("unixyz -- UniChem XYZ format");
 AnnotVect.push_back("VASP -- VASP format");
 AnnotVect.push_back("vmol -- ViewMol format");
 AnnotVect.push_back("xed -- XED format [Write-only]");
 AnnotVect.push_back("xyz -- XYZ cartesian coordinates format");
 AnnotVect.push_back("yob -- YASARA.org YOB format");
 AnnotVect.push_back("zin -- ZINDO input format [Write-only]");

 ExtVect.clear();
 ExtVect.shrink_to_fit();

 ExtVect.push_back("acesin");
 ExtVect.push_back("adf");
 ExtVect.push_back("alc");
 ExtVect.push_back("ascii");
 ExtVect.push_back("bgf");
 ExtVect.push_back("box");
 ExtVect.push_back("bs");
 ExtVect.push_back("c3d1");
 ExtVect.push_back("c3d2");
 ExtVect.push_back("cac");
 ExtVect.push_back("caccrt");
 ExtVect.push_back("cache");
 ExtVect.push_back("cacint");
 ExtVect.push_back("can");
 ExtVect.push_back("cdjson");
 ExtVect.push_back("cdxml");
 ExtVect.push_back("cht");
 ExtVect.push_back("cif");
 ExtVect.push_back("ck");
 ExtVect.push_back("cml");
 ExtVect.push_back("cmlr");
 ExtVect.push_back("cof");
 ExtVect.push_back("com");
 ExtVect.push_back("confabreport");
 ExtVect.push_back("CONFIG");
 ExtVect.push_back("CONTCAR");
 ExtVect.push_back("CONTFF");
 ExtVect.push_back("copy");
 ExtVect.push_back("crk2d");
 ExtVect.push_back("crk3d");
 ExtVect.push_back("csr");
 ExtVect.push_back("cssr");
 ExtVect.push_back("ct");
 ExtVect.push_back("cub");
 ExtVect.push_back("cube");
 ExtVect.push_back("dalmol");
 ExtVect.push_back("dmol");
 ExtVect.push_back("dx");
 ExtVect.push_back("ent");
 ExtVect.push_back("exyz");
 ExtVect.push_back("fa");
 ExtVect.push_back("fasta");
 ExtVect.push_back("feat");
 ExtVect.push_back("fh");
 ExtVect.push_back("fhiaims");
 ExtVect.push_back("fix");
 ExtVect.push_back("fps");
 ExtVect.push_back("fpt");
 ExtVect.push_back("fract");
 ExtVect.push_back("fs");
 ExtVect.push_back("fsa");
 ExtVect.push_back("gamin");
 ExtVect.push_back("gau");
 ExtVect.push_back("gjc");
 ExtVect.push_back("gjf");
 ExtVect.push_back("gpr");
 ExtVect.push_back("gr96");
 ExtVect.push_back("gro");
 ExtVect.push_back("gukin");
 ExtVect.push_back("gukout");
 ExtVect.push_back("gzmat");
 ExtVect.push_back("hin");
 ExtVect.push_back("inchi");
 ExtVect.push_back("inchikey");
 ExtVect.push_back("inp");
 ExtVect.push_back("jin");
 ExtVect.push_back("k");
 ExtVect.push_back("lmpdat");
 ExtVect.push_back("lpmd");
 ExtVect.push_back("mae");
 ExtVect.push_back("maegz");
 ExtVect.push_back("mcdl");
 ExtVect.push_back("mcif");
 ExtVect.push_back("MDFF");
 ExtVect.push_back("mdl");
 ExtVect.push_back("ml2");
 ExtVect.push_back("mmcif");
 ExtVect.push_back("mmd");
 ExtVect.push_back("mmod");
 ExtVect.push_back("mna");
 ExtVect.push_back("mol");
 ExtVect.push_back("mol2");
 ExtVect.push_back("mold");
 ExtVect.push_back("molden");
 ExtVect.push_back("molf");
 ExtVect.push_back("molreport");
 ExtVect.push_back("mop");
 ExtVect.push_back("mopcrt");
 ExtVect.push_back("mopin");
 ExtVect.push_back("mp");
 ExtVect.push_back("mpc");
 ExtVect.push_back("mpd");
 ExtVect.push_back("mpqcin");
 ExtVect.push_back("mrv");
 ExtVect.push_back("msms");
 ExtVect.push_back("nul");
 ExtVect.push_back("nw");
 ExtVect.push_back("orcainp");
 ExtVect.push_back("outmol");
 ExtVect.push_back("paint");
 ExtVect.push_back("pcjson");
 ExtVect.push_back("pcm");
 ExtVect.push_back("pdb");
 ExtVect.push_back("pdbqt");
 ExtVect.push_back("png");
 ExtVect.push_back("pointcloud");
 ExtVect.push_back("POSCAR");
 ExtVect.push_back("POSFF");
 ExtVect.push_back("pov");
 ExtVect.push_back("pqr");
 ExtVect.push_back("pqs");
 ExtVect.push_back("qcin");
 ExtVect.push_back("report");
 ExtVect.push_back("rinchi");
 ExtVect.push_back("rsmi");
 ExtVect.push_back("rxn");
 ExtVect.push_back("sd");
 ExtVect.push_back("sdf");
 ExtVect.push_back("smi");
 ExtVect.push_back("smiles");
 ExtVect.push_back("stl");
 ExtVect.push_back("svg");
 ExtVect.push_back("sy2");
 ExtVect.push_back("tdd");
 ExtVect.push_back("text");
 ExtVect.push_back("therm");
 ExtVect.push_back("tmol");
 ExtVect.push_back("txt");
 ExtVect.push_back("txyz");
 ExtVect.push_back("unixyz");
 ExtVect.push_back("VASP");
 ExtVect.push_back("vmol");
 ExtVect.push_back("xed");
 ExtVect.push_back("xyz");
 ExtVect.push_back("yob");
 ExtVect.push_back("zin");
}

