#include "domain_draw.h"
#include <random>

Domain_Draw::Domain_Draw(QWidget *parent,
        std::vector<Atom> *atom,
        const std::vector<Mol> *mol,
        const std::map<int, int> *serial,
        const Shared_Prm *prm)
 : Draw_Base(parent, atom, mol, serial, prm),
   DomCnt(0)
{}

void Domain_Draw::create_objects() {
 k_means();
 create_sphere();
}

void Domain_Draw::create_sphere() {
 SphereForDraw.clear();
 SphereForDraw.shrink_to_fit();

 //球をプッシュ
 Atom_Distance distance;
 const std::array<double, ELMT_CNT> &VdwRadius
        = distance.vdw_radius();
 Sphere sphere;

 int atom_cnt = AtomVect->size();
 for(int i = 0; i < atom_cnt; ++i) {
  const Atom &atom = (*AtomVect)[i];
  sphere.Serial = atom.serialNum;
  sphere.Pos = &atom.XYZ;
  sphere.Radius = VdwRadius[atom.Elmt];
  int color_num = AfterDomIdx[i] % 6;
  for(int j = 0; j != 4; ++j)
   sphere.Color[j] = molColor[color_num][j];
  SphereForDraw.push_back(sphere);
 }
}

void Domain_Draw::k_means() {
 //乱数で仮の中心を発生させる
 //非決定的な乱数生成器を生成
 std::random_device rnd;
 //メルセンヌ・ツイスタの32ビット版．引数は初期シード値
 std::mt19937 mt(rnd());
 double radius = Affine.get_radius();
 std::uniform_int_distribution<> rand100(-radius, radius);
 Eigen::Vector3d v = Eigen::Vector3d::Zero(3);
 DomCenter.assign(DomCnt, v);
 for(int i = 0; i < DomCnt; ++i) {
  for(int j = 0; j < 3; ++j) {
   DomCenter[i][j] = (double)rand100(mt);
  }
 }

 //仮のクラスター番号を格納しておく
 int atom_cnt = AtomVect->size();
 BeforeDomIdx.assign(atom_cnt, 0);
 AfterDomIdx.assign(atom_cnt, 0);
 while(k_means_1_cycle())
  BeforeDomIdx = AfterDomIdx;
}

int Domain_Draw::k_means_1_cycle() {
 //各原子のクラスターの中心までの距離を測定し，クラスターをアップデート
 int atom_cnt = AtomVect->size();
 for(int i = 0; i < atom_cnt; ++i) {
  int dom_idx = BeforeDomIdx[i];
  double norm0 = ((*AtomVect)[i].XYZ - DomCenter[dom_idx]).norm();
  for(int j = 0; j < DomCnt; ++j) {
   double norm1 = ((*AtomVect)[i].XYZ - DomCenter[j]).norm();
   if(norm1 < norm0) {
    AfterDomIdx[i] = j;
    norm0 = norm1;
   }
  }
 }

 //アップデートされたクラスターの中心を計算
 for(int i = 0; i < DomCnt; ++i) {
  Eigen::Vector3d new_center = Eigen::Vector3d::Zero(3);
  int cnt = 0;
  for(int j = 0; j < atom_cnt; j++) {
   if(AfterDomIdx[j] == i) {
    new_center += (*AtomVect)[j].XYZ;
    ++cnt;
   }
  }
  new_center /= (double)cnt;
  DomCenter[i] = new_center;
 }

 //所属が変更になった原子の数を返却
 int cnt = 0;
 for(int i = 0; i < atom_cnt; ++i)
  if(BeforeDomIdx[i] != AfterDomIdx[i])
   ++cnt;
 return cnt;
}

