#ifndef ___DOMAIN_DRAW_H
#define ___DOMAIN_DRAW_H

#include "draw_base.h"

class Domain_Draw : public Draw_Base {
 private:
  int DomCnt;
  std::vector<Eigen::Vector3d> DomCenter;
  std::vector<int> BeforeDomIdx;
  std::vector<int> AfterDomIdx;

  void k_means();
  int k_means_1_cycle();
  void create_sphere();

 public:
  Domain_Draw(QWidget *parent,
        std::vector<Atom> *atom,
        const std::vector<Mol> *mol,
        const std::map<int, int> *serial,
        const Shared_Prm *prm);

  void set_domain_cnt(int n) { DomCnt = n; }
  void create_objects();
};

#endif
