#include "domain_window.h"
#include <QBoxLayout>
#include <QLabel>
#include <QMenuBar>
#include <QMessageBox>
#include <QPushButton>

Domain_Window::Domain_Window(QWidget *parent,
        std::vector<Atom> *atom,
        const std::vector<Mol> *mol,
        const std::map<int, int> *serial,
        Shared_Prm *prm)
 : QMainWindow(parent),
   SharedPrm(prm),
   DomainDraw(this, atom, mol, serial, prm)
{
 setWindowModality(Qt::WindowModal);
 setWindowFlags(windowFlags() | Qt::WindowStaysOnTopHint);

 //メニューバー
 QMenuBar *menu_Bar(menuBar());
 QMenu *menuFile = new QMenu("ファイル(&F)", menu_Bar);
 menu_Bar->addMenu(menuFile);

 QAction *actionQuit = new QAction("終了(&Q)", menuFile);
 menuFile->addAction(actionQuit);
 connect(actionQuit, SIGNAL(triggered()), this, SLOT(close()));

 //セントラルウィジェット
 QWidget *widget_central = new QWidget(this);
 setCentralWidget(widget_central);
 QVBoxLayout *layout_central = new QVBoxLayout(widget_central);

 //描画ウィジェット
 layout_central->addWidget(&DomainDraw);
 DomainDraw.setFocus();

 //設定ウィジェット
 QWidget *widget_setting = new QWidget(this);
 widget_setting->setMaximumWidth(350);
 layout_central->addWidget(widget_setting);

 QHBoxLayout *layout_setting = new QHBoxLayout(widget_setting);

 QLabel *label_thres
        = new QLabel("検知したいドメイン数(2〜9)", widget_setting);
 label_thres->setMaximumWidth(210);
 layout_setting->addWidget(label_thres);


 LEDomCnt = new QLineEdit("2");
 LEDomCnt->setMaximumWidth(100);
 layout_setting->addWidget(LEDomCnt);

 QPushButton *pb_detect = new QPushButton("検知", widget_setting);
 LEDomCnt->setMaximumWidth(50);
 connect(pb_detect,
        SIGNAL(clicked()),
        this,
        SLOT(detect()));
 layout_setting->addWidget(pb_detect);

 //上の設定値で初期描画
 QString str = LEDomCnt->text();
 int cnt = str.toInt();
 DomainDraw.set_domain_cnt(cnt);
 DomainDraw.create_objects();
}

void Domain_Window::detect() {
 QString str = LEDomCnt->text();
 if(str.isEmpty()) {
  QMessageBox::critical(this, "エラー", "閾値が空欄です．");
  return;
 }
 double cnt = str.toDouble();
 if(cnt < 2 || 10 < cnt) {
  QMessageBox::critical(this, "エラー", "設定値が範囲外です．");
  return;
 }

 DomainDraw.set_domain_cnt(cnt);
 DomainDraw.create_objects();
 DomainDraw.repaint();
}

void Domain_Window::keyPressEvent(QKeyEvent *event) {
 if(event->key() == Qt::Key_X) {
  SharedPrm->KeyX = true;
  SharedPrm->KeyZ = false;
 }
 else if(event->key() == Qt::Key_Z) {
  SharedPrm->KeyX = false;
  SharedPrm->KeyZ = true;
 }
}

void Domain_Window::keyReleaseEvent(QKeyEvent *event) {
 if(event->key() == Qt::Key_X)
  SharedPrm->KeyX = false;
 else if(event->key() == Qt::Key_Z)
  SharedPrm->KeyZ = false;
}

