#ifndef ___DRAW_BASE_H
#define ___DRAW_BASE_H


//Detrial-2 向け試作品


#include <builcule/affine_trans_2.h>
#include "global.h"
#include <QOpenGLWidget>
#include <QMouseEvent>
#include <QWheelEvent>

class Draw_Base : public QOpenGLWidget {
 protected:
//現バージョンでは同名の構造体が global に存在する
struct Sphere {
 int Serial;  //ピック用に必要か
 const Eigen::Vector3d *Pos;
 double Radius;
 float Color[4];
 Sphere()
  : Serial(-1), Pos(nullptr), Radius(0.1f), Color{atomColor[0][0], atomColor[0][1], atomColor[0][2], atomColor[0][3]} {}
};

struct Cylinder {
 const Eigen::Vector3d *Pos0;
 const Eigen::Vector3d *Pos1;
 double Radius;
 float Color[4];
 Cylinder()
  : Pos0(nullptr), Pos1(nullptr), Radius(0.2f), Color{atomColor[0][0], atomColor[0][1], atomColor[0][2], atomColor[0][3]} {}
};

struct Cone {
 const Eigen::Vector3d *Pos0;
 const Eigen::Vector3d *Pos1;
 double Radius;
 float Color[4];
 Cone()
  : Pos0(nullptr), Pos1(nullptr), Radius(0.2f), Color{atomColor[0][0], atomColor[0][1], atomColor[0][2], atomColor[0][3]} {}
};

struct Triangle {
 const Eigen::Vector3d *Pos0;
 const Eigen::Vector3d *Pos1;
 const Eigen::Vector3d *Pos2;
 float Color[4];
 Triangle()
  : Pos0(nullptr), Pos1(nullptr), Pos2(nullptr), Color{atomColor[0][0], atomColor[0][1], atomColor[0][2], atomColor[0][3]} {}
};

struct Wire {
 const Eigen::Vector3d *Pos0;
 const Eigen::Vector3d *Pos1;
 float Color[4];
 Wire()
  : Pos0(nullptr), Pos1(nullptr), Color{atomColor[0][0], atomColor[0][1], atomColor[0][2], atomColor[0][3]} {}
};





 private:
  //クラス内部のオブジェクト
  Qt::MouseButton PressedButton;
//  GLUquadricObj *QSurface;

  //クラス外部のオブジェクト
  const Shared_Prm *SharedPrm;

  //Qt のイベントハンドラ
  void mousePressEvent(QMouseEvent *event) final;
  void mouseMoveEvent(QMouseEvent *event) final;
  void mouseReleaseEvent(QMouseEvent *event) final;
  void wheelEvent(QWheelEvent *event) final;

  //Qt のイベントハンドラ呼び出される関数
  void rotate_all_atom_xy(int ox, int oy);
  virtual void rotate_other_object_xy(int, int) {};
  void move_eye(int ox, int oy);

  //OpenGL による描画
  void initializeGL() override final;
  void resizeGL(int width, int height) override final;
  void paintGL() override final;
  void set_projection();
  void set_lookat();
  void draw_sphere();
  void draw_picked_sphere();
  void draw_cylinder();
  void draw_cone();
  void draw_triangle();
  void draw_wire();

 protected:
  //クラス外部のオブジェクト
  const std::vector<Atom> *AtomVect;
  const std::vector<Mol> *MolVect;

  const std::map<int, int> *SerialToIdx;

  //クラス内部のオブジェクト
  GLUquadricObj *QSurface;
  int MouseX;
  int MouseY;
  double MouseMoveLength;
  Affine_Trans_2 Affine;
  const Eigen::Vector3d ZAxis;
  std::vector<Sphere> SphereForDraw;
  std::vector<Sphere> PickedSphereForDraw;  //AtomSphere を上書き
  std::vector<Cylinder> CylinderForDraw;
  std::vector<Cone> ConeForDraw;
  std::vector<Triangle> TriangleForDraw;
  std::vector<Wire> WireForDraw;

 public:
  //Unit を引数にするほうがよさそう
  Draw_Base(QWidget *parent,
        std::vector<Atom> *atom,
        const std::vector<Mol> *mol,
        const std::map<int, int> *serial,
        const Shared_Prm *SharedPrm);
  virtual void create_objects() = 0;
  void display() { paintGL(); }
  //下記のバリエーションも可能
  //void set_view_pos_atom(int atom);
  //void set_view_pos_mol(int mol);
  //void set_view_pos_aa(const std::array<int, 3> *aa);
  void pick();
  void clear_pick();
};

#endif

/*
半透明化はきれいに描画できない（GPU 描画が必要か？）
void Draw_Base::draw_sphere_selection_mode() {
 //glDisable(GL_CULL_FACE);
 //glDisable(GL_DEPTH_TEST);
 //glDepthMask(GL_FALSE);
 //glEnable(GL_BLEND);
 //glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

 for(const Sphere &sphere : *atomSphere) {
  glMaterialfv(GL_FRONT, GL_DIFFUSE, sphere.Color);
  glPushMatrix();
  const Eigen::Vector3d *xyz = sphere.Pos;
  glTranslated((*xyz)[0], (*xyz)[1], (*xyz)[2]);
  gluSphere(quadricSurface, sphere.Radius, Slices, Stacks);
  glPopMatrix();
 }

 //glDisable(GL_BLEND);
 //glDepthMask(GL_TRUE);
 //glEnable(GL_DEPTH_TEST);
 //glEnable(GL_CULL_FACE);
 //glDisable(GL_ALPHA_TEST);
}
*/
