#ifndef ___global_H
#define ___global_H

#include <builcule/affine.h>
#include <builcule/superimpose.h>
#include <GL/glu.h>
#include <QDir>

extern std::array<Affine, 2> unitAffine;

//描画オブジェクト１．Detrial_Unit で作成して Detrial_Draw で描画
struct Sphere {
 int Serial;
 Eigen::Vector3d *Pos;
 int Elmt;
 double Radius;
 float Color[4];
 Sphere()
  : Serial(-1), Pos(nullptr), Elmt(-1), Radius(0.1f), Color{atomColor[0][0], atomColor[0][1], atomColor[0][2], atomColor[0][3]} {}
};

//描画オブジェクト２．Detrial_Unit で作成して Detrial_Draw で描画
struct Cylinder {
 int molIdx;  //着色用
 int peptIdx;  //着色用
 char aaCode;  //着色用
 int Serial0;
 int Serial1;
 const Eigen::Vector3d *Pos0;
 const Eigen::Vector3d *Pos1;
 double Radius;
 float Color[4];
 Cylinder()
  : molIdx(-1), peptIdx(-1), aaCode('X'), Serial0(-1), Serial1(-1), Pos0(nullptr), Pos1(nullptr), Radius(0.2f), Color{atomColor[0][0], atomColor[0][1], atomColor[0][2], atomColor[0][3]} {}
};

//描画オブジェクト３．Detrial_Unit で作成して Detrial_Draw で描画
struct Triangle {
 int molIdx;  //着色用
 int peptIdx;  //着色用
 char aaCode;  //着色用
 int Secondary;  //二次構造の着色用．molColor を格納．0 == 赤色，2 == 黄色
 int Serial0;
 int Serial1;
 int Serial2;
 const Eigen::Vector3d *Pos0;
 const Eigen::Vector3d *Pos1;
 const Eigen::Vector3d *Pos2;
 bool mainChain;
 float Color[4];
 Triangle()
  : molIdx(-1), peptIdx(-1), aaCode('X'), Secondary(1), Serial0(-1), Serial1(-1), Serial2(-1), Pos0(nullptr), Pos1(nullptr), Pos2(nullptr), mainChain(true), Color{atomColor[0][0], atomColor[0][1], atomColor[0][2], atomColor[0][3]} {}
};

//共有パラメータ（原子用と結合用とが混在している）
enum MODEL {VDW, BALL, STICK, ROD, WIRE, RIBBON, DEFAULT_MODEL};
enum COLOR {CPK, MOL, PEPT, AA, SECONDARY, MONO, CHARGE, DEFAULT_COLOR};

 //描画の設定はレイヤ 0， 1 について idx0，idx1，および idx2 を設定
struct Style {
 MODEL AtomModel;
 COLOR AtomColor;
 MODEL BondModel;
 COLOR BondColor;

 Style()
  : AtomModel(DEFAULT_MODEL),
    AtomColor(DEFAULT_COLOR),
    BondModel(DEFAULT_MODEL),
    BondColor(DEFAULT_COLOR)
    {}
};

struct Shared_Prm {
 QDir Dir;
 QString fileName[2];
 bool KeyA;
 bool KeyX;
 bool KeyZ;
 std::array<std::array<std::vector<MODEL>, 2>, 2> Model;
 COLOR Color[2][2];
 GLenum Quadric[2][2];
 int ModelColorID[2][2];  //設定ウィンドウのラジオボタンの ID
 bool drawDivideMode;
 bool moveSelected;
 bool pickMode;
 bool aaSelectionMode;
 int GapIni;
 int GapElg;
 int AaRepl;

 Shared_Prm();
};

#endif
