#ifndef ___H_BOND_DRAW_H
#define ___H_BOND_DRAW_H

#include "draw_base.h"
#include <builcule/adjacent_atom.h>

class H_Bond_Draw : public Draw_Base {
 private:
  const std::array<double, ELMT_CNT> &CovRadius;
  Adjacent_Atom Adj;
  const double AtomRadius;
  const double BondRadius;
  const double HBondRadius;
  double LengthMax;
  double AngleMax;
  double AngleMin;
  std::vector<std::array<int, 2>> DonorIdx;
  std::vector<std::array<int, 2>> AcceptorIdx;
  std::vector<std::array<int, 2>> HBondIdx;

  void detect_h_bond();
  void check_o(int idx);
  void check_n(int idx);
  void check_s(int idx);
  bool imidazole_n(int idx);
  bool check_length(int idx_d, int idx_a);
  bool check_angle(int d0, int d1, int a0);

  void create_sphere();
  void create_cylinder();

 public:
  H_Bond_Draw(QWidget *parent,
        std::vector<Atom> *atom,
        const std::vector<Mol> *mol,
        const std::map<int, int> *serial,
        const Shared_Prm *prm);
  void set_length_max(double l) { LengthMax = l; }
  void set_angle_max(double a) { AngleMax = a; }
  void set_angle_min(double a) { AngleMin = a; }
  void detect();
  void create_objects();
};

#endif
