#include "h_bond_window.h"
#include <QBoxLayout>
#include <QLabel>
#include <QMenuBar>
#include <QMessageBox>
#include <QPushButton>

H_Bond_Window::H_Bond_Window(QWidget *parent,
        std::vector<Atom> *atom,
        const std::vector<Mol> *mol,
        const std::map<int, int> *serial,
        Shared_Prm *prm)
 : QMainWindow(parent),
   SharedPrm(prm),
   HBondDraw(this, atom, mol, serial, prm)
{
 setWindowModality(Qt::WindowModal);
 setWindowFlags(windowFlags() | Qt::WindowStaysOnTopHint);

 //メニューバー
 QMenuBar *menu_Bar(menuBar());
 QMenu *menuFile = new QMenu("ファイル(&F)", menu_Bar);
 menu_Bar->addMenu(menuFile);

 QAction *actionQuit = new QAction("終了(&Q)", menuFile);
 menuFile->addAction(actionQuit);
 connect(actionQuit, SIGNAL(triggered()), this, SLOT(close()));

 //セントラルウィジェット
 QWidget *widget_central = new QWidget(this);
 setCentralWidget(widget_central);
 QHBoxLayout *layout_central = new QHBoxLayout(widget_central);

 //描画ウィジェット
 layout_central->addWidget(&HBondDraw);
 HBondDraw.setFocus();

 //設定ウィジェット
 QWidget *setting_widget = new QWidget(this);
 setting_widget->setMaximumWidth(210);

 layout_central->addWidget(setting_widget);
 QVBoxLayout *setting_layout = new QVBoxLayout(setting_widget);
 setting_layout->setAlignment(Qt::AlignTop);

 QLabel *l_length = new QLabel("最大長(Å, < 4.0)", setting_widget);
 setting_layout->addWidget(l_length);
 ELengthMax = new QLineEdit("2.5", setting_widget);
 setting_layout->addWidget(ELengthMax);

 QLabel *l_angle_min = new QLabel("最小角(°, 0.0 <)", setting_widget);
 setting_layout->addWidget(l_angle_min);
 EAngleMin = new QLineEdit("120.0", setting_widget);
 setting_layout->addWidget(EAngleMin);

 QLabel *l_angle_max = new QLabel("最大角(°, < 180.0)", setting_widget);
 setting_layout->addWidget(l_angle_max);
 EAngleMax = new QLineEdit("179.9", setting_widget);
 setting_layout->addWidget(EAngleMax);

 QPushButton *pb_detect = new QPushButton("検知", setting_widget);
 setting_layout->addWidget(pb_detect);
 connect(pb_detect,
        SIGNAL(clicked()),
        this,
        SLOT(detect()));

 //上の設定値で初期描画
 QString str = ELengthMax->text();
 double val = str.toDouble();
 HBondDraw.set_length_max(val);

 str = EAngleMin->text();
 val = str.toDouble();
 HBondDraw.set_angle_min(val);

 str = EAngleMax->text();
 val = str.toDouble();
 HBondDraw.set_angle_max(val);

 HBondDraw.detect();
 HBondDraw.create_objects();
}

void H_Bond_Window::detect() {
 QString str = ELengthMax->text();
 double length_max = str.toDouble();
 if(str.isEmpty()) {
  QMessageBox::critical(this, "エラー", "最大長が空欄です．");
  return;
 }
 if(length_max <= 0.0 || 4.0 <= length_max) {
  QMessageBox::critical(this, "エラー", "最大長が範囲外です．");
  return;
 }

 str = EAngleMin->text();
 double angle_min = str.toDouble();
 if(str.isEmpty()) {
  QMessageBox::critical(this, "エラー", "最小角が空欄です．");
  return;
 }
 if(angle_min <= 0.0) {
  QMessageBox::critical(this, "エラー", "最小角が範囲外です．");
  return;
 }

 str = EAngleMax->text();
 double angle_max = str.toDouble();
 if(str.isEmpty()) {
  QMessageBox::critical(this, "エラー", "最大角が空欄です．");
  return;
 }
 if(180.0 <= angle_max) {
  QMessageBox::critical(this, "エラー", "最大角が範囲外です．");
  return;
 }

 if(angle_max < angle_min) {
  QMessageBox::critical(this, "エラー", "角度の設定が異常です．");
  return;
 }

 HBondDraw.set_length_max(length_max);
 HBondDraw.set_angle_min(angle_min);
 HBondDraw.set_angle_max(angle_max);

 HBondDraw.detect();
 HBondDraw.create_objects();
 HBondDraw.repaint();
}

void H_Bond_Window::keyPressEvent(QKeyEvent *event) {
 if(event->key() == Qt::Key_X) {
  SharedPrm->KeyX = true;
  SharedPrm->KeyZ = false;
 }
 else if(event->key() == Qt::Key_Z) {
  SharedPrm->KeyX = false;
  SharedPrm->KeyZ = true;
 }
}

void H_Bond_Window::keyReleaseEvent(QKeyEvent *event) {
 if(event->key() == Qt::Key_X)
  SharedPrm->KeyX = false;
 else if(event->key() == Qt::Key_Z)
  SharedPrm->KeyZ = false;
}

