#ifndef ___H_BOND_WINDOW_H
#define ___H_BOND_WINDOW_H

#include "h_bond_draw.h"
#include <QMainWindow>
#include <QLineEdit>

class H_Bond_Window : public QMainWindow {
 Q_OBJECT

 private:
  Shared_Prm *SharedPrm;
  H_Bond_Draw HBondDraw;
  QLineEdit *ELengthMax;
  QLineEdit *EAngleMin;
  QLineEdit *EAngleMax;

  void keyPressEvent(QKeyEvent *event) override;
  void keyReleaseEvent(QKeyEvent *event) override;

 private slots:
  void detect();

 public:
  H_Bond_Window(QWidget *parent,
        std::vector<Atom> *atom,
        const std::vector<Mol> *mol,
        const std::map<int, int> *serial,
        Shared_Prm *prm);
};

#endif
