#ifndef PLOT_WINDOW_H
#define PLOT_WINDOW_H

#include <QMainWindow>
#include <QLineEdit>
#include <QPushButton>
#include <QWidget>

class Plot_Widget : public QWidget {
 private:
  const std::vector<std::vector<double>> *scoreMtx;
  std::array<double, 4> *Level;
  double *Threshold;

  std::array<QColor, 5> Color;
  int margin;
  void draw_frame();
  void draw_dot();

 public:
  Plot_Widget(QWidget *parent = nullptr);
  void set_score_mtx(const std::vector<std::vector<double>> *mtx)
      { scoreMtx = mtx; }
  void set_level(std::array<double, 4> *level)
      { Level = level; }
  void set_threshold(double *thres) { Threshold = thres; }
  void paintEvent(QPaintEvent *) override;
  void plot() { repaint(); }
};

class Plot_Window : public QMainWindow {
 Q_OBJECT

 private:
  Plot_Widget *plotWidget;
  QLineEdit *leThres;
  QPushButton *pbReplot;
  QPushButton *pbClose;

  std::vector<std::vector<double>> scoreMtx;
  std::array<double, 4> Level;
  double Threshold;

  void calc_level();
  double score_max();
  double score_min();

 private slots:
  void slot_replot();
  void slot_close();

 public:
  Plot_Window(QWidget *parent = nullptr);
  void set_score_mtx(const std::vector<std::vector<double>> *mtx);
  void set_window_size();
  void replot() { slot_replot(); }
};

#endif
