#include "selector.h"
#include <QHeaderView>

Selector::Selector(QWidget *parent)
 : QWidget(parent),
   listWidgetMol(this),
   tableWidgetAA(this),
   pickedSphere(nullptr),
   serialToIdx(nullptr),
   atomVect(nullptr)
{
 Code1to3['C'] = "Cys";  Code1to3['S'] = "Ser";  Code1to3['T'] = "Thr";
 Code1to3['P'] = "Pro";  Code1to3['A'] = "Ala";  Code1to3['G'] = "Gly";
 Code1to3['N'] = "Asn";  Code1to3['D'] = "Asp";  Code1to3['E'] = "Glu";
 Code1to3['Q'] = "Gln";  Code1to3['H'] = "His";  Code1to3['R'] = "Arg";
 Code1to3['K'] = "Lys";  Code1to3['M'] = "Met";  Code1to3['I'] = "Ile";
 Code1to3['L'] = "Leu";  Code1to3['V'] = "Val";  Code1to3['F'] = "Phe";
 Code1to3['Y'] = "Tyr";  Code1to3['W'] = "Trp";  Code1to3['c'] = "cys";
 Code1to3['p'] = "Hpy";

 //全体のパッキングに使うレイアウト
 QVBoxLayout *layout_central = new QVBoxLayout(this);
 layout_central->addWidget(&labelTitle);  //ラベルを挿入

 //リストと操作ボタンを載せるウィジェット
 QWidget *widget_ma = new QWidget(this);
 layout_central->addWidget(widget_ma);

 //widget_ma を widget_m と widget_a に分ける
 QHBoxLayout *layout_ma = new QHBoxLayout(widget_ma);

 //分子とアミノ酸のリストおよびプッシュボタンを載せるために 2 列に分ける
 QWidget *widget_m = new QWidget(widget_ma);
 QVBoxLayout *layout_m = new QVBoxLayout(widget_m);
 layout_ma->addWidget(widget_m);
 QWidget *widget_a = new QWidget(widget_ma);
 QVBoxLayout *layout_a = new QVBoxLayout(widget_a);
 layout_ma->addWidget(widget_a);

 //分子セレクター
 //ラベル
 QLabel *label_mol = new QLabel("分子リスト", widget_m);
 layout_m->addWidget(label_mol);

 //リスト
 listWidgetMol.setSelectionMode(QAbstractItemView::ExtendedSelection);
 layout_m->addWidget(&listWidgetMol);

 //分子の操作ボタン
 buttonMolClear = new QPushButton("選択をクリア", widget_m);
 buttonMolClear->setToolTip("上のリストでの選択を解除します");
 layout_m->addWidget(buttonMolClear);
 connect(buttonMolClear, SIGNAL(clicked()), this, SLOT(slot_mol_selection_clear()));

 buttonMolInvert = new QPushButton("選択を反転", widget_m);
 buttonMolInvert->setToolTip("上のリストでの選択 / 非選択を交換します");
 layout_m->addWidget(buttonMolInvert);
 connect(buttonMolInvert, SIGNAL(clicked()), this, SLOT(slot_mol_selection_invert()));

 buttonMolPick = new QPushButton("ピックを選択", widget_m);
 buttonMolPick->setToolTip("ピックされた分子を上のリストで選択状態にします");
 layout_m->addWidget(buttonMolPick);
 connect(buttonMolPick, SIGNAL(clicked()), this, SLOT(slot_mol_selection_pick()));

 //アミノ酸セレクター
 //ラベル
 QLabel *label_aa = new QLabel("アミノ酸リスト", widget_a);
 layout_a->addWidget(label_aa);

 //リスト
 tableWidgetAA.setColumnCount(4);
 tableWidgetAA.setHorizontalHeaderLabels(
     QStringList() << "mol" << "pept" << "seq" << "code");
 tableWidgetAA.horizontalHeader()
     ->setSectionResizeMode(QHeaderView::ResizeToContents);
 tableWidgetAA.verticalHeader()->setVisible(false);
 tableWidgetAA.setSelectionMode(QAbstractItemView::ExtendedSelection);
 tableWidgetAA.setSelectionBehavior(QAbstractItemView::SelectRows);
 tableWidgetAA.resizeColumnsToContents();
 layout_a->addWidget(&tableWidgetAA);

 //アミノ酸の操作ボタン
 buttonAAClear = new QPushButton("選択をクリア", widget_a);
 buttonAAClear->setToolTip("上のリストでの選択を解除します");
 layout_a->addWidget(buttonAAClear);
 connect(buttonAAClear, SIGNAL(clicked()), this, SLOT(slot_aa_selection_clear()));

 buttonAAInvert = new QPushButton("選択を反転", widget_a);
 buttonAAInvert->setToolTip("上のリストでの選択 / 非選択を交換します");
 layout_a->addWidget(buttonAAInvert);
 connect(buttonAAInvert, SIGNAL(clicked()), this, SLOT(slot_aa_selection_invert()));

 buttonAAPick = new QPushButton("ピックを選択", widget_a);
 buttonAAPick->setToolTip("ピックされた分子を上のリストで選択状態にします");
 layout_a->addWidget(buttonAAPick);
 connect(buttonAAPick, SIGNAL(clicked()), this, SLOT(slot_aa_selection_pick()));

 //選択の変更時
 connect(&listWidgetMol, SIGNAL(itemSelectionChanged()), this, SLOT(slot_mol_selection_changed()));

 //サイズポリシー
 layout_ma->setContentsMargins(0, 0, 0, 0);
 layout_m->setContentsMargins(0, 0, 0, 0);
 layout_a->setContentsMargins(0, 0, 0, 0);
 listWidgetMol.setMaximumWidth(100);
 tableWidgetAA.setMaximumWidth(150);
}

void Selector::set_label(int layer) {
 if(layer)
  labelTitle.setText("レイヤ 1");
 else
  labelTitle.setText("レイヤ 0");
}

void Selector::create_mol_selector(int mol_cnt) {
 listWidgetMol.clear();
 for(int i = 0; i < mol_cnt; ++i)
  listWidgetMol.addItem(QString::number(i));

 molSelection.assign(mol_cnt, 0);
}

void Selector::create_aa_selector(const std::vector<Mol> *mol_vect) {
 tableWidgetAA.clearContents();  //ヘッダは残して全てのコンテンツを削除

 //QTableWidgetItem の行数と列数を設定
 int aa_cnt = 0;  //行数
 for(const Mol &mol : *mol_vect)
  for(const std::vector<Amino_Acid> &peptide : mol.aaTable)
   aa_cnt += peptide.size();
 tableWidgetAA.setRowCount(aa_cnt);
 tableWidgetAA.setColumnCount(4);

 //QTableWidgetItem にデータを格納
 int row_num = 0;
 int mol_cnt = mol_vect->size();
 for(int i = 0; i < mol_cnt; ++i) {
  int pept_cnt = (*mol_vect)[i].aaTable.size();
  for(int j = 0; j < pept_cnt; ++j) {
   int aa_cnt = (*mol_vect)[i].aaTable[j].size();
   for(int k = 0; k < aa_cnt; ++k) {

    QTableWidgetItem *item0 = new QTableWidgetItem();
    item0->setFlags(item0->flags() ^ Qt::ItemIsEditable);
    item0->setData(Qt::DisplayRole, i);
    tableWidgetAA.setItem(row_num, 0, item0);

    QTableWidgetItem *item1 = new QTableWidgetItem();
    item1->setFlags(item1->flags() ^ Qt::ItemIsEditable);
    item1->setData(Qt::DisplayRole, j);
    tableWidgetAA.setItem(row_num, 1, item1);

    QTableWidgetItem *item2 = new QTableWidgetItem();
    item2->setFlags(item2->flags() ^ Qt::ItemIsEditable);
    item2->setData(Qt::DisplayRole, k);
    tableWidgetAA.setItem(row_num, 2, item2);

    QTableWidgetItem *item3 = new QTableWidgetItem();
    item3->setFlags(item3->flags() ^ Qt::ItemIsEditable);
    const Amino_Acid &aa = (*mol_vect)[i].aaTable[j][k];
    item3->setData(Qt::DisplayRole, QString::fromStdString(aa.Code3));
    tableWidgetAA.setItem(row_num, 3, item3);

    ++row_num;
   }
  }
 }

 //{分子番号，ペプチド番号，アミノ酸番号} と QTableWidgetItem へのポインタとの関連付け
 //煩雑になりそうだったので，QTableWidgetItem の作成と別途作成した
 PtrItemAA.clear();
 PtrItemAA.shrink_to_fit();

 row_num = 0;
 for(int i = 0; i < mol_cnt; ++i) {
  PtrItemAA.push_back(std::vector<std::vector<QTableWidgetItem *>>());
  int pept_cnt = (*mol_vect)[i].aaTable.size();
  for(int j = 0; j < pept_cnt; ++j) {
   PtrItemAA[i].push_back(std::vector<QTableWidgetItem *>());
   int aa_cnt = (*mol_vect)[i].aaTable[j].size();
   for(int k = 0; k < aa_cnt; ++k) {
    PtrItemAA[i][j].push_back(tableWidgetAA.item(row_num++, 0));
   }
  }
 }
}

void Selector::slot_mol_selection_clear() {
 int cnt = listWidgetMol.count();
 for(int i = 0; i < cnt; ++i) {
  listWidgetMol.item(i)->setSelected(false);
 }
}

void Selector::slot_mol_selection_invert() {
 QListWidgetItem *item;
 int cnt = listWidgetMol.count();
 for(int i = 0; i < cnt; ++i) {
  item = listWidgetMol.item(i);
  if(item->isSelected())
   item->setSelected(false);
  else
   item->setSelected(true);
 }
}

void Selector::slot_mol_selection_pick() {
 for(const Sphere &sphere : *pickedSphere) {
  int idx = serialToIdx->at(sphere.Serial);
  listWidgetMol.item((*atomVect)[idx].molIdx)->setSelected(true);
 }
}

void Selector::slot_aa_selection_clear() {
 int cnt = tableWidgetAA.rowCount();
 for(int i = 0; i < cnt; ++i) {
  for(int j = 0; j < 4; ++j)
   tableWidgetAA.item(i, j)->setSelected(false);
 }
}

void Selector::slot_aa_selection_invert() {
 QTableWidgetItem *item;
 int cnt = tableWidgetAA.rowCount();
 for(int i = 0; i < cnt; ++i) {
  for(int j = 0; j < 4; ++j) {
   item = tableWidgetAA.item(i, j);
   if(item->isSelected())
    item->setSelected(false);
   else
    item->setSelected(true);
  }
 }
}

void Selector::slot_aa_selection_pick() {
 for(const Sphere &sphere : *pickedSphere) {
  int idx = serialToIdx->at(sphere.Serial);
  select_aa((*atomVect)[idx].molIdx, (*atomVect)[idx].peptIdx, (*atomVect)[idx].aaIdx);
 }
}

void Selector::select_aa(int mol, int pept, int aa) {
 PtrItemAA[mol][pept][aa]->setSelected(true);
 int row = PtrItemAA[mol][pept][aa]->row();
 for(int i = 1; i < 4; ++i)
  tableWidgetAA.item(row, i)->setSelected(true);
}

void Selector::select_aa(const std::vector<std::array<int, 3>> *aa_num) {
 for(const std::array<int, 3> row : *aa_num)
  select_aa(row[0], row[1], row[2]);
}

const std::vector<std::array<int, 3>> *Selector::selected_aa() {
 selectedAA.clear();
 selectedAA.shrink_to_fit();

 std::array<int, 3> aa_idx{-1, -1, -1};
 int cnt = tableWidgetAA.rowCount();
 for(int i = 0; i < cnt; ++i) {
  QTableWidgetItem *item = tableWidgetAA.item(i, 0);
  if(item->isSelected()) {
   aa_idx[0] = (item->data(Qt::DisplayRole)).toInt();
   item = tableWidgetAA.item(i, 1);
   aa_idx[1] = (item->data(Qt::DisplayRole)).toInt();
   item = tableWidgetAA.item(i, 2);
   aa_idx[2] = (item->data(Qt::DisplayRole)).toInt();
   selectedAA.push_back(aa_idx);
  }
 }
 return &selectedAA;
}

void Selector::slot_mol_selection_changed() {
 selectedMol.clear();
 selectedMol.shrink_to_fit();

 int cnt = listWidgetMol.count();
 for(int i = 0; i < cnt; ++i) {
  QListWidgetItem *item = listWidgetMol.item(i);
  if(item->isSelected()) {
   selectedMol.push_back(i);
  }
 }
}

