#ifndef ___SELECTOR_H
#define ___SELECTOR_H

#include "global.h"
#include <builcule/mol.h>
#include <QBoxLayout>
#include <QLabel>
#include <QListWidget>
#include <QMouseEvent>
#include <QPushButton>
#include <QTableWidget>

class Selector : public QWidget {
 Q_OBJECT  //これが無いと，シグナルとスロットをコネクトできない

 private:
  std::map<char, std::string> Code1to3;

  //Detrial_Main のコンストラクタでシグナルを接続するのでポインタにはしない
  QListWidget listWidgetMol;  //これを表示する
  //tableWidgetAA 関連オブジェクト
  QTableWidget tableWidgetAA;  //これを表示する

  //tableWidgetAA の第一列のアイテムへのポインタの三次元テーブル
  //分子番号，ペプチド番号，およびアミノ酸番号で行指定が簡単になる
  std::vector<std::vector<std::vector<QTableWidgetItem *>>> PtrItemAA;
  std::vector<int> molSelection;  //選択か非選択かを格納．常にチェック
  std::vector<int> selectedMol;  //選択されている分子のみ．常にチェック
  std::vector<std::array<int, 3>> selectedAA;  //用時調整

  const std::vector<Sphere> *pickedSphere;
  const std::map<int, int> *serialToIdx;
  const std::vector<Atom> *atomVect;  //各種インデックスが記述されている

  QLabel labelTitle;

  //ボタン類
  QPushButton *buttonMolClear;
  QPushButton *buttonMolInvert;
  QPushButton *buttonMolPick;
  QPushButton *buttonAAClear;
  QPushButton *buttonAAInvert;
  QPushButton *buttonAAPick;

 private slots:
  //リストウィジェット，テーブルウィジェット，ボタン類のスロット
  void slot_mol_selection_invert();
  void slot_mol_selection_clear();
  void slot_mol_selection_pick();
  void slot_aa_selection_clear();
  void slot_aa_selection_invert();
  void slot_aa_selection_pick();
  void slot_mol_selection_changed();  //選択分子のみ回転・移動するのに必要

 public:
  Selector(QWidget *parent = nullptr);
  //構築
  void set_label(int layer);
  void set_picked_sphere(const std::vector<Sphere> *picked)
      { pickedSphere = picked; }
  void set_serial_to_atom_idx(const std::map<int, int> *serial_idx)
      { serialToIdx = serial_idx; }
  void set_atom_vect(const std::vector<Atom> *atom) { atomVect = atom; }
  void create_mol_selector(int mol_cnt);
  void create_aa_selector(const std::vector<Mol> *mol_vect);
  //情報開示
  const std::vector<int> *mol_selection() const { return &molSelection; }
  const std::vector<int> *selected_mol() { return &selectedMol; }
  const std::vector<std::array<int, 3>> *selected_aa();
  //編集
  void select_aa(int mol, int pept, int aa);
  void select_aa(const std::vector<std::array<int, 3>> *aa_num);
  void aa_selection_clear() { slot_aa_selection_clear(); }
};

#endif
