#include "seq_window.h"
#include <QFileDialog>
#include <QMenuBar>
#include <QMessageBox>
#include <QScrollArea>
#include <QTextStream>

Seq_Window::Seq_Window(QWidget *parent)
 : QMainWindow(parent),
   widgetCentral(nullptr),
   layoutData(nullptr),
   layoutSeq(nullptr),
   labelMolInfo0(nullptr),
   labelMolInfo1(nullptr),
   labelCondition(nullptr),
   molNum{-1, -1},
   peptNum{-1, -1},
   peptIni{-1, -1},
   peptEnd{-1, -1},
   Score(-1.0),
   Window(-1),
   gepIni(-1.0),
   gapElg(-1.0),
   Threshold(-1.0),
   aaRepl(-1),
   Weight(-1.0)
{
 //ウィンドウを表示しているあいだは，メインウィンドウでの操作を禁止する
 setWindowModality(Qt::WindowModal);
 setWindowFlags(windowFlags() | Qt::WindowStaysOnTopHint);

 setWindowTitle("アラインメント");

 QMenuBar *menu_Bar(menuBar());
 QMenu *menuFile = new QMenu("ファイル(&F)", this);
 menu_Bar->addMenu(menuFile);

 QAction *actionSaveText = new QAction("テキストとして保存(&T)", menu_Bar);
 menuFile->addAction(actionSaveText);
 connect(actionSaveText, SIGNAL(triggered()), this, SLOT(slot_save_text()));

 QAction *actionSaveImage = new QAction("画像として保存(&I)", menu_Bar);
 menuFile->addAction(actionSaveImage);
 connect(actionSaveImage, SIGNAL(triggered()), this, SLOT(slot_save_image()));

 QAction *actionQuit = new QAction("閉じる(&C)", menu_Bar);
 menuFile->addAction(actionQuit);
 connect(actionQuit, SIGNAL(triggered()), this, SLOT(close()));

 widgetCentral = new QWidget(this);
 QVBoxLayout *layout_central = new QVBoxLayout(widgetCentral);

 QWidget *widget_data = new QWidget(widgetCentral);
 QVBoxLayout *layout_data = new QVBoxLayout(widget_data);


 labelMolInfo0 = new QLabel(widget_data);
 labelMolInfo1 = new QLabel(widget_data);
 labelCondition = new QLabel(widget_data);

 QScrollArea *scroll_seq  = new QScrollArea(widgetCentral);
 QWidget *widget_seq = new QWidget(scroll_seq);
 layoutSeq = new QGridLayout(widget_seq);

 setCentralWidget(widgetCentral);
 layout_central->addWidget(widget_data);
 layout_data->addWidget(labelMolInfo0);
 layout_data->addWidget(labelMolInfo1);
 layout_data->addWidget(labelCondition);
 layout_central->addWidget(scroll_seq);
 scroll_seq->setWidget(widget_seq);
 scroll_seq->setWidgetResizable(true);
 widget_seq->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);
 layoutSeq->setSpacing(0);

 QPalette palt = scroll_seq->palette();
 palt.setColor(QPalette::Window, Qt::white);
 scroll_seq->setPalette(palt);

 palt = widget_seq->palette();
 palt.setColor(QPalette::Window, Qt::white);
 widget_seq->setPalette(palt);

 qColor['D'] = Qt::red;  qColor['E'] = Qt::red;

 qColor['H'] = Qt::blue;  qColor['K'] = Qt::blue;
 qColor['R'] = Qt::blue;

 qColor['C'] = Qt::yellow;
 qColor['c'] = Qt::yellow;

 qColor['G'] = Qt::green;  qColor['N'] = Qt::green;
 qColor['Q'] = Qt::green;  qColor['S'] = Qt::green;
 qColor['T'] = Qt::green;  qColor['Y'] = Qt::green;

 qColor['A'] = Qt::white;  qColor['F'] = Qt::white;
 qColor['I'] = Qt::white;  qColor['L'] = Qt::white;
 qColor['M'] = Qt::white;  qColor['P'] = Qt::white;
 qColor['V'] = Qt::white;  qColor['W'] = Qt::white;
 qColor['-'] = Qt::white;
}

void Seq_Window::set_info_mol(int layer, const QString *file, int mol, int pept, int ini, int end) {
 fileName[layer] = *file;
 molNum[layer] = mol;
 peptNum[layer] = pept;
 peptIni[layer] = ini;
 peptEnd[layer] = end;

 QString separate("   ");

 QString str(*file);
 str += separate;
 str += QString("分子：");
 str += QString::number(mol);
 str += separate;
 str += QString("ペプチド : ");
 str += QString::number(pept);
 str += separate;
 str += QString("開始 : ");
 str += QString::number(ini);
 str += separate;
 str += QString("終了：");
 str += QString::number(end);

 if(layer == 0)
  labelMolInfo0->setText(str);
 else if(layer == 1)
  labelMolInfo1->setText(str);
}


void Seq_Window::set_info_condition(double score, int win, double ini, double elg, double thres, int repl, double weight) {
 Score = score;
 Window = win;
 gepIni = ini;
 gapElg = elg;
 Threshold = thres;
 aaRepl = repl;
 Weight = weight;

 QString separate("   ");

 QString str("スコア : ");
 str += QString::number(score, 'f', 2);
 str += separate;
 str += QString("ウィンドウ : ");
 str += QString::number(win);
 str += separate;
 str += QString("ギャップ開始：");
 str += QString::number(ini, 'f', 1);  //小数点以下 1 桁で表示
 str += separate;
 str += ("ギャップ伸長 : ");
 str += QString::number(elg, 'f', 1);
 str += separate;
 str += QString("閾値 : ");
 str += QString::number(thres, 'f', 1);
 str += separate;
 str += QString("置換行列：");
 if(repl == 0)
  str += QString("PAM250");
 else
  str += QString("BLOSUM62");
 str += separate;
 str += QString("ウェイト：");
 str += QString::number(weight, 'f', 1);
 labelCondition->setText(str);
}

void Seq_Window::set_align(const std::array<std::vector<char>, 2> *align) {
 //出力しやすいように整形しておく
 for(std::vector<char> &vect : Alignment) {
  vect.clear();
  vect.shrink_to_fit();
 }
 int cnt = (*align)[0].size();
 Alignment[0].assign(cnt, ' ');  //25 文字ごとに '+' を表示
 Alignment[1] = (*align)[0];
 Alignment[2].assign(cnt, ' ');  //一致すれば '*' を表示
 Alignment[3] = (*align)[1];
 int num = 25;
 while(num < cnt) {
  if(num % 100)
   Alignment[0][num] = '+';
  num += 25;
 }
 for(int i = 0; i != cnt; ++i)
  if(Alignment[1][i] == Alignment[3][i])
   Alignment[2][i] = '*';

 //ウィジェットに出力
 QPalette pltt;
 QColor color;
 char code = 'X';
 int row0 = 0;
 int row1 = 1;
 int row2 = 2;
 int row3 = 3;
 int row4 = 4;
 for(int i = 0; i != cnt; ++i) {
  int column = i % 100;

  if(!column && i) {
   QLabel *label4 = new QLabel(this);
   label4->setText(" ");
   layoutSeq->addWidget(label4, row4, column);

   row0 += 5;
   row1 += 5;
   row2 += 5;
   row3 += 5;
   row4 += 5;
  }

  if(Alignment[0][i] == '+') {
   QLabel *label0 = new QLabel(this);
   label0->setText("+");
   layoutSeq->addWidget(label0, row0, column);
  }

  QLabel *label1 = new QLabel(this);
  code = Alignment[1][i];
  pltt = label1->palette();
  color = qColor[code];
  pltt.setColor(QPalette::Window, color);  //背景色
  if(color == Qt::blue || color == Qt::red)
   pltt.setColor(QPalette::WindowText, Qt::white);  //文字色
  label1->setAutoFillBackground(true);
  label1->setPalette(pltt);
  label1->setText(QString(code));
  layoutSeq->addWidget(label1, row1, column);

  if(Alignment[2][i] == '*') {
   QLabel *label2 = new QLabel(this);
   label2->setText("*");
   layoutSeq->addWidget(label2, row2, column);
  }

  QLabel *label3 = new QLabel(this);
  code = Alignment[3][i];
  pltt = label3->palette();
  color = qColor[code];
  pltt.setColor(QPalette::Window, color);  //背景色
  if(color == Qt::blue || color == Qt::red)
   pltt.setColor(QPalette::WindowText, Qt::white);  //文字色
  label3->setAutoFillBackground(true);
  label3->setPalette(pltt);
  label3->setText(QString(code));
  layoutSeq->addWidget(label3, row3, column);
 }
}

void Seq_Window::slot_save_image() {
 QFileDialog dialog(this);
 dialog.setAcceptMode(QFileDialog::AcceptSave);
 dialog.selectFile("*.png");
 dialog.setNameFilter("png 形式 *.png");
 if(!dialog.exec())  //enum QDialog::DialogCode が返る
  return;

 QStringList path_list = dialog.selectedFiles();
 QString qpath = path_list[0];
 QFile file(qpath);
 const std::string path = qpath.toStdString();
 if(!widgetCentral->grab().save(qpath)) {
  QMessageBox::critical(this, "エラー", "保存中にエラーが発生しました．");
 }
}

void Seq_Window::slot_save_text() {
 QFileDialog dialog(this);
 dialog.setAcceptMode(QFileDialog::AcceptSave);
 dialog.selectFile("*.txt");
 dialog.setNameFilter("txt 形式 *.txt;;拡張子未定 *");
 if(!dialog.exec())  //enum QDialog::DialogCode が返る
  return;

 QStringList path_list = dialog.selectedFiles();
 QString qpath = path_list[0];
 QFile file(qpath);
 if (file.open(QIODevice::WriteOnly)) {
  QTextStream out(&file);

  for(int i = 0; i != 2; ++i)
   out << fileName[i] << QString("   分子 : ") << QString::number(molNum[i]) << QString("   ペプチド : ") << QString::number(peptNum[i]) << QString("   開始 : ") << QString::number(peptIni[i]) << QString("   終了 : ") << QString::number(peptEnd[i]) << Qt::endl;

 int col_cnt = 100;
 int aa_cnt = Alignment[0].size();
 int pos_start = 0;
 int pos_end = col_cnt;
 for(int i = 0; i != aa_cnt && pos_end < aa_cnt; ++i) {
  for(int j = 0; j != 4; ++j) {
   for(int k = pos_start; k != pos_end; ++k)
    out << Alignment[j][k];
   out << Qt::endl;
  }
  out << Qt::endl;
  pos_start += col_cnt;
  pos_end += col_cnt;
 }

 pos_end = aa_cnt;
 for(int j = 0; j != 4; ++j) {
  for(int k = pos_start; k != pos_end; ++k)
   out << Alignment[j][k];
  out << Qt::endl;
 }

  file.close();
 }
 else {
  QMessageBox::critical(this, "エラー", "ファイルの書き込み中にエラーが発生しました．");
 }
}

