#ifndef SEQ_WINDOW_H
#define SEQ_WINDOW_H

#include <QGridLayout>
#include <QLabel>
#include <QMainWindow>

class Seq_Window : public QMainWindow {
 Q_OBJECT

 private:
  QWidget *widgetCentral;
  QVBoxLayout *layoutData;
  QGridLayout *layoutSeq;
  QLabel *labelMolInfo0;
  QLabel *labelMolInfo1;
  QLabel *labelCondition;

  std::map<char, QColor> qColor;
  std::array<std::vector<char>, 4> Alignment;  //表示・保存用に整形したもの

  //ファイル保存用
  int layer;
  QString fileName[2];
  int molNum[2];
  int peptNum[2];
  int peptIni[2];
  int peptEnd[2];
  double Score;
  int Window;
  double gepIni;
  double gapElg;
  double Threshold;
  int aaRepl;
  double Weight;

 private slots:
  void slot_save_image();
  void slot_save_text();

 public:
  Seq_Window(QWidget *parent = nullptr);
  void set_info_mol(int layer, const QString *file, int mol, int pept, int ini, int end);
  void set_info_condition(double score, int win, double ini, double elg, double thres, int repl, double weight);
  void set_align(const std::array<std::vector<char>, 2> *align);
};

#endif
