#ifndef ___STATISTICS_DRAW_H
#define ___STATISTICS_DRAW_H

#include "draw_base.h"

class Statistics_Draw : public Draw_Base {
 private:
  //計算用オブジェクト
  std::array<double, 3> Mean;
  Eigen::Matrix3d CovMtx;  //ソルバに投入
  Eigen::Matrix3d EigenVect;
  Eigen::Vector3d EigenVal;
  std::array<std::array<Eigen::Vector3d, 2>, 6> ConeXYZ;

  void calc_mean_var_cov();
  void calc_var(int c0);
  void calc_cov(int c0, int c1);
  void calc_eigen_vect();

  void create_wire();
  void create_cone();

  void draw_other_object();
  void rotate_other_object_xy(int ox, int oy);

 public:
  Statistics_Draw(QWidget *parent,
        std::vector<Atom> *atom,
        const std::vector<Mol> *mol,
        const std::map<int, int> *serial,
        const Shared_Prm *prm);
  void create_objects();
};

#endif
