#ifndef ___VDW_CONTACT_DRAW_H
#define ___VDW_CONTACT_DRAW_H

#include "draw_base.h"

class VDW_Contact_Draw : public Draw_Base {
 private:
  double Thres;
  std::vector<std::vector<bool>> VdwContact;

  void exclude_bound_pair(int idx0, std::vector<bool> &row);
  void exclude_far_pair();

  void create_sphere();
  void create_wire();

 public:
  VDW_Contact_Draw(QWidget *parent,
        std::vector<Atom> *atom,
        const std::vector<Mol> *mol,
        const std::map<int, int> *serial,
        const Shared_Prm *prm);
  void set_thres(double t) { Thres = t; }
  void create_objects();
};

#endif
