#include "vdw_contact_window.h"
#include <QBoxLayout>
#include <QLabel>
#include <QMenuBar>
#include <QMessageBox>
#include <QPushButton>

VDW_Contact_Window::VDW_Contact_Window(QWidget *parent,
        std::vector<Atom> *atom,
        const std::vector<Mol> *mol,
        const std::map<int, int> *serial,
        Shared_Prm *prm)
 : QMainWindow(parent),
   SharedPrm(prm),
   VdwDraw(this, atom, mol, serial, prm)
{
 setWindowModality(Qt::WindowModal);
 setWindowFlags(windowFlags() | Qt::WindowStaysOnTopHint);

 //メニューバー
 QMenuBar *menu_Bar(menuBar());
 QMenu *menuFile = new QMenu("ファイル(&F)", menu_Bar);
 menu_Bar->addMenu(menuFile);

 QAction *actionQuit = new QAction("終了(&Q)", menuFile);
 menuFile->addAction(actionQuit);
 connect(actionQuit, SIGNAL(triggered()), this, SLOT(close()));

 //セントラルウィジェット
 QWidget *widget_central = new QWidget(this);
 setCentralWidget(widget_central);
 QVBoxLayout *layout_central = new QVBoxLayout(widget_central);

 //描画ウィジェット
 layout_central->addWidget(&VdwDraw);
 VdwDraw.setFocus();

 //設定ウィジェット
 QWidget *widget_setting = new QWidget(this);
 widget_setting->setMaximumWidth(400);
 layout_central->addWidget(widget_setting);

 QHBoxLayout *layout_setting = new QHBoxLayout(widget_setting);

 QLabel *label_thres
        = new QLabel("VDW 距離に対する割合(0.5〜2.0)", widget_setting);
 label_thres->setMaximumWidth(230);
 layout_setting->addWidget(label_thres);


 LEThres = new QLineEdit("0.82");
 LEThres->setMaximumWidth(100);
 layout_setting->addWidget(LEThres);

 QPushButton *pb_detect = new QPushButton("検知", widget_setting);
 LEThres->setMaximumWidth(50);
 connect(pb_detect,
        SIGNAL(clicked()),
        this,
        SLOT(detect()));
 layout_setting->addWidget(pb_detect);

 //上の設定値で初期描画
 QString str = LEThres->text();
 double val = str.toDouble();
 VdwDraw.set_thres(val);
 VdwDraw.create_objects();
}

void VDW_Contact_Window::detect() {
 QString str = LEThres->text();
 if(str.isEmpty()) {
  QMessageBox::critical(this, "エラー", "閾値が空欄です．");
  return;
 }
 double thres = str.toDouble();
 if(thres < 0.5 || 2.0 < thres) {
  QMessageBox::critical(this, "エラー", "設定値が範囲外です．");
  return;
 }

 VdwDraw.set_thres(thres);
 VdwDraw.create_objects();
 VdwDraw.repaint();
}

void VDW_Contact_Window::keyPressEvent(QKeyEvent *event) {
 if(event->key() == Qt::Key_X) {
  SharedPrm->KeyX = true;
  SharedPrm->KeyZ = false;
 }
 else if(event->key() == Qt::Key_Z) {
  SharedPrm->KeyX = false;
  SharedPrm->KeyZ = true;
 }
}

void VDW_Contact_Window::keyReleaseEvent(QKeyEvent *event) {
 if(event->key() == Qt::Key_X)
  SharedPrm->KeyX = false;
 else if(event->key() == Qt::Key_Z)
  SharedPrm->KeyZ = false;
}

