#include "widget_aa_or_other.h"
#include <QGroupBox>
#include <QHBoxLayout>
#include <QLabel>
#include <QVBoxLayout>

Widget_AA_Or_Other::Widget_AA_Or_Other(Shared_Prm *prm, QWidget *parent)
 : QMainWindow(parent),
   sharedPrm(prm)
{
 //ウィンドウを表示しているあいだは，メインウィンドウでの操作を禁止する
 setWindowModality(Qt::WindowModal);
 //setWindowFlags(windowFlags() | Qt::WindowStaysOnTopHint);

 //セントラルウィジェット
 setWindowTitle("アミノ酸と非アミノ酸の描き分け");
 QWidget *widget_central = new QWidget(this);
 setCentralWidget(widget_central);
 QVBoxLayout *layout_central = new QVBoxLayout(widget_central);

 //ここに各種設定を設置
 QWidget *widget_setting = new QWidget(this);
 layout_central->addWidget(widget_setting);
 QVBoxLayout *layout_setting = new QVBoxLayout(widget_setting);

 //ここに「再描画」ボタンと「閉じる」ボタンを設置
 QWidget *widget_exec = new QWidget(this);
 layout_central->addWidget(widget_exec);
 QHBoxLayout *layout_exec = new QHBoxLayout(widget_exec);

 //ここにアミノ酸側の分子モデル，描画スタイル，着色のラジオボタンを設置
 QGroupBox *gbox_aa = new QGroupBox("アミノ酸の設定", this);
 layout_setting->addWidget(gbox_aa);
 QGridLayout *layout_aa = new QGridLayout(gbox_aa);

 //ここに非アミノ酸側の分子モデル，描画スタイル，着色のラジオボタンを設置
 QGroupBox *gbox_non = new QGroupBox("非アミノ酸の設定", this);
 layout_setting->addWidget(gbox_non);
 QGridLayout *layout_non = new QGridLayout(gbox_non);

 //アミノ酸側のモデル設定用ラベル（第 0 列）
 std::array<QLabel*, 6> label_aa_model;
 for(int i = 0; i < 6; ++i) {
  label_aa_model[i] = new QLabel(this);
  layout_aa->addWidget(label_aa_model[i], i + 1, 0, Qt::AlignCenter);
 }
 label_aa_model[0]->setText("空間充填");
 label_aa_model[1]->setText("棒球");
 label_aa_model[2]->setText("棒球リボン");
 label_aa_model[3]->setText("リボン");
 label_aa_model[4]->setText("棒");
 label_aa_model[5]->setText("針金");

 //その他の列の列幅を設定
 for(int i = 1; i < 10; ++i)
  layout_aa->setColumnMinimumWidth(i, 50);

 //アミノ酸側の色設定用ラベル（第 0 行）
 std::array<QLabel*, 6> label_aa_color;
 for(int i = 0; i < 6; ++i) {
  label_aa_color[i] = new QLabel(this);
  layout_aa->addWidget(label_aa_color[i], 0, i + 1, Qt::AlignCenter);
 }
 label_aa_color[0]->setText("モノクロ");
 label_aa_color[1]->setText("分子");
 label_aa_color[2]->setText("ペプチド");
 label_aa_color[3]->setText("アミノ酸");
 label_aa_color[4]->setText("二次構造");
 label_aa_color[5]->setText("CPK");

 //スペーサー
 QLabel *label_blank0 = new QLabel(" ", this);
 layout_aa->addWidget(label_blank0, 0, 7);

 //アミノ酸側のスタイル設定用ラベル（第 8 列）
 std::array<QLabel*, 3> label_aa_style;
 for(int i = 0; i < 3; ++i) {
  label_aa_style[i] = new QLabel(this);
  layout_aa->addWidget(label_aa_style[i], i, 8);
 }
 label_aa_style[0]->setText(" 塗り潰し ");
 label_aa_style[1]->setText("   線描   ");
 label_aa_style[2]->setText("   点描   ");

 //アミノ酸側のモデル設定用ラジオボタン
 groupAAModel = new QButtonGroup(this);
 for(int i = 0; i < 6; ++i)
  for(int j = 0; j < 6; ++j) {
   rbAAModel[i][j] = new QRadioButton(this);
   groupAAModel->addButton(rbAAModel[i][j], i * 10 + j);
   layout_aa->addWidget(rbAAModel[i][j], i + 1, j + 1, Qt::AlignCenter);
  }
 //リボン行は CPK 列が空
 groupAAModel->removeButton(rbAAModel[3][5]);
 delete(rbAAModel[3][5]);
 //棒行は，二次構造列が空
 groupAAModel->removeButton(rbAAModel[4][4]);
 delete(rbAAModel[4][4]);
 //針金行は二次構造列と CPK が空
 groupAAModel->removeButton(rbAAModel[5][4]);
 delete(rbAAModel[5][4]);
 groupAAModel->removeButton(rbAAModel[5][5]);
 delete(rbAAModel[5][5]);

 rbAAModel[0][0]->setChecked(true);

 //アミノ酸側のスタイル設定用ラジオボタン
 groupAAQuad = new QButtonGroup(this);
 for(int i = 0; i < 3; ++i) {
  rbAAQuad[i] = new QRadioButton(this);
  groupAAQuad->addButton(rbAAQuad[i], i);
  layout_aa->addWidget(rbAAQuad[i], i, 9, Qt::AlignCenter);
 }
 rbAAQuad[0]->setChecked(true);

 //非アミノ酸側のモデル設定用ラベル（第 0 列）
 std::array<QLabel*, 4> label_non_model;
 for(int i = 0; i < 4; ++i) {
  label_non_model[i] = new QLabel(this);
  layout_non->addWidget(label_non_model[i], i + 1, 0, Qt::AlignCenter);
 }
 label_non_model[0]->setText("空間充填");
 label_non_model[1]->setText("棒球");
 label_non_model[2]->setText("棒");
 label_non_model[3]->setText("針金");

 //その他の列の列幅を設定
 for(int i = 1; i < 7; ++i)
  layout_non->setColumnMinimumWidth(i, 50);

 //非アミノ酸側の色設定用ラベル（第 0 行）

 std::array<QLabel*, 3> label_non_color;
 for(int i = 0; i < 3; ++i) {
  label_non_color[i] = new QLabel(this);
  layout_non->addWidget(label_non_color[i], 0, i + 1, Qt::AlignCenter);
 }
 label_non_color[0]->setText("モノクロ");
 label_non_color[1]->setText("分子");
 label_non_color[2]->setText("CPK");

 //スペーサー
 QLabel *label_blank1 = new QLabel(" ", this);
 layout_non->addWidget(label_blank1, 0, 4);

 //非アミノ酸側のスタイル設定用ラベル（第 8 列）
 std::array<QLabel*, 3> label_non_style;
 for(int i = 0; i < 3; ++i) {
  label_non_style[i] = new QLabel(this);
  layout_non->addWidget(label_non_style[i], i, 5);
 }
 label_non_style[0]->setText(" 塗り潰し ");
 label_non_style[1]->setText("   線描   ");
 label_non_style[2]->setText("   点描   ");

 //非アミノ酸側のモデル設定用ラジオボタン
 groupNonModel = new QButtonGroup(this);
 for(int i = 0; i < 4; ++i)
  for(int j = 0; j < 3; ++j) {
   rbNonModel[i][j] = new QRadioButton(this);
   groupNonModel->addButton(rbNonModel[i][j], 10 * i + j);
   layout_non->addWidget(rbNonModel[i][j], i + 1, j + 1, Qt::AlignCenter);
  }
 //針金行はモノクロと分子列のみ
 groupNonModel->removeButton(rbNonModel[3][2]);
 delete(rbNonModel[3][2]);

 //非アミノ酸側のスタイル設定用ラジオボタン
 groupNonQuad = new QButtonGroup(this);
 for(int i = 0; i < 3; ++i) {
  rbNonQuad[i] = new QRadioButton(this);
  groupNonQuad->addButton(rbNonQuad[i], i);
  layout_non->addWidget(rbNonQuad[i], i, 6, Qt::AlignCenter);
 }
 rbNonQuad[0]->setChecked(true);

 //実行ボタン
 buttonRepaint = new QPushButton(this);
 buttonRepaint->setText("再描画");
 buttonRepaint->setMaximumWidth(100);

 buttonClose = new QPushButton(this);
 buttonClose->setText("閉じる");
 buttonClose->setMaximumWidth(100);

 layout_exec->addWidget(buttonRepaint);
 layout_exec->addWidget(buttonClose);

 connect(buttonRepaint, SIGNAL(clicked()), this, SLOT(emit_aa_or_other_config()));
 connect(buttonClose, SIGNAL(clicked()), this, SLOT(hide()));
}


void Widget_AA_Or_Other::import_shared_prm(int layer) {
 int row = sharedPrm->ModelColorID[layer][0] / 10;
 int col = sharedPrm->ModelColorID[layer][0] % 10;
 if((row == 3 && col == 5) || (row == 4 && col == 4) || (row = 5 && col == 4) || (row == 5 && col == 5))
  rbAAModel[0][0]->setChecked(true);
 else if(row < 6 && col < 6)
  rbAAModel[row][col]->setChecked(true);
 else
  rbAAModel[0][0]->setChecked(true);

 if(sharedPrm->Quadric[layer][0] == GLU_FILL)
  rbAAQuad[0]->setChecked(true);
 else if(sharedPrm->Quadric[layer][0] == GLU_LINE)
  rbAAQuad[1]->setChecked(true);
 else
  rbAAQuad[2]->setChecked(true);

 row = sharedPrm->ModelColorID[layer][1] / 10;
 col = sharedPrm->ModelColorID[layer][1] % 10;
 if(row == 3 && col == 2)
  rbNonModel[0][0]->setChecked(true);
 else if(row < 4 && col < 3)
  rbNonModel[row][col]->setChecked(true);
 else
  rbNonModel[0][0]->setChecked(true);

 if(sharedPrm->Quadric[layer][1] == GLU_FILL)
  rbNonQuad[0]->setChecked(true);
 else if(sharedPrm->Quadric[layer][1] == GLU_LINE)
  rbNonQuad[1]->setChecked(true);
 else
  rbNonQuad[2]->setChecked(true);
}

void Widget_AA_Or_Other::export_shared_prm(int layer) {
 //アミノ酸側 ID
 sharedPrm->ModelColorID[layer][0] = groupAAModel->checkedId();

 //アミノ酸側モデル
 (sharedPrm->Model[layer][0]).clear();
 (sharedPrm->Model[layer][0]).shrink_to_fit();
 int row = sharedPrm->ModelColorID[layer][0] / 10;
 if(row == 0)
  (sharedPrm->Model[layer][0]).push_back(VDW);
 else if(row == 1) {
  (sharedPrm->Model[layer][0]).push_back(BALL);
  (sharedPrm->Model[layer][0]).push_back(STICK);
 }
 else if(row == 2) {
  (sharedPrm->Model[layer][0]).push_back(BALL);
  (sharedPrm->Model[layer][0]).push_back(STICK);
  (sharedPrm->Model[layer][0]).push_back(RIBBON);
 }
 else if(row == 3)
  (sharedPrm->Model[layer][0]).push_back(RIBBON);
 else if(row == 4)
  (sharedPrm->Model[layer][0]).push_back(ROD);
 else
  (sharedPrm->Model[layer][0]).push_back(WIRE);

 //アミノ酸側色
 int col = sharedPrm->ModelColorID[layer][0] % 10;
 if(col == 0)
  sharedPrm->Color[layer][0] = MONO;
 else if(col == 1)
  sharedPrm->Color[layer][0] = MOL;
 else if(col == 2)
  sharedPrm->Color[layer][0] = PEPT;
 else if(col == 3)
  sharedPrm->Color[layer][0] = AA;
 else if(col == 4)
  sharedPrm->Color[layer][0] = SECONDARY;
 else
  sharedPrm->Color[layer][0] = CPK;

 //アミノ酸側スタイル
 if(groupAAQuad->checkedId() == 0)
  sharedPrm->Quadric[layer][0] = GLU_FILL;
 else if(groupAAQuad->checkedId() == 1)
  sharedPrm->Quadric[layer][0] = GLU_LINE;
 else
  sharedPrm->Quadric[layer][0] = GLU_POINT;

 //非アミノ酸側 ID
 sharedPrm->ModelColorID[layer][1] = groupNonModel->checkedId();

 //非アミノ酸側モデル
 (sharedPrm->Model[layer][1]).clear();
 (sharedPrm->Model[layer][1]).shrink_to_fit();
 row = sharedPrm->ModelColorID[layer][1] / 10;
 if(row == 0)
  (sharedPrm->Model[layer][1]).push_back(VDW);
 else if(row == 1) {
  (sharedPrm->Model[layer][1]).push_back(BALL);
  (sharedPrm->Model[layer][1]).push_back(STICK);
 }
 else if(row == 2)
  (sharedPrm->Model[layer][1]).push_back(ROD);
 else
  (sharedPrm->Model[layer][1]).push_back(WIRE);

 //非アミノ酸側色
 col = sharedPrm->ModelColorID[layer][1] % 10;
 if(col == 0)
  sharedPrm->Color[layer][1] = MONO;
 else if(col == 1)
  sharedPrm->Color[layer][1] = MOL;
 else
  sharedPrm->Color[layer][1] = CPK;

 //非アミノ酸側スタイル
 if(groupNonQuad->checkedId() == 0)
  sharedPrm->Quadric[layer][1] = GLU_FILL;
 else if(groupNonQuad->checkedId() == 1)
  sharedPrm->Quadric[layer][1] = GLU_LINE;
 else
  sharedPrm->Quadric[layer][1] = GLU_POINT;
}

