#ifndef ___WIDGET_AA_OR_OTHER_H
#define ___WIDGET_AA_OR_OTHER_H

#include "global.h"
#include <GL/glu.h>
#include <QButtonGroup>
#include <QMainWindow>
#include <QPushButton>
#include <QRadioButton>

class Widget_AA_Or_Other : public QMainWindow {
 Q_OBJECT

 signals:  //送信するシグナル．再描画に必要
  void aa_or_other_config();

 public slots:  //シグナルを送信する関数
  void emit_aa_or_other_config() { aa_or_other_config(); }

 private:
  Shared_Prm *sharedPrm;
  std::array<std::array<QRadioButton*, 6>, 6> rbAAModel;
  std::array<QRadioButton*, 3> rbAAQuad;
  std::array<std::array<QRadioButton*, 4>, 3> rbNonModel;
  std::array<QRadioButton*, 3> rbNonQuad;

  QButtonGroup *groupAAModel;
  QButtonGroup *groupAAQuad;
  QButtonGroup *groupNonModel;
  QButtonGroup *groupNonQuad;

  QPushButton *buttonRepaint;
  QPushButton *buttonClose;

 public:
  Widget_AA_Or_Other(Shared_Prm *prm, QWidget *parent = nullptr);

  void import_shared_prm(int layer);
  void export_shared_prm(int layer);
};

#endif

