#include "widget_aa_selection.h"
#include <QGroupBox>
#include <QHBoxLayout>
#include <QLabel>
#include <QVBoxLayout>

Widget_AA_Selection::Widget_AA_Selection(Shared_Prm *prm, QWidget *parent)
 : QMainWindow(parent),
   sharedPrm(prm)
{
 //ウィンドウを表示しているあいだは，メインウィンドウでの操作を禁止する
 setWindowModality(Qt::WindowModal);
 //setWindowFlags(windowFlags() | Qt::WindowStaysOnTopHint);

 //セントラルウィジェット
 setWindowTitle("選択アミノ酸とそれ以外のパーツの描き分け");
 QWidget *widget_central = new QWidget(this);
 setCentralWidget(widget_central);
 QVBoxLayout *layout_central = new QVBoxLayout(widget_central);

 //ここに各種設定を設置
 QWidget *widget_setting = new QWidget(this);
 layout_central->addWidget(widget_setting);
 QVBoxLayout *layout_setting = new QVBoxLayout(widget_setting);

 //ここに「再描画」ボタンと「閉じる」ボタンを設置
 QWidget *widget_exec = new QWidget(this);
 layout_central->addWidget(widget_exec);
 QHBoxLayout *layout_exec = new QHBoxLayout(widget_exec);

 //ここに非選択アミノ酸側の分子モデル，描画スタイル，着色のラジオボタンを設置
 QGroupBox *gbox_non = new QGroupBox("選択アミノ酸以外のパーツの設定", this);
 layout_setting->addWidget(gbox_non);
 QGridLayout *layout_non = new QGridLayout(gbox_non);

 //ここに選択アミノ酸側の分子モデル，描画スタイル，着色のラジオボタンを設置
 QGroupBox *gbox_sel = new QGroupBox("選択アミノ酸の設定", this);
 layout_setting->addWidget(gbox_sel);
 QGridLayout *layout_sel = new QGridLayout(gbox_sel);

 //非選択アミノ酸側のモデル設定用ラベル（第 0 列）
 std::array<QLabel*, 6> label_non_model;
 for(int i = 0; i < 6; ++i) {
  label_non_model[i] = new QLabel(this);
  layout_non->addWidget(label_non_model[i], i + 1, 0, Qt::AlignCenter);
 }
 label_non_model[0]->setText("空間充填");
 label_non_model[1]->setText("棒球");
 label_non_model[2]->setText("棒球リボン");
 label_non_model[3]->setText("リボン");
 label_non_model[4]->setText("棒");
 label_non_model[5]->setText("針金");

 //その他の列の列幅を設定
 for(int i = 1; i < 10; ++i)
  layout_non->setColumnMinimumWidth(i, 50);

 //非選択アミノ酸側の色設定用ラベル（第 0 行）
 std::array<QLabel*, 6> label_non_color;
 for(int i = 0; i < 6; ++i) {
  label_non_color[i] = new QLabel(this);
  layout_non->addWidget(label_non_color[i], 0, i + 1, Qt::AlignCenter);
 }
 label_non_color[0]->setText("モノクロ");
 label_non_color[1]->setText("分子");
 label_non_color[2]->setText("ペプチド");
 label_non_color[3]->setText("アミノ酸");
 label_non_color[4]->setText("二次構造");
 label_non_color[5]->setText("CPK");

 //スペーサー
 QLabel *label_blank0 = new QLabel(" ", this);
 layout_non->addWidget(label_blank0, 0, 7);

 //非選択アミノ酸側のスタイル設定用ラベル（第 8 列）
 std::array<QLabel*, 3> label_non_style;
 for(int i = 0; i < 3; ++i) {
  label_non_style[i] = new QLabel(this);
  layout_non->addWidget(label_non_style[i], i, 8);
 }
 label_non_style[0]->setText(" 塗り潰し ");
 label_non_style[1]->setText("   線描   ");
 label_non_style[2]->setText("   点描   ");

 //非選択アミノ酸側のモデル設定用ラジオボタン
 groupNonModel = new QButtonGroup(this);
 for(int i = 0; i < 6; ++i)
  for(int j = 0; j < 6; ++j) {
   rbNonModel[i][j] = new QRadioButton(this);
   groupNonModel->addButton(rbNonModel[i][j], i * 10 + j);
   layout_non->addWidget(rbNonModel[i][j], i + 1, j + 1, Qt::AlignCenter);
  }
 //リボン行は CPK 列が空
 groupNonModel->removeButton(rbNonModel[3][5]);
 delete(rbNonModel[3][5]);
 //棒行は，二次構造列が空
 groupNonModel->removeButton(rbNonModel[4][4]);
 delete(rbNonModel[4][4]);
 //針金行は二次構造列と CPK が空
 groupNonModel->removeButton(rbNonModel[5][4]);
 delete(rbNonModel[5][4]);
 groupNonModel->removeButton(rbNonModel[5][5]);
 delete(rbNonModel[5][5]);

 rbNonModel[0][0]->setChecked(true);

 //非選択アミノ酸側のスタイル設定用ラジオボタン
 groupNonQuad = new QButtonGroup(this);
 for(int i = 0; i < 3; ++i) {
  rbNonQuad[i] = new QRadioButton(this);
  groupNonQuad->addButton(rbNonQuad[i], i);
  layout_non->addWidget(rbNonQuad[i], i, 9, Qt::AlignCenter);
 }
 rbNonQuad[0]->setChecked(true);

 //選択アミノ酸側の原子モデル設定用ラベル（第 0 列）
 std::array<QLabel*, 3> label_sel_model;
 for(int i = 0; i < 3; ++i) {
  label_sel_model[i] = new QLabel(this);
  layout_sel->addWidget(label_sel_model[i], i + 1, 0, Qt::AlignCenter);
 }
 label_sel_model[0]->setText("空間充填");
 label_sel_model[1]->setText("球");
 label_sel_model[2]->setText("棒");

 //その他の列の列幅を設定
 for(int i = 1; i < 10; ++i)
  layout_sel->setColumnMinimumWidth(i, 50);

 //選択アミノ酸側の色設定用ラベル（第 0 行）
 std::array<QLabel*, 6> label_sel_color;
 for(int i = 0; i < 6; ++i) {
  label_sel_color[i] = new QLabel(this);
  layout_sel->addWidget(label_sel_color[i], 0, i + 1, Qt::AlignCenter);
 }
 label_sel_color[0]->setText("モノクロ");
 label_sel_color[1]->setText("分子");
 label_sel_color[2]->setText("ペプチド");
 label_sel_color[3]->setText("アミノ酸");
 label_sel_color[4]->setText("二次構造");
 label_sel_color[5]->setText("CPK");

 //スペーサー
 QLabel *label_blank1 = new QLabel(" ", this);
 layout_sel->addWidget(label_blank1, 0, 7);

 //選択アミノ酸側のスタイル設定用ラベル（第 7 列）
 std::array<QLabel*, 3> label_sel_style;
 for(int i = 0; i < 3; ++i) {
  label_sel_style[i] = new QLabel(this);
  layout_sel->addWidget(label_sel_style[i], i, 8);
 }
 label_sel_style[0]->setText(" 塗り潰し ");
 label_sel_style[1]->setText("   線描   ");
 label_sel_style[2]->setText("   点描   ");

 //選択アミノ酸側のモデル設定用ラジオボタン
 groupSelModel = new QButtonGroup(this);
 for(int i = 0; i < 3; ++i)
  for(int j = 0; j < 6; ++j) {
   rbSelModel[i][j] = new QRadioButton(this);
   groupSelModel->addButton(rbSelModel[i][j], i * 10 + j);
   layout_sel->addWidget(rbSelModel[i][j], i + 1, j + 1, Qt::AlignCenter);
  }

 rbSelModel[0][0]->setChecked(true);

 //選択アミノ酸側のスタイル設定用ラジオボタン
 groupSelQuad = new QButtonGroup(this);
 for(int i = 0; i < 3; ++i) {
  rbSelQuad[i] = new QRadioButton(this);
  groupSelQuad->addButton(rbSelQuad[i], i);
  layout_sel->addWidget(rbSelQuad[i], i, 9, Qt::AlignCenter);
 }
 rbSelQuad[0]->setChecked(true);

 //実行ボタン
 buttonRepaint = new QPushButton(this);
 buttonRepaint->setText("再描画");
 buttonRepaint->setMaximumWidth(100);

 buttonClose = new QPushButton(this);
 buttonClose->setText("閉じる");
 buttonClose->setMaximumWidth(100);

 layout_exec->addWidget(buttonRepaint);
 layout_exec->addWidget(buttonClose);

 connect(buttonRepaint, SIGNAL(clicked()), this, SLOT(emit_aa_selection_config()));
 connect(buttonClose, SIGNAL(clicked()), this, SLOT(hide()));
}

void Widget_AA_Selection::import_shared_prm(int layer) {
 //非選択側
 int row = sharedPrm->ModelColorID[layer][0] / 10;
 int col = sharedPrm->ModelColorID[layer][0] % 10;
 if((row == 3 && col == 5) || (row == 4 && col == 4) || (row = 5 && col == 4) || (row == 5 && col == 5))
  rbNonModel[0][0]->setChecked(true);
 else if(row < 6 && col < 6)
  rbNonModel[row][col]->setChecked(true);
 else
  rbNonModel[0][0]->setChecked(true);

 if(sharedPrm->Quadric[layer][0] == GLU_FILL)
  rbNonQuad[0]->setChecked(true);
 else if(sharedPrm->Quadric[layer][0] == GLU_LINE)
  rbNonQuad[1]->setChecked(true);
 else
  rbNonQuad[2]->setChecked(true);

 //選択側
 row = sharedPrm->ModelColorID[layer][1] / 10;
 col = sharedPrm->ModelColorID[layer][1] % 10;
 if(row < 3 && col < 5)
  rbSelModel[row][col]->setChecked(true);
 else
  rbSelModel[0][0]->setChecked(true);

 if(sharedPrm->Quadric[layer][1] == GLU_FILL)
  rbSelQuad[0]->setChecked(true);
 else if(sharedPrm->Quadric[layer][1] == GLU_LINE)
  rbSelQuad[1]->setChecked(true);
 else
  rbSelQuad[2]->setChecked(true);
}

void Widget_AA_Selection::export_shared_prm(int layer) {
 //非選択分子側 ID
 sharedPrm->ModelColorID[layer][0] = groupNonModel->checkedId();
 //非選択分子側モデル
 (sharedPrm->Model[layer][0]).clear();
 (sharedPrm->Model[layer][0]).shrink_to_fit();
 int row = sharedPrm->ModelColorID[layer][0] / 10;
 if(row == 0)
  (sharedPrm->Model[layer][0]).push_back(VDW);
 else if(row == 1) {
  (sharedPrm->Model[layer][0]).push_back(BALL);
  (sharedPrm->Model[layer][0]).push_back(STICK);
 }
 else if(row == 2) {
  (sharedPrm->Model[layer][0]).push_back(BALL);
  (sharedPrm->Model[layer][0]).push_back(STICK);
  (sharedPrm->Model[layer][0]).push_back(RIBBON);
 }
 else if(row == 3) {
  (sharedPrm->Model[layer][0]).push_back(RIBBON);
 }
 else if(row == 4) {
  (sharedPrm->Model[layer][0]).push_back(ROD);
 }
 else
  (sharedPrm->Model[layer][0]).push_back(WIRE);

 //非選択分子側色
 int col = sharedPrm->ModelColorID[layer][0] % 10;
 if(col == 0)
  sharedPrm->Color[layer][0] = MONO;
 else if(col == 1)
  sharedPrm->Color[layer][0] = MOL;
 else if(col == 2)
  sharedPrm->Color[layer][0] = PEPT;
 else if(col == 3)
  sharedPrm->Color[layer][0] = AA;
 else if(col == 4)
  sharedPrm->Color[layer][0] = SECONDARY;
 else
  sharedPrm->Color[layer][0] = CPK;

 //非選択分子側スタイル
 if(groupNonQuad->checkedId() == 0)
  sharedPrm->Quadric[layer][0] = GLU_FILL;
 else if(groupNonQuad->checkedId() == 1)
  sharedPrm->Quadric[layer][0] = GLU_LINE;
 else
  sharedPrm->Quadric[layer][0] = GLU_POINT;

 //選択分子側 ID
 sharedPrm->ModelColorID[layer][1] = groupSelModel->checkedId();

 //選択分子側モデル
 (sharedPrm->Model[layer][1]).clear();
 (sharedPrm->Model[layer][1]).shrink_to_fit();

 row = sharedPrm->ModelColorID[layer][1] / 10;
 if(row == 0)
  (sharedPrm->Model[layer][1]).push_back(VDW);
 else if(row == 1) {
  (sharedPrm->Model[layer][1]).push_back(BALL);
 }
 else
  (sharedPrm->Model[layer][1]).push_back(ROD);

 //選択分子側色
 col = sharedPrm->ModelColorID[layer][1] % 10;
 if(col == 0)
  sharedPrm->Color[layer][1] = MONO;
 else if(col == 1)
  sharedPrm->Color[layer][1] = MOL;
 else if(col == 2)
  sharedPrm->Color[layer][1] = PEPT;
 else if(col == 3)
  sharedPrm->Color[layer][1] = AA;
 else if(col == 4)
  sharedPrm->Color[layer][1] = SECONDARY;
 else
  sharedPrm->Color[layer][1] = CPK;

 //選択分子側スタイル
 if(groupSelQuad->checkedId() == 0)
  sharedPrm->Quadric[layer][1] = GLU_FILL;
 else if(groupSelQuad->checkedId() == 1)
  sharedPrm->Quadric[layer][1] = GLU_LINE;
 else
  sharedPrm->Quadric[layer][1] = GLU_POINT;
}

