#ifndef ___WIDGET_AA_SELECTION_H
#define ___WIDGET_AA_SELECTION_H

#include "global.h"
#include <GL/glu.h>
#include <QButtonGroup>
#include <QMainWindow>
#include <QPushButton>
#include <QRadioButton>

class Widget_AA_Selection : public QMainWindow {
 Q_OBJECT

 signals:  //送信するシグナル
  void aa_selection_config();

 public slots:  //シグナルを送信する関数
  void emit_aa_selection_config() { aa_selection_config(); }

 private:
  Shared_Prm *sharedPrm;
  std::array<std::array<QRadioButton*, 3>, 6> rbSelModel;
  std::array<QRadioButton*, 3> rbSelQuad;
  std::array<std::array<QRadioButton*, 6>, 6> rbNonModel;
  std::array<QRadioButton*, 3> rbNonQuad;

  QButtonGroup *groupSelModel;
  QButtonGroup *groupSelQuad;
  QButtonGroup *groupNonModel;
  QButtonGroup *groupNonQuad;

  QPushButton *buttonRepaint;
  QPushButton *buttonClose;

 public:
  Widget_AA_Selection(Shared_Prm *prm, QWidget *parent = nullptr);

  void import_shared_prm(int layer);
  void export_shared_prm(int layer);
};

#endif

