#include "widget_mol_selection.h"
#include <QGroupBox>
#include <QHBoxLayout>
#include <QLabel>
#include <QVBoxLayout>

Widget_Mol_Selection::Widget_Mol_Selection(Shared_Prm *prm, QWidget *parent)
 : QMainWindow(parent),
   sharedPrm(prm)
{
 //ウィンドウを表示しているあいだは，メインウィンドウでの操作を禁止する
 setWindowModality(Qt::WindowModal);
 //setWindowFlags(windowFlags() | Qt::WindowStaysOnTopHint);

 //セントラルウィジェット
 setWindowTitle("非選択分子と選択分子の描き分け");
 QWidget *widget_central = new QWidget(this);
 setCentralWidget(widget_central);
 QVBoxLayout *layout_central = new QVBoxLayout(widget_central);

 //ここに各種設定を設置
 QWidget *widget_setting = new QWidget(this);
 layout_central->addWidget(widget_setting);
 QVBoxLayout *layout_setting = new QVBoxLayout(widget_setting);

 //ここに「再描画」ボタンと「閉じる」ボタンを設置
 QWidget *widget_exec = new QWidget(this);
 layout_central->addWidget(widget_exec);
 QHBoxLayout *layout_exec = new QHBoxLayout(widget_exec);

 //ここに非選択分子側の分子モデル，描画スタイル，着色のラジオボタンを設置
 QGroupBox *gbox_aa = new QGroupBox("非選択分子の設定", this);
 layout_setting->addWidget(gbox_aa);
 QGridLayout *layout_aa = new QGridLayout(gbox_aa);

 //ここに選択分子側の分子モデル，描画スタイル，着色のラジオボタンを設置
 QGroupBox *gbox_non = new QGroupBox("選択分子の設定", this);
 layout_setting->addWidget(gbox_non);
 QGridLayout *layout_non = new QGridLayout(gbox_non);

 //非選択分子側のモデル設定用ラベル（第 0 列）
 std::array<QLabel*, 4> label_aa_model;
 for(int i = 0; i < 4; ++i) {
  label_aa_model[i] = new QLabel(this);
  layout_aa->addWidget(label_aa_model[i], i + 1, 0, Qt::AlignCenter);
 }
 label_aa_model[0]->setText("空間充填");
 label_aa_model[1]->setText("棒球");
 label_aa_model[2]->setText("棒");
 label_aa_model[3]->setText("針金");

 //その他の列の列幅を設定
 for(int i = 1; i < 7; ++i)
  layout_aa->setColumnMinimumWidth(i, 50);

 //非選択分子側の色設定用ラベル（第 0 行）

 std::array<QLabel*, 3> label_aa_color;
 for(int i = 0; i < 3; ++i) {
  label_aa_color[i] = new QLabel(this);
  layout_aa->addWidget(label_aa_color[i], 0, i + 1, Qt::AlignCenter);
 }
 label_aa_color[0]->setText("モノクロ");
 label_aa_color[1]->setText("分子");
 label_aa_color[2]->setText("CPK");

 //スペーサー
 QLabel *label_blank0 = new QLabel(" ", this);
 layout_aa->addWidget(label_blank0, 0, 4);

 //非選択分子側のスタイル設定用ラベル（第 8 列）
 std::array<QLabel*, 3> label_aa_style;
 for(int i = 0; i < 3; ++i) {
  label_aa_style[i] = new QLabel(this);
  layout_aa->addWidget(label_aa_style[i], i, 5);
 }
 label_aa_style[0]->setText(" 塗り潰し ");
 label_aa_style[1]->setText("   線描   ");
 label_aa_style[2]->setText("   点描   ");

 //非選択分子側のモデル設定用ラジオボタン
 groupSelModel = new QButtonGroup(this);
 for(int i = 0; i < 4; ++i)
  for(int j = 0; j < 3; ++j) {
   rbSelModel[i][j] = new QRadioButton(this);
   groupSelModel->addButton(rbSelModel[i][j], i * 10 + j);
   layout_aa->addWidget(rbSelModel[i][j], i + 1, j + 1, Qt::AlignCenter);
  }
 //針金行は CPK が空
 groupSelModel->removeButton(rbSelModel[3][2]);
 delete(rbSelModel[3][2]);

 rbSelModel[0][0]->setChecked(true);

 //非選択分子側のスタイル設定用ラジオボタン
 groupSelQuad = new QButtonGroup(this);
 for(int i = 0; i < 3; ++i) {
  rbSelQuad[i] = new QRadioButton(this);
  groupSelQuad->addButton(rbSelQuad[i], i);
  layout_aa->addWidget(rbSelQuad[i], i, 6, Qt::AlignCenter);
 }
 rbSelQuad[0]->setChecked(true);

 //選択分子側のモデル設定用ラベル（第 0 列）
 std::array<QLabel*, 4> label_non_model;
 for(int i = 0; i < 4; ++i) {
  label_non_model[i] = new QLabel(this);
  layout_non->addWidget(label_non_model[i], i + 1, 0, Qt::AlignCenter);
 }
 label_non_model[0]->setText("空間充填");
 label_non_model[1]->setText("棒球");
 label_non_model[2]->setText("棒");
 label_non_model[3]->setText("針金");

 //その他の列の列幅を設定
 for(int i = 1; i < 7; ++i)
  layout_non->setColumnMinimumWidth(i, 50);

 //選択分子側の色設定用ラベル（第 0 行）

 std::array<QLabel*, 3> label_non_color;
 for(int i = 0; i < 3; ++i) {
  label_non_color[i] = new QLabel(this);
  layout_non->addWidget(label_non_color[i], 0, i + 1, Qt::AlignCenter);
 }
 label_non_color[0]->setText("モノクロ");
 label_non_color[1]->setText("分子");
 label_non_color[2]->setText("CPK");

 //スペーサー
 QLabel *label_blank1 = new QLabel(" ", this);
 layout_non->addWidget(label_blank1, 0, 4);

 //選択分子側のスタイル設定用ラベル（第 8 列）
 std::array<QLabel*, 3> label_non_style;
 for(int i = 0; i < 3; ++i) {
  label_non_style[i] = new QLabel(this);
  layout_non->addWidget(label_non_style[i], i, 5);
 }
 label_non_style[0]->setText(" 塗り潰し ");
 label_non_style[1]->setText("   線描   ");
 label_non_style[2]->setText("   点描   ");

 //選択分子側のモデル設定用ラジオボタン
 groupNonModel = new QButtonGroup(this);
 for(int i = 0; i < 4; ++i)
  for(int j = 0; j < 3; ++j) {
   rbNonModel[i][j] = new QRadioButton(this);
   groupNonModel->addButton(rbNonModel[i][j], 10 * i + j);
   layout_non->addWidget(rbNonModel[i][j], i + 1, j + 1, Qt::AlignCenter);
  }
 //針金行はモノクロと分子列のみ
 groupNonModel->removeButton(rbNonModel[3][2]);
 delete(rbNonModel[3][2]);

 //選択分子側のスタイル設定用ラジオボタン
 groupNonQuad = new QButtonGroup(this);
 for(int i = 0; i < 3; ++i) {
  rbNonQuad[i] = new QRadioButton(this);
  groupNonQuad->addButton(rbNonQuad[i], i);
  layout_non->addWidget(rbNonQuad[i], i, 6, Qt::AlignCenter);
 }
 rbNonQuad[0]->setChecked(true);

 //実行ボタン
 buttonRepaint = new QPushButton(this);
 buttonRepaint->setText("再描画");
 buttonRepaint->setMaximumWidth(100);

 buttonClose = new QPushButton(this);
 buttonClose->setText("閉じる");
 buttonClose->setMaximumWidth(100);

 layout_exec->addWidget(buttonRepaint);
 layout_exec->addWidget(buttonClose);

 connect(buttonRepaint, SIGNAL(clicked()), this, SLOT(emit_mol_selection_config()));
 connect(buttonClose, SIGNAL(clicked()), this, SLOT(hide()));
}


void Widget_Mol_Selection::import_shared_prm(int layer) {
 int row = sharedPrm->ModelColorID[layer][0] / 10;
 int col = sharedPrm->ModelColorID[layer][0] % 10;
 if(row == 3 && col == 2)
  rbSelModel[0][0]->setChecked(true);
 if(row < 4 && col < 3)
  rbSelModel[row][col]->setChecked(true);
 else
  rbSelModel[0][0]->setChecked(true);

 if(sharedPrm->Quadric[layer][0] == GLU_FILL)
  rbSelQuad[0]->setChecked(true);
 else if(sharedPrm->Quadric[layer][0] == GLU_LINE)
  rbSelQuad[1]->setChecked(true);
 else
  rbSelQuad[2]->setChecked(true);

 row = sharedPrm->ModelColorID[layer][1] / 10;
 col = sharedPrm->ModelColorID[layer][1] % 10;
 if(row == 3 && col == 2)
  rbNonModel[0][0]->setChecked(true);
 else if(row < 4 && col < 3)
  rbNonModel[row][col]->setChecked(true);
 else
  rbNonModel[0][0]->setChecked(true);

 if(sharedPrm->Quadric[layer][1] == GLU_FILL)
  rbNonQuad[0]->setChecked(true);
 else if(sharedPrm->Quadric[layer][1] == GLU_LINE)
  rbNonQuad[1]->setChecked(true);
 else
  rbNonQuad[2]->setChecked(true);
}

void Widget_Mol_Selection::export_shared_prm(int layer) {
 //非選択分子側 ID
 sharedPrm->ModelColorID[layer][0] = groupSelModel->checkedId();

 //非選択分子側モデル
 (sharedPrm->Model[layer][0]).clear();
 (sharedPrm->Model[layer][0]).shrink_to_fit();
 int row = sharedPrm->ModelColorID[layer][0] / 10;
 if(row == 0)
  (sharedPrm->Model[layer][0]).push_back(VDW);
 else if(row == 1) {
  (sharedPrm->Model[layer][0]).push_back(BALL);
  (sharedPrm->Model[layer][0]).push_back(STICK);
 }
 else if(row == 2)
  (sharedPrm->Model[layer][0]).push_back(ROD);
 else
  (sharedPrm->Model[layer][0]).push_back(WIRE);

 //非選択分子側色
 int col = sharedPrm->ModelColorID[layer][0] % 10;
 if(col == 0)
  sharedPrm->Color[layer][0] = MONO;
 else if(col == 1)
  sharedPrm->Color[layer][0] = MOL;
 else
  sharedPrm->Color[layer][0] = CPK;

 //非選択分子側スタイル
 if(groupSelQuad->checkedId() == 0)
  sharedPrm->Quadric[layer][0] = GLU_FILL;
 else if(groupSelQuad->checkedId() == 1)
  sharedPrm->Quadric[layer][0] = GLU_LINE;
 else
  sharedPrm->Quadric[layer][0] = GLU_POINT;

 //選択分子側 ID
 sharedPrm->ModelColorID[layer][1] = groupNonModel->checkedId();

 //選択分子側モデル
 (sharedPrm->Model[layer][1]).clear();
 (sharedPrm->Model[layer][1]).shrink_to_fit();
 row = sharedPrm->ModelColorID[layer][1] / 10;
 if(row == 0)
  (sharedPrm->Model[layer][1]).push_back(VDW);
 else if(row == 1) {
  (sharedPrm->Model[layer][1]).push_back(BALL);
  (sharedPrm->Model[layer][1]).push_back(STICK);
 }
 else if(row == 2)
  (sharedPrm->Model[layer][1]).push_back(ROD);
 else
  (sharedPrm->Model[layer][1]).push_back(WIRE);

 //選択分子側色
 col = sharedPrm->ModelColorID[layer][1] % 10;
 if(col == 0)
  sharedPrm->Color[layer][1] = MONO;
 else if(col == 1)
  sharedPrm->Color[layer][1] = MOL;
 else
  sharedPrm->Color[layer][1] = CPK;

 //選択分子側スタイル
 if(groupNonQuad->checkedId() == 0)
  sharedPrm->Quadric[layer][1] = GLU_FILL;
 else if(groupNonQuad->checkedId() == 1)
  sharedPrm->Quadric[layer][1] = GLU_LINE;
 else
  sharedPrm->Quadric[layer][1] = GLU_POINT;
}

