#ifndef ___WIDGET_MOL_SELECTION_H
#define ___WIDGET_MOL_SELECTION_H

#include "global.h"
#include <GL/glu.h>
#include <QButtonGroup>
#include <QMainWindow>
#include <QPushButton>
#include <QRadioButton>

class Widget_Mol_Selection : public QMainWindow {
 Q_OBJECT

 signals:  //送信するシグナル
  void mol_selection_config();

 public slots:  //シグナルを送信する関数
  void emit_mol_selection_config() { mol_selection_config(); }

 private:
  Shared_Prm *sharedPrm;
  std::array<std::array<QRadioButton*, 4>, 3> rbSelModel;
  std::array<QRadioButton*, 3> rbSelQuad;
  std::array<std::array<QRadioButton*, 4>, 3> rbNonModel;
  std::array<QRadioButton*, 3> rbNonQuad;

  QButtonGroup *groupSelModel;
  QButtonGroup *groupSelQuad;
  QButtonGroup *groupNonModel;
  QButtonGroup *groupNonQuad;

  QPushButton *buttonRepaint;
  QPushButton *buttonClose;

 public:
  Widget_Mol_Selection(Shared_Prm *prm, QWidget *parent = nullptr);

  void import_shared_prm(int layer);
  void export_shared_prm(int layer);
};

#endif

