#include "adjacent_atom.h"

void Adjacent_Atom::check(int serial) {
 if(!atomVect || !serialToIdx) {
  std::cerr << __PRETTY_FUNCTION__ << std::endl;
  exit(1);
 }

 clear();

 int idx = serialToIdx->at(serial);
 const std::vector<int> &bond = (*atomVect)[idx].Bond;

 for(int serial : bond) {
  const Atom &bound_atom = (*atomVect)[serialToIdx->at(serial)];
  if(bound_atom.Elmt == 1)
   H.push_back(bound_atom.serialNum);
  else if(bound_atom.Elmt == 6)
   C.push_back(bound_atom.serialNum);
  else if(bound_atom.Elmt == 7)
   N.push_back(bound_atom.serialNum);
  else if(bound_atom.Elmt == 8)
   O.push_back(bound_atom.serialNum);
  else if(bound_atom.Elmt == 16)
   S.push_back(bound_atom.serialNum);
  else
   X.push_back(bound_atom.serialNum);
 }
}

void Adjacent_Atom::clear() {
 H.clear();
 H.shrink_to_fit();
 C.clear();
 C.shrink_to_fit();
 O.clear();
 O.shrink_to_fit();
 N.clear();
 N.shrink_to_fit();
 S.clear();
 S.shrink_to_fit();
 X.clear();
 X.shrink_to_fit();
}
