#ifndef ___ADJACENT_ATOM_H
#define ___ADJACENT_ATOM_H

#include "atom.h"
#include <map>
#include <vector>

struct Adjacent_Atom {
 const std::vector<Atom> *atomVect;
 const std::map<int, int> *serialToIdx;

 void clear();

 std::vector<int> H;
 std::vector<int> C;
 std::vector<int> N;
 std::vector<int> O;
 std::vector<int> S;
 std::vector<int> X;

 Adjacent_Atom(const std::vector<Atom> *vect, const std::map<int, int> *map)
 : atomVect(vect), serialToIdx(map) {}

 void check(int serial);

};

#endif
