#include "affine.h"

Affine::Affine()
 : atomVect(nullptr),
   serialToIdx(nullptr),
   Center{0.0, 0.0, 0.0},
   Radius(0.0)
{
 //回転行列
 for(int i = -180; i != 181; ++i)
  for(int j = -180; j != 181; ++j)
   rotationMtx[i + 180][j + 180] =
    Eigen::AngleAxisd((double)j / 360.0 * M_PI,
    Eigen::Vector3d::UnitX()) * Eigen::AngleAxisd((double)i /360.0 * M_PI,
    Eigen::Vector3d::UnitY());
}

void Affine::centering() {
 calc_center();

 for(Atom &atom : *atomVect)
  atom.XYZ -= Center;

 init_center();
}

void Affine::set_center(int serial) {
 int idx = serialToIdx->at(serial);
 Center = (*atomVect)[idx].XYZ;
}

void Affine::calc_center() {
 init_center();

 int cnt = atomVect->size();
 if(!cnt)
  return;

 for(int i = 0; i < cnt; ++i)
  Center += (*atomVect)[i].XYZ;
 Center /= (double)cnt;
}

void Affine::calc_center(const std::vector<int> *serial) {
 init_center();
 int cnt = serial->size();
 for(int i = 0; i < cnt; ++i) {
  int idx = serialToIdx->at((*serial)[i]);
  Center += (*atomVect)[idx].XYZ;
 }
 Center /= (double)cnt;
}

void Affine::calc_radius() {
 Radius = 0.0;
 for(Atom &atom : *atomVect) {
  double r = (atom.XYZ - Center).norm();
  if(Radius < r)
   Radius = r;
 }
}

void Affine::rotate_unit(double dx, double dy) {
 //大きすぎるマウス動作は無視
 if(dx < -180.0 || 180.0 < dx) return;
 if(dy < -180.0 || 180.0 < dy) return;

 int cnt = atomVect->size();
 for(int i = 0; i < cnt; ++i)
  (*atomVect)[i].XYZ -= Center;

 for(Atom &atom : *atomVect)
  atom.XYZ = rotationMtx[(int)dx+ 180][(int)dy + 180] * atom.XYZ;
 for(int i = 0; i < cnt; ++i)
  (*atomVect)[i].XYZ += Center;
}

void Affine::rotate_mol(const std::vector<int> *serial, double dx, double dy) {
 if(dx < -180.0 || 180.0 < dx) return;
 if(dy < -180.0 || 180.0 < dy) return;

 int cnt = serial->size();
 for(int i = 0; i < cnt; ++i) {
  int idx = serialToIdx->at((*serial)[i]);
  (*atomVect)[idx].XYZ -= Center;
 }
 for(int i = 0; i < cnt; ++i) {
  int idx = serialToIdx->at((*serial)[i]);
  Eigen::Vector3d &xyz = (*atomVect)[idx].XYZ;
  xyz = rotationMtx[(int)dx+ 180][(int)dy + 180] * xyz;
 }
 for(int i = 0; i < cnt; ++i) {
  int idx = serialToIdx->at((*serial)[i]);
  (*atomVect)[idx].XYZ += Center;
 }
}

void Affine::move_unit(double lx, double ly) {
 for(Atom &atom : *atomVect) {
  atom.XYZ[0] += lx;
  atom.XYZ[1] += ly;
 }
}

void Affine::move_mol(const std::vector<int> *serial, double lx, double ly) {
 for(int num : *serial) {
  int idx = serialToIdx->at(num);
  (*atomVect)[idx].XYZ[0] += lx;
  (*atomVect)[idx].XYZ[1] += ly;
 }
}

void Affine::create_move_vector(int serial0, int serial1) {
 int idx0 = serialToIdx->at(serial0);
 int idx1 = serialToIdx->at(serial1);
 const Eigen::Vector3d v0 = (*atomVect)[idx0].XYZ;
 const Eigen::Vector3d v1 = (*atomVect)[idx1].XYZ;
 moveVect = v1 - v0;
 moveVect.normalize();
}

void Affine::move_region(const std::vector<int> *idx, double length) {
 Eigen::Vector3d v = moveVect * length;
 for(int num : *idx)
  (*atomVect)[num].XYZ += v;
}

//マウス，二面角
void Affine::create_rotation_matrix(int serial0, int serial1) {
 int idx0 = serialToIdx->at(serial0);
 int idx1 = serialToIdx->at(serial1);
 const Eigen::Vector3d v0 = (*atomVect)[idx0].XYZ;
 const Eigen::Vector3d v1 = (*atomVect)[idx1].XYZ;
 Eigen::Vector3d axis = v1 - v0;
 axis.normalize();
 create_rotation_matrix(axis);
}

//マウス，結合角
void Affine::create_rotation_matrix(int serial0, int serial1, int serial2) {
 int idx0 = serialToIdx->at(serial0);
 int idx1 = serialToIdx->at(serial1);
 int idx2 = serialToIdx->at(serial2);
 const Eigen::Vector3d v0 = (*atomVect)[idx0].XYZ;
 const Eigen::Vector3d v1 = (*atomVect)[idx1].XYZ;
 const Eigen::Vector3d v2 = (*atomVect)[idx2].XYZ;
 Eigen::Vector3d axis = (v0 - v1).cross(v2 - v1);
 axis.normalize();
 create_rotation_matrix(axis);
}

void Affine::create_rotation_matrix(const Eigen::Vector3d &axis) {
 double cos_val = 0.0;
 double sin_val = 0.0;
 double sin_x = 0.0;
 double sin_y = 0.0;
 double sin_z = 0.0;
 double mcos = 0.0;
 double mcos_xy = 0.0;
 double mcos_yz = 0.0;
 double mcos_zx = 0.0;
 for(int i = 0; i != 361; ++i) {
  cos_val = cos(double(i - 180) * DEG_to_RAD);
  sin_val = sin(double(i - 180) * DEG_to_RAD);
  sin_x = sin_val * axis[0];
  sin_y = sin_val * axis[1];
  sin_z = sin_val * axis[2];
  mcos = 1.0 - cos_val;
  mcos_xy = mcos * axis[0] * axis[1];
  mcos_yz = mcos * axis[1] * axis[2];
  mcos_zx = mcos * axis[2] * axis[0];
  rotationMtx2[i](0, 0) = cos_val + mcos * pow(axis[0], 2.0);
  rotationMtx2[i](0, 1) = mcos_xy + sin_z;
  rotationMtx2[i](0, 2) = mcos_zx - sin_y;
  rotationMtx2[i](1, 0) = mcos_xy - sin_z;
  rotationMtx2[i](1, 1) = cos_val + mcos * pow(axis[1], 2.0);
  rotationMtx2[i](1, 2) = mcos_yz + sin_x;
  rotationMtx2[i](2, 0) = mcos_zx + sin_y;
  rotationMtx2[i](2, 1) = mcos_yz - sin_x;
  rotationMtx2[i](2, 2) = cos_val + mcos * pow(axis[2], 2.0);
 }
}

void Affine::create_rotation_matrix(const Eigen::Vector3d *axis, double rad) {
 double cos_val = 0.0;
 double sin_val = 0.0;
 double sin_x = 0.0;
 double sin_y = 0.0;
 double sin_z = 0.0;
 double mcos = 0.0;
 double mcos_xy = 0.0;
 double mcos_yz = 0.0;
 double mcos_zx = 0.0;

 cos_val = cos(rad);
 sin_val = sin(rad);
 sin_x = sin_val * (*axis)[0];
 sin_y = sin_val * (*axis)[1];
 sin_z = sin_val * (*axis)[2];
 mcos = 1.0 - cos_val;
 mcos_xy = mcos * (*axis)[0] * (*axis)[1];
 mcos_yz = mcos * (*axis)[1] * (*axis)[2];
 mcos_zx = mcos * (*axis)[2] * (*axis)[0];
 rotationMtx3(0, 0) = cos_val + mcos * pow((*axis)[0], 2.0);
 rotationMtx3(0, 1) = mcos_xy + sin_z;
 rotationMtx3(0, 2) = mcos_zx - sin_y;
 rotationMtx3(1, 0) = mcos_xy - sin_z;
 rotationMtx3(1, 1) = cos_val + mcos * pow((*axis)[1], 2.0);
 rotationMtx3(1, 2) = mcos_yz + sin_x;
 rotationMtx3(2, 0) = mcos_zx + sin_y;
 rotationMtx3(2, 1) = mcos_yz - sin_x;
 rotationMtx3(2, 2) = cos_val + mcos * pow((*axis)[2], 2.0);
}

void Affine::rotate_region(const std::vector<int> *idx, int degree) {
 int deg = degree + 180;
 for(int num : *idx) {
  Eigen::Vector3d &xyz((*atomVect)[num].XYZ);
  xyz -= Center;
  xyz = rotationMtx2[deg] * xyz;
  xyz += Center;
 }
}

void Affine::rotate_point(Eigen::Vector3d *point) {
 *point -= Center;
 *point = rotationMtx3 * (*point);
 *point += Center;
}

void Affine::move(
        const Eigen::Vector3d *center0,
        const Eigen::Vector3d *center1)
{
 Eigen::Vector3d v = *center1 - *center0;
 for(Atom &atom : *atomVect)
  atom.XYZ += v;

 Center += v;
}

void Affine::rotate_unit()
{
 for(Atom &atom : *atomVect) {
  atom.XYZ -= Center;
  atom.XYZ = rotationMtx3 * atom.XYZ;
  atom.XYZ += Center;
 }
}

