#ifndef ___AFFINE_H
#define ___AFFINE_H

/*
改良点
(1) 中心を集約
 private:
  Eigen::Vector3d UnitCenter;
  Eigen::Vector3d RotationCenter;
  Eigen::Vector3d EyePos;
(2) アフィン変換による重ね合わせ対応
 private:
  std::vector<std::vector<Atom>> *atomVect;
(3) 継承関係
 Dinamic_Programming : public Affine
*/

#include "atom.h"
#include "libbuilcule_global.h"

class Affine {
 private:
  std::vector<Atom> *atomVect;
  const std::map<int, int> *serialToIdx;

  Eigen::Vector3d Center;
  double Radius;
  //X 軸と Y 軸 を回転軸とする回転用．コンストラクタで作成する
  std::array<std::array<Eigen::Matrix3d, 361>, 361> rotationMtx;
  //回転軸を指定する，領域回転用．用時調整
  std::array<Eigen::Matrix3d, 361> rotationMtx2;
  //回転軸と角度を指定する，一点回転用．用時調整
  Eigen::Matrix3d rotationMtx3;
  Eigen::Vector3d moveVect;  //領域の平行移動用

  void create_rotation_matrix(const Eigen::Vector3d &axis);

 public:
  Affine();

  void set_atom_vect(std::vector<Atom> *vect)
      { atomVect = vect; }
  void set_serial_to_idx(const std::map<int, int> *map)
      { serialToIdx = map; }

  void init_center() { Center << 0.0, 0.0, 0.0; }
  void centering();
  void calc_center();
  void calc_center(const std::vector<int> *serial);
  void calc_radius();

  const Eigen::Vector3d *get_center() { return &Center; }
  double get_radius() { return Radius; }

  void set_center(const Eigen::Vector3d *center)
        { Center = *center;}
  void set_center(int serial);

  //XY 平面上の回転・平行移動
  void rotate_unit(double dx, double dy);
  void rotate_mol(const std::vector<int> *serial, double dx, double dy);
  void move_unit(double lx, double ly);
  void move_mol(const std::vector<int> *serial, double lx, double ly);

  //空間での回転・平行移動
  void create_rotation_matrix(int serial0, int serial1);
  void create_rotation_matrix(int serial0, int serial1, int serial2);
  void rotate_region(const std::vector<int> *idx, int degree );
  void create_move_vector(int serial0, int serial1);
  void move_region(const std::vector<int> *idx, double length );

  void create_rotation_matrix(const Eigen::Vector3d *axis, double rad);
  void rotate_point(Eigen::Vector3d *point);
  void move(const Eigen::Vector3d *center0, const Eigen::Vector3d *center1);
  void rotate_unit();
};

#endif
