#ifndef ___AFFINE_TRANS_2_H
#define ___AFFINE_TRANS_2_H


//Detrial-2 向け試作品


#include "mol.h"
#include <GL/glu.h>

class Affine_Trans_2 {
 private:
  //クラス外部のオブジェクト
  std::vector<Atom> *AtomVect;
  const std::vector<Mol> *MolVect;
  const std::map<int, int> *SerialToIdx;

  //クラス内部のオブジェクト
  Eigen::Vector3d Center;
  std::vector<Eigen::Vector3d> MolCenter;
  std::vector<double> MolRadius;
  Eigen::Vector3d DrawCenter;
  double Radius;
  double DrawRadius;
  GLint Slices;  //オブジェクトの分割数（経度）
  GLint Stacks;  //オブジェクトの分割数（緯度）
  Eigen::Vector3d EyePos;
  GLdouble Front;  //視点から「上面」までの距離（座標ではない）
  GLdouble Back;  //視点から「下面」までの距離（座標ではない）

  //X 軸と Y 軸 を回転軸とする回転用．コンストラクタで作成する
  std::array<std::array<Eigen::Matrix3d, 361>, 361> RotMtxXY;

  void calc_mol_center(int mol);
  void calc_mol_radius(int mol);


 public:
  Affine_Trans_2(std::vector<Atom> *atom,
        const std::vector<Mol> *mol,
        const std::map<int, int> *serial);

  void calc_center();
  void calc_radius();
  void init_eye_pos();

  const Eigen::Vector3d *get_center() const
        { return &Center; }
  const Eigen::Vector3d *get_draw_center() const
        { return &DrawCenter; }
  double get_radius() const
        { return Radius; }
  double get_draw_radius() const
        { return DrawRadius; }
  const Eigen::Vector3d *get_eye_pos() const
        { return &EyePos; }
  GLdouble get_front() const
        { return Front; }
  GLdouble get_back() const
        { return Back; }
  GLint get_slices() const
        { return Slices; }
  GLint get_stacks() const
        { return Stacks; }

  void move_draw_center(int xyz, double d)
        { DrawCenter[xyz] += d; }
  void move_eye(int xyz, double d)
        { EyePos[xyz] += d; }
  void move_front(double d)
        { Front += d; }
  void move_back(double d)
        { Back += d; }

  void rotate_atom_xy(double dx, double dy);
  void rotate_point_xy(Eigen::Vector3d *p, double dx, double dy);

  //利用シーン：分子の凝集・分散，分子の回転・移動，分子への始点集中
  void resize_mol();
  void calc_mol_center();
  void calc_mol_radius();
  const Eigen::Vector3d *get_mol_center(int mol) const;
  double get_mol_radius(int mol) const;

  void move_mol(int mol, const Eigen::Vector3d *v);
};

#endif
