#include "amino_acid.h"
#include <algorithm>

Amino_Acid::Amino_Acid()
 : Code1('X'),
   Code3("XXX"),
   OXT(-1),
   AA(false),
   Peptide(false),
   terN(false),
   nextN(0),
   Secondary(-1)
{}

void Amino_Acid::init() {
 Code1 = 'X';
 Code3 = "XXX";
 OXT = -1;
 Annot.clear();
 mainH.clear();
 mainH.shrink_to_fit();
 sideH.clear();
 sideH.shrink_to_fit();
 sp34.clear();
 sp34.shrink_to_fit();
 sp33.clear();
 sp33.shrink_to_fit();
 sp32.clear();
 sp32.shrink_to_fit();
 sp23.clear();
 sp23.shrink_to_fit();
 allSerial.clear();
 allSerial.shrink_to_fit();

 for(std::vector<int> &serial_vect : sideChainR) {
  serial_vect.clear();
  serial_vect.shrink_to_fit();
 }

 for(std::array<std::vector<int>, 6> &layer : sideChainC)
  for(std::vector<int> serial_vect : layer) {
   serial_vect.clear();
   serial_vect.shrink_to_fit();
  }

 AA = false;
 Peptide = false;
 terN = false;
 nextN = 0;
 Secondary = -1;
}

void Amino_Acid::confirm_x() {
 Code1 = 'X';
 Code3 = "XXX";
 int sN = Annot[N];
 int sCA = Annot[CA];
 int sC = Annot[C];
 int sO = Annot[O];
 Annot.clear();
 Annot[N] = sN;
 Annot[CA] = sCA;
 Annot[C] = sC;
 Annot[O] = sO;

 sideH.clear();
 sideH.shrink_to_fit();

 for(std::vector<int> &serial_vect : sideChainR) {
  serial_vect.clear();
  serial_vect.shrink_to_fit();
 }

 for(std::array<std::vector<int>, 6> &layer : sideChainC)
  for(std::vector<int> serial_vect : layer) {
   serial_vect.clear();
   serial_vect.shrink_to_fit();
  }

 allSerial.clear();
 allSerial.shrink_to_fit();
 push_all_serial();
}

void Amino_Acid::erase_dupl_side_h() {
 std::sort(sideH.begin(), sideH.end());
 sideH.erase(std::unique(sideH.begin(), sideH.end()), sideH.end());
}

void Amino_Acid::confirm_ca_cb() {
 int ca = Annot[CA];
 sideChainR[0].push_back(ca);  //側鎖のキャプチャ用二次元テーブル
 sideChainC[0][1].push_back(ca);  //再構成した三次元テーブル
 sp34.push_back(ca);

 if(Code1 != 'G') {
  int cb = Annot[CB];
  sideChainR[1].push_back(cb);
  sideChainC[1][1].push_back(cb);
  sp34.push_back(cb);
 }
}

void Amino_Acid::confirm_a() {
 Code1 = 'A';
 Code3 ="Ala";
}

void Amino_Acid::confirm_C() {
 Code1 = 'C';
 Code3 ="Cys";
 Annot[SG] = sideChainC[2][4][0];
 sp32.push_back(sideChainC[2][4][0]);
}

void Amino_Acid::confirm_c() {
 Code1 = 'c';
 Code3 ="cys";
 Annot[SG] = sideChainC[2][4][0];
 sp32.push_back(sideChainC[2][4][0]);
}

void Amino_Acid::confirm_d() {
 Code1 = 'D';
 Code3 ="Asp";
 Annot[CG] = sideChainC[2][1][0];
 Annot[OD1] = sideChainC[3][3][0];
 Annot[OD2] = sideChainC[3][3][1];
}

void Amino_Acid::confirm_e() {
 Code1 = 'E';
 Code3 ="Glu";
 Annot[CG] = sideChainC[2][1][0];
 Annot[CD] = sideChainC[3][1][0];
 Annot[OE1] = sideChainC[4][3][0];
 Annot[OE2] = sideChainC[4][3][1];
 sp34.push_back(sideChainC[2][1][0]);
}

void Amino_Acid::confirm_f() {
 Code1 = 'F';
 Code3 ="Phe";
 Annot[CG] = sideChainC[2][1][0];
 Annot[CD1] = sideChainC[3][1][0];
 Annot[CD2] = sideChainC[3][1][1];
 Annot[CE1] = sideChainC[4][1][0];
 Annot[CE2] = sideChainC[4][1][1];
 Annot[CZ] = sideChainC[5][1][0];
 sp23.push_back(sideChainC[3][1][0]);
 sp23.push_back(sideChainC[3][1][1]);
 sp23.push_back(sideChainC[4][1][0]);
 sp23.push_back(sideChainC[4][1][1]);
 sp23.push_back(sideChainC[5][1][0]);
}

void Amino_Acid::confirm_g() {
 Code1 = 'G';
 Code3 = "Gly";
}

void Amino_Acid::confirm_h() {
 Code1 = 'H';
 Code3 ="His";
 Annot[CG] = sideChainC[2][1][0];
 Annot[ND1] = sideChainC[3][2][0];
 Annot[CD2] = sideChainC[3][1][0];
 Annot[CE1] = sideChainC[4][1][0];
 Annot[NE2] = sideChainC[4][2][0];
 sp33.push_back(sideChainC[3][2][0]);
 sp23.push_back(sideChainC[3][1][0]);
 sp23.push_back(sideChainC[4][1][0]);
 sp23.push_back(sideChainC[4][2][0]);
}

void Amino_Acid::confirm_i() {
 sp34.push_back(sideChainC[2][1][0]);
 sp34.push_back(sideChainC[2][1][1]);
 sp34.push_back(sideChainC[3][1][0]);
}

void Amino_Acid::confirm_k() {
 Code1 = 'K';
 Code3 ="Lys";
 Annot[CG] = sideChainC[2][1][0];
 Annot[CD] = sideChainC[3][1][0];
 Annot[CE] = sideChainC[4][1][0];
 Annot[NZ] = sideChainC[5][2][0];
 sp34.push_back(sideChainC[2][1][0]);
 sp34.push_back(sideChainC[3][1][0]);
 sp34.push_back(sideChainC[4][1][0]);
 sp34.push_back(sideChainC[5][2][0]);
}

void Amino_Acid::confirm_l() {
 Code1 = 'L';
 Code3 ="Leu";
 Annot[CG] = sideChainC[2][1][0];
 Annot[CD1] = sideChainC[3][1][0];
 Annot[CD2] = sideChainC[3][1][1];
 sp34.push_back(sideChainC[2][1][0]);
 sp34.push_back(sideChainC[3][1][0]);
 sp34.push_back(sideChainC[3][1][1]);
}

void Amino_Acid::confirm_m() {
 Code1 = 'M';
 Code3 ="Met";
 Annot[CG] = sideChainC[2][1][0];
 Annot[SD] = sideChainC[3][4][0];
 Annot[CE] = sideChainC[4][1][0];
 sp34.push_back(sideChainC[2][1][0]);
 sp34.push_back(sideChainC[4][1][0]);
}

void Amino_Acid::confirm_n() {
 Code1 = 'N';
 Code3 ="Asn";
 Annot[CG] = sideChainC[2][1][0];
 Annot[ND2] = sideChainC[3][2][0];
 Annot[OD1] = sideChainC[3][3][0];
 sp33.push_back(sideChainC[3][2][0]);
}

void Amino_Acid::confirm_p() {
 sp34.push_back(sideChainC[2][1][0]);
 sp34.push_back(sideChainC[3][1][0]);
 if(Code1 == 'p')
  sp32.push_back(sideChainC[3][3][0]);
}

void Amino_Acid::confirm_q() {
 Code1 = 'Q';
 Code3 ="Gln";
 Annot[CG] = sideChainC[2][1][0];
 Annot[CD] = sideChainC[3][1][0];
 Annot[OE1] = sideChainC[4][3][0];
 Annot[NE2] = sideChainC[4][2][0];
 sp34.push_back(sideChainC[2][1][0]);
 sp33.push_back(sideChainC[4][2][0]);
}

void Amino_Acid::confirm_r() {
 Code1 = 'R';
 Code3 ="Arg";
 Annot[CG] = sideChainC[2][1][0];
 Annot[CD] = sideChainC[3][1][0];
 Annot[NE] = sideChainC[4][2][0];
 Annot[CZ] = sideChainC[5][1][0];
 Annot[NH1] = sideChainC[6][2][0];
 Annot[NH2] = sideChainC[6][2][1];
 sp34.push_back(sideChainC[2][1][0]);
 sp34.push_back(sideChainC[3][1][0]);
 sp33.push_back(sideChainC[4][2][0]);
 sp34.push_back(sideChainC[6][2][0]);
 sp33.push_back(sideChainC[6][2][1]);
}

void Amino_Acid::confirm_s() {
 Code1 = 'S';
 Code3 ="Ser";
 Annot[OG] = sideChainC[2][3][0];
 sp32.push_back(sideChainC[2][3][0]);
}

void Amino_Acid::confirm_t() {
 Code1 = 'T';
 Code3 ="Thr";
 Annot[CG2] = sideChainC[2][1][0];
 Annot[OG1] = sideChainC[2][3][0];
 sp34.push_back(sideChainC[2][1][0]);
 sp32.push_back(sideChainC[2][3][0]);
}

void Amino_Acid::confirm_v() {
 Code1 = 'V';
 Code3 ="Val";
 Annot[CG1] = sideChainC[2][1][0];
 Annot[CG2] = sideChainC[2][1][1];
 sp34.push_back(sideChainC[2][1][0]);
 sp34.push_back(sideChainC[2][1][1]);
}

void Amino_Acid::confirm_w() {
 sp23.push_back(Annot[CD1]);
 sp23.push_back(Annot[CE2]);
 sp23.push_back(Annot[CZ3]);
 sp23.push_back(Annot[CH2]);
 sp23.push_back(Annot[CZ2]);
 sp33.push_back(Annot[NE1]);
}

void Amino_Acid::confirm_y() {
 Code1 = 'Y';
 Code3 ="Tyr";
 Annot[CG] = sideChainC[2][1][0];
 Annot[CD1] = sideChainC[3][1][0];
 Annot[CD2] = sideChainC[3][1][1];
 Annot[CE1] = sideChainC[4][1][0];
 Annot[CE2] = sideChainC[4][1][1];
 Annot[CZ] = sideChainC[5][1][0];
 Annot[OH] = sideChainC[6][3][0];
 sp23.push_back(sideChainC[3][1][0]);
 sp23.push_back(sideChainC[3][1][1]);
 sp23.push_back(sideChainC[4][1][0]);
 sp23.push_back(sideChainC[4][1][1]);
 sp23.push_back(sideChainC[5][1][0]);
 sp32.push_back(sideChainC[6][3][0]);
}

void Amino_Acid::push_all_serial() {
 allSerial.clear();
 allSerial.shrink_to_fit();

 allSerial.push_back(Annot[N]);
 allSerial.push_back(Annot[CA]);
 allSerial.push_back(Annot[C]);
 allSerial.push_back(Annot[O]);
 if(OXT > 0)
  allSerial.push_back(OXT);
 allSerial.insert(allSerial.end(), mainH.begin(), mainH.end());
 allSerial.insert(allSerial.end(), sideH.begin(), sideH.end());

 if(Code1 == 'G' || Code1 == 'X')
  return;

 int lv_ter = 8;  //書いてみたら側鎖のレベル分けが面倒だったので
 //ただし，シスチンとプロリンはレベルの設定で重複を回避できる
 if(Code1 == 'c')
  lv_ter = 3;
 else if(Code1 == 'P' || Code1 == 'p')
  lv_ter = 4;

 //側鎖の取得
 std::vector<int> tmp;
 for(int i = 1; i < lv_ter; ++i)  //i == 0; 第 0 行の CA は格納済み
  tmp.insert(tmp.end(),
        sideChainR[i].begin(), sideChainR[i].end());

 //側鎖が環を形成していなければ，重複は発生しない
 if(Code1 != 'Y' && Code1 != 'F' && Code1 != 'H' && Code1 != 'W') {
  allSerial.insert(allSerial.end(), tmp.begin(), tmp.end());
  return;
 }

 //側鎖が環を形成している場合は重複を削除
 std::sort(tmp.begin(), tmp.end());
 allSerial.push_back(tmp[0]);  //最初の要素は比較できない
 int cnt = tmp.size();
 for(int i = 1; i < cnt; ++i)
  if(tmp[i - 1] < tmp[i])
   allSerial.push_back(tmp[i]);
}

