//PDB 形式については，ファイル保存用のデータ構造が必要？

#ifndef ___AMINO_ACID_H
#define ___AMINO_ACID_H

#include "libbuilcule_global.h"
#include <map>
#include <vector>


//非水素原子のみまとめられないか
// std::vector<int> SideSerial; があると便利（側鎖の構造調整とか変異とか）


struct Amino_Acid {
 char Code1;
 std::string Code3;
 std::map<AA_ATOM, int> Annot;
 int OXT;
 std::vector<int> allSerial;

 //側鎖の水素付加用
 std::vector<int> sp34;
 std::vector<int> sp33;
 std::vector<int> sp32;
 std::vector<int> sp23;

 //ファイル出力および水素削除用
 std::vector<int> mainH;
 std::vector<int> sideH;

 bool AA;  //検知時にアミノ酸と確定したら true
 bool Peptide;  //ペプチドの一部と確定したら true
 bool terN;  //N-末と確定したら true
 int nextN;  //C を走査して決定

 //側鎖のキャプチャ用の二次元テーブル．階層別に原子を区別せずキャプチャ
 //探索の都合上，第 0 行は CA，第 1 行は CB
 std::array<std::vector<int>, 8> sideChainR;

 //キャプチャした側鎖を元素別に分類した 3 次元テーブル．
 //第 1 次元は側鎖のレイヤ
 //第 2 次元は元素（H，C，N，O，S，X）
 //第 3 次元は原子のシリアル番号のベクトル
 //探索の都合上，第 0 行は CA，第 1 行は CB
 std::array<std::array<std::vector<int>, 6>, 8> sideChainC;

 int Secondary;  //二次構造の着色用．molColor を格納．0 == 赤色，2 == 黄色

 Amino_Acid();
 void init();
 void confirm_x();
 void erase_dupl_side_h();
 void push_all_serial();
 void confirm_ca_cb();
 void confirm_a();
 void confirm_c();
 void confirm_C();
 void confirm_d();
 void confirm_e();
 void confirm_f();
 void confirm_g();
 void confirm_h();
 void confirm_i();
 void confirm_k();
 void confirm_l();
 void confirm_m();
 void confirm_n();
 void confirm_p();
 void confirm_q();
 void confirm_r();
 void confirm_s();
 void confirm_t();
 void confirm_v();
 void confirm_w();
 void confirm_y();
};

#endif

/*
libbuilcule_global.h で定義
enum AA_ATOM {C, CA, CB, CD, CD1, CD2, CE, CE1, CE2, CG, CG1, CG2, CH2, CZ, CZ2, CZ3, N, ND1, ND2, NE, NE1, NE2, NH1, NH2, NZ, O, OD, OD1, OD2, OE1, OE2, OG, OG1, OH, SD, SG, OXT, DEF_AA_ATOM};
*/

