#ifndef ___ATOM_H
#define ___ATOM_H

#include "libbuilcule_global.h"
#include <Eigen/Dense>
#include <string>
#include <vector>

//libbuilcule_global.h には書けなかった
enum ORBITAL {SP3, SP2, SP, DEF_ORBITAL};

//番号は，自動的に付置しない．コピーされる場合は値を引き継ぐ
struct Atom {
 int serialNum;  //1 から始まる整数

 std::string Symbol;  //ファイルから読み取る．表示用
 int Elmt;  //内部処理用
 Eigen::Vector3d XYZ;
 std::vector<int> Bond;  //双方向リンク．Builcule 形式の読み取り用
 std::vector<int> BondUp;  //シリアル番号が小→大

 //構造検知用
 int molIdx;  //0 から始まる整数
 int peptIdx;  //0 から始まる整数
 int aaIdx;  //0 から始まる整数
 char aaCode;

 //構造調整用
 double Charge;
 ORBITAL Orbital;

 Atom()
  :  serialNum(-1),
    Elmt(-1),
    XYZ(Eigen::Vector3d::Zero(3)),
    molIdx(-1),
    peptIdx(-1),
    aaIdx(-1),
    aaCode('-'),
    Charge(0.0),
    Orbital(DEF_ORBITAL) {}
};

#endif
