#ifndef ___NEAR_ATOM_H
#define ___NEAR_ATOM_H

#include "mol.h"

class Atom_Near {
 private:
  //このクラス独自のオブジェクト
  std::vector<int> checkedSerial;
  std::vector<int> checkedAtomIdx;
  std::vector<std::array<int, 3>> checkedAANum;

  std::vector<Atom> *atomVect;  //電荷はここに格納
  const std::map<int, int> *serialToIdx;
  const std::vector<Mol> *molVect;

  void check_near_atom(int serial, double range);
  void check_near_atom(int mol0, int mol1, double range);

 public:
  Atom_Near(std::vector<Atom> *atom_vect, const std::map<int, int> *idx_map, std::vector<Mol> *mol_vect);

  void clear();

 //近距離にある原子の検知は同じような関数を使うのでここで定義してみた
  const std::vector<std::array<int, 3>> *atom_to_neighbor_aa(const std::vector<int> *atom_serial, double range);

  const std::vector<std::array<int, 3>> *aa_to_neighbor_aa(const std::vector<std::array<int, 3>> *aa, double range);

  const std::vector<std::array<int, 3>> *mol_to_neighbor_aa(int mol_num, double range);

  const std::vector<int> *mol_to_neighbor_atom(int mol0, int mol1, double range);

  //異常構造の検知
  const std::vector<int> *fused_serial();
  const std::vector<int> *excess_bond_serial();
};

#endif
