#ifndef ___CHARGE_H
#define ___CHARGE_H

#include "mol.h"
#include <map>

class Charge {
 private:
  std::vector<Atom> *AtomVect;
  const std::map<int, int> *SerialToIdx;
  std::vector<Mol> *MolVect;
  Adjacent_Atom AdjAtom;

  void set_ionicity(Atom &atom);
  void check_CO_charge(Atom &atom);

  void check_ammonium(Atom &atom);
  void check_hydroxyl(Atom &atom);
  void check_phosphate(Atom &atom);
  void check_sulfate(Atom &atom);
  void check_his_arg(const Mol *mol);

 public:
  Charge(
        std::vector<Atom> *atom_vect,
        std::map<int, int> *idx_map,
        std::vector<Mol> *mol_vect);
  void calc_charge();  //Atom に書き込む
//  void calc_hydrogen_bond();
};

#endif

