#ifndef ___DYNAMIC_H
#define ___DYNAMIC_H

#include <array>
#include <vector>

struct TB_Point {
 int Pos0;
 int Pos1;
 double Score;

 TB_Point()
  : Pos0(-1),
    Pos1(-1),
    Score(0.0) {}

 TB_Point(int p0, int p1, double v)
  : Pos0(p0),
    Pos1(p1),
    Score(v) {}
};

class Dynamic_Programming {
 private:
  std::vector<std::vector<double>> ScoreMtx;
  std::vector<std::vector<double>> UpMtx;
  std::vector<std::vector<double>> LeftMtx;
  std::vector<std::vector<char>> TraceMtx;
  std::vector<TB_Point> TBPoint;
  std::array<std::vector<int>, 2> AlignedNum;
  double GapIni;
  double GapElg;
  int TBter0;  //出力用
  int TBter1;  //出力用

 public:
  Dynamic_Programming();

  void clear();

  void init_mtx(int row, int col, double ini, double elg);
  int get_row_cnt()
        { return ScoreMtx.size(); }
  int get_col_cnt()
        { return ScoreMtx.empty() ? 0 : ScoreMtx[0].size(); }

  void trace_1_step(int row, int col, double val);
  const std::vector<TB_Point> *search_traceback_point();
  const std::array<std::vector<int>, 2> *traceback(int n);

  void set_score(int row, int col, double val)
        { ScoreMtx[row][col] = val; }
  const std::vector<std::vector<double>> *get_score_mtx()
        { return &ScoreMtx; }
  int get_aligned_ini(int unit)
        { return AlignedNum[unit].front(); }
  int get_aligned_ter(int unit)
        { return AlignedNum[unit].back(); }
  double get_score(int num);
  const std::array<std::vector<int>, 2> *get_aligned_num()
        { return &AlignedNum; }
  double get_score_max() { return TBPoint[0].Score; }
  int get_align_ini(int pept) { return pept ? TBter1 : TBter0; }
  int get_align_ter(int pept)
        { return pept ? TBPoint[0].Pos1 - 1 : TBPoint[0].Pos0 - 1; }
};

#endif
