#ifndef ___FILE_IO_H
#define ___FILE_IO_H

//いろいろなところでファイル入出力をおくなう必要があるのでクラスにまとめた
//その結果，関数の引数がやや煩雑になっている
//PDB 形式については，ファイル保存用のデータ構造が必要？

#include "mol.h"
#include <fstream>
#include <string>
#include <vector>

class File_IO {
 private:
  //タンパク質の出力関数．簡便のため細かく分割．引数を減らすために一部の出力を変数化
  int lineNum;  //7-11 : 行番号．1 から始める
  std::string AACode;  //18-20 : アミノ酸コード．初期化子で初期化できない？
  char peptName;  //22 : ペプチド名（アルファベット）
  int aaNum;  //23-26 : アミノ酸番号（ペプチドごと）
  std::vector<int> atomCheck;  //HETATM をあぶり出し，そのなかの分子を検知する
  std::vector<std::vector<int>> hetMol;
  std::map<int, int> serialToLineNum;

  //ファイルオープン用
  const std::vector<Atom> *atomVect;
  const std::map<int, int> *serialToIdx;

  void write_aa(std::ofstream &fo, const Amino_Acid &aa);
  void write_aa_atm(std::ofstream &fo, int serial, const std::string &elmt);
  void write_ter(std::ofstream &fo);

  void write_hetero(std::ofstream &fo);
  int get_hetero_mol_ini();
  void push_hetero_mol(int ini);
  void write_hetero_atom(std::ofstream &fo, int idx);
  void write_connect(std::ofstream &fo);

 public:
  File_IO();

  bool read_xyz(
        const std::string *file_name,
        std::vector<Atom> *atom_vect,
        std::string *comment);

  bool read_bcl(
        const std::string *file_name,
        std::vector<Atom> *atom_vect,
        std::string *comment);

  bool read_pdb(
        const std::string *file_name,
        std::vector<Atom> *atom_vect);

  bool read_cif(
        const std::string *file_name,
        std::vector<Atom> *atom_vect);

  bool read_fasta(
        const std::string *file_name,
        std::vector<std::string> *comment,
        std::vector<std::vector<char>> *sequence);

  bool write_bcl_or_xyz(
        const std::string *file_name,
        const std::string *type,
        const std::vector<Atom> *atom_vect,
        const std::map<int, int> *serial_ti_idx,
        std::string *comment);

  bool write_pdb(
        const std::string *file_name,
        const std::vector<Mol> *mol_vect,
        const std::vector<Atom> *atom_vect,
        const std::map<int, int> *serial_ti_idx,
        std::string *comment);

  bool write_fasta(
        const std::string *file_name,
        const std::vector<Mol> *mol_vect);

  bool write_alignment(
        const std::string *file_name,
        const std::vector<std::string> *summary,
        const std::array<std::vector<char>, 2> *alignment);

  void export_for_babel_mm(
        const std::vector<Atom> *atom_vect,
        const std::map<int, int> *serial_to_idx);

  void export_for_babel_mm(
        const std::vector<Atom> *atom_vect,
        const std::map<int, int> *serial_to_idx,
        const std::vector<int> *mol_serial);

  bool read_1_col_data(
        const std::string *file_name,
        std::vector<Atom> *atom_vect);
};

#endif
