#include "libbuilcule_global.h"

void create_serial_to_idx_map(
        std::map<int, int> *idx_map,
        std::vector<Atom> *atom_vect) {
 idx_map->clear();
 int atom_cnt = atom_vect->size();
 for(int i = 0; i < atom_cnt; ++i) {
  int serial_num = (*atom_vect)[i].serialNum;
  (*idx_map)[serial_num] = i;
 }
}

/*
//連番作成用のクラス（static メンバ変数版）
//クラス内の static メンバ変数はクラス外で初期化する
int Serial_Num::Num = 1; //0 は「未設定」等として使う場合があるので 1 から
*/

//連番作成用のクラス（シングルトン版）
Serial_Num &Serial_Num::get_obj() {
 static Serial_Num obj;
 return obj;
}

const Eigen::Vector3d centering(std::vector<Eigen::Vector3d> *v0)
{
 Eigen::Vector3d center = Eigen::Vector3d::Zero(3);
 for(const Eigen::Vector3d &v : *v0)
  center += v;

 center /= (double)(v0->size());

 for(Eigen::Vector3d &v : *v0)
  v -= center;
 return center;
}

double calc_rms(const std::vector<Eigen::Vector3d> *v0, const std::vector<Eigen::Vector3d> *v1) {
 double rms(0.0);
 int size = v0->size();
 for(int i = 0; i != size; ++i) {
  rms += ((*v1)[i] - (*v0)[i]).norm();
 }
 return sqrt(rms / (double)size);
}

double measure_angle(const Eigen::Vector3d *v0, const Eigen::Vector3d *v1, const Eigen::Vector3d *v2) {
 Eigen::Vector3d vect0(*v0 - *v1);
 Eigen::Vector3d vect1(*v2 - *v1);
 vect0.normalize();
 vect1.normalize();
 double cos = vect0.dot(vect1);
 double angle = acos(cos);
 if(isnan(angle) || isinf(angle))
  return 0.0;
 return angle;
}

double measure_diheadral(const Eigen::Vector3d *v0, const Eigen::Vector3d *v1, const Eigen::Vector3d *v2, const Eigen::Vector3d *v3) {
 //法線ベクトルの成す角を求めればよい（法線ベクトルを正規化し，内積を計算する）
 Eigen::Vector3d vect0(*v0 - *v1);
 Eigen::Vector3d vect1(*v2 - *v1);
 Eigen::Vector3d vect2(*v1 - *v2);
 Eigen::Vector3d vect3(*v3 - *v2);
 Eigen::Vector3d cross0(vect0.cross(vect1));
 Eigen::Vector3d cross1(vect2.cross(vect3));
 cross0.normalize();
 cross1.normalize();
 double cos = cross0.dot(cross1);

 //180 °以上か以下かは，行列式の符号で判定
 Eigen::Matrix3d mtx;
 mtx << vect0, vect2, vect3;
 double det = mtx.determinant();
 double angle = acos(cos);
 if(isnan(angle) || isinf(angle))
  return 0.0;
 else if(det < 0.0)
  return acos(cos);  //左回転の場合は正数
 else
  return -acos(cos);  //右回転の場合は負数
//  return M_PI * 2.0 - acos(cos);  //0 〜 2pi までで表す場合
}

Atom_Distance::Atom_Distance() : covRadius(COV_0), vdwRadius(VDW_0), ionRadius(ION_0)
{
 //データ．なお，covRadius[0] == vdwRadius[0] == ionRadius[0] == -1.0
 for(int i = 1; i != ELMT_CNT; ++i) {
  if(covRadius[i] < 0.0) covRadius[i] = COV_1[i];
  if(vdwRadius[i] < 0.0) vdwRadius[i] = 3.0;  //大きい値
  if(ionRadius[i] < 0.0) ionRadius[i] = 3.0;  //大きい値
 }
 for(int i = 0; i != ELMT_CNT; ++i) {
  for(int j = 0; j != ELMT_CNT; ++j) {
   vdwContact[i][j] = vdwRadius[i] + vdwRadius[j];
   covLim[i][j] = (covRadius[i] + covRadius[j]) * 1.2;
  }
 }
}

AA_Order::AA_Order() {
 aaOrder['C'] = 0;  aaOrder['S'] = 1;  aaOrder['T'] = 2;
 aaOrder['P'] = 3;  aaOrder['A'] = 4;  aaOrder['G'] = 5;
 aaOrder['N'] = 6;  aaOrder['D'] = 7;  aaOrder['E'] = 8;
 aaOrder['Q'] = 9;  aaOrder['H'] = 10;  aaOrder['R'] = 11;
 aaOrder['K'] = 12;  aaOrder['M'] = 13;  aaOrder['I'] = 14;
 aaOrder['L'] = 15;  aaOrder['V'] = 16;  aaOrder['F'] = 17;
 aaOrder['Y'] = 18;  aaOrder['W'] = 19;  aaOrder['c'] = 0;
 aaOrder['p'] = 3;
}
