#ifndef ___LIBBUILCULE_GLOBAL_H
#define ___LIBBUILCULE_GLOBAL_H

#include "atom.h"
#include <Eigen/Dense>
#include <array>
#include <iostream>
#include <limits>
#include <map>
#include <vector>

//cmath と同じ関数が呼ばれる．namespace が異なる math.h はグローバル cmath は std．これらを取り違えないために，ここでインクルード
#include <math.h>

class Atom;

//定値オブジェクト
static const std::numeric_limits<double> doubleLimits;
static const std::numeric_limits<int> intLimits;
const double DEG_to_RAD(M_PI /  180.0);
const double RAD_to_DEG(180.0 / M_PI);
const double RADIAN_SP2(M_PI * 2.0 / 3.0);
const double RADIAN_SP3(2.0 * asin(sqrt(2.0 / 3.0)));
const int ELMT_CNT(119);
const double C2C(1.33);  //C=C またはベンゼン環
const double C3C(1.20);  //CC 三重結合
const double C2N(1.27);  //C=N
const double C2O(1.23);  //C=O
const double N2N(1.25);  //N=N
const double N2O(1.20);  //N=O
//計算機 ε
//const double EPSILON = doubleLimits.epsilon();
const double EPSILON = 0.000001;  //このソフトではこれで充分か？

//値を数値に変換
template < class Type > void val_to_str(Type val, std::string &str) {
 std::stringstream stm;
 stm << val;
 stm >> str;
}

const std::array<std::string, 20> AAName{
        "Ala", "Arg", "Asn", "Asp", "Cys", "Gly", "Gln", "Glu",
        "His", "Ile", "Leu", "Lys", "Met", "Phe", "Pro", "Ser",
        "Thr", "Trp", "Tyr", "Val"};

//アミノ酸を構成する原子
enum AA_ATOM {C, CA, CB, CD, CD1, CD2, CE, CE1, CE2, CG, CG1, CG2, CH2, CZ, CZ2, CZ3, N, ND1, ND2, NE, NE1, NE2, NH1, NH2, NZ, O, OD, OD1, OD2, OE1, OE2, OG, OG1, OH, SD, SG, OXT, DEF_AA_ATOM};

//関数
void create_serial_to_idx_map(
        std::map<int, int> *idx_map,
        std::vector<Atom> *atom_vect);

//Align_3D から使えないか
const Eigen::Vector3d centering(std::vector<Eigen::Vector3d> *v0);
double calc_rms(
        const std::vector<Eigen::Vector3d> *v0,
        const std::vector<Eigen::Vector3d> *v1);
double measure_angle(
        const Eigen::Vector3d *v0,
        const Eigen::Vector3d *v1,
        const Eigen::Vector3d *v2);
double measure_diheadral(
        const Eigen::Vector3d *v0,
        const Eigen::Vector3d *v1,
        const Eigen::Vector3d *v2,
        const Eigen::Vector3d *v3);

//クラスとそのオブジェクト
//連番作成用のクラス（シングルトン版：static メンバ関数版）
class Serial_Num {
 private:
  int Num;

 public:
  Serial_Num() : Num(1) {}
  Serial_Num(const Serial_Num&);  //コピーコンストラクタの無効化
  Serial_Num& operator=(const Serial_Num);  //代入演算子の無効化
  static Serial_Num &get_obj();
  operator int() { return Num++; }
};

static Serial_Num &SERIAL_NUM = Serial_Num::get_obj();

/*
//連番作成用のクラス（static メンバ変数版）
class Serial_Num {
 private:
  static int Num;  //初期化は libbuilcule_global_cc で

 public:
  Serial_Num() {}
  Serial_Num(const Serial_Num&);  //コピーコンストラクタの無効化
  Serial_Num& operator=(const Serial_Num);  //代入演算子の無効化
  operator int() { return Num++; }
};

static Serial_Num SERIAL_NUM;
*/

const std::array<std::array<double, 20>, 20> BLOSUM62 = {
//C S T P A G N D E Q H R K M I L V F Y W
/*C*/ 9,-1,-1,-3,0,-3,-3,-3,-4,-3,-3,-3,-3,-1,-1,-1,-1,-2,-2,-2,
/*S*/ -1,4,1,-1,1,0,1,0,0,0,-1,-1,0,-1,-2,-2,-2,-2,-2,-3,
/*T*/ -1,1,5,-1,0,-2,0,-1,-1,-1,-2,-1,-1,-1,-1,-1,0,-2,-2,-2,
/*P*/ -3,-1,-1,7,-1,-2,-2,-1,-1,-1,-2,-2,-1,-2,-3,-3,-2,-4,-3,-4,
/*A*/ 0,1,0,-1,4,0,-2,-2,-1,-1,-2,-1,-1,-1,-1,-1,0,-2,-2,-3,
/*G*/ -3,0,-2,-2,0,6,0,-1,-2,-2,-2,-2,-2,-3,-4,-4,-3,-3,-3,-2,
/*N*/ -3,1,0,-2,-2,0,6,1,0,0,1,0,0,-2,-3,-3,-3,-3,-2,-4,
/*D*/ -3,0,-1,-1,-2,-1,1,6,2,0,-1,-2,-1,-3,-3,-4,-3,-3,-3,-4,
/*E*/ -4,0,-1,-1,-1,-2,0,2,5,2,0,0,1,-2,-3,-3,-2,-3,-2,-3,
/*Q*/ -3,0,-1,-1,-1,-2,0,0,2,5,0,1,1,0,-3,-2,-2,-3,-1,-2,
/*H*/ -3,-1,-2,-2,-2,-2,1,-1,0,0,8,0,-1,-2,-3,-3,-3,-1,2,-2,
/*R*/ -3,-1,-1,-2,-1,-2,0,-2,0,1,0,5,2,-1,-3,-2,-3,-3,-2,-3,
/*K*/ -3,0,-1,-1,-1,-2,0,-1,1,1,-1,2,5,-1,-3,-2,-2,-3,-2,-3,
/*M*/ -1,-1,-1,-2,-1,-3,-2,-3,-2,0,-2,-1,-1,5,1,2,1,0,-1,-1,
/*I*/ -1,-2,-1,-3,-1,-4,-3,-3,-3,-3,-3,-3,-3,1,4,2,3,0,-1,-3,
/*L*/ -1,-2,-1,-3,-1,-4,-3,-4,-3,-2,-3,-2,-2,2,2,4,1,0,-1,-2,
/*V*/ -1,-2,0,-2,0,-3,-3,-3,-2,-2,-3,-3,-2,1,3,1,4,-1,-1,-3,
/*F*/ -2,-2,-2,-4,-2,-3,-3,-3,-3,-3,-1,-3,-3,0,0,0,-1,6,3,1,
/*Y*/ -2,-2,-2,-3,-2,-3,-2,-3,-2,-1,2,-2,-2,-1,-1,-1,-1,3,7,2,
/*W*/ -2,-3,-2,-4,-3,-2,-4,-4,-3,-2,-2,-3,-3,-1,-3,-2,-3,1,2,11
};

const std::array<std::array<double, 20>, 20> PAM250 = {
//C S T P A G N D E Q H R K M I L V F Y W
/*C*/ 12,0,-2,-3,-2,-3,-4,-5,-5,-5,-3,-4,-5,-5,-2,-6,-2,-4,0,-8,
/*S*/ 0,2,1,1,1,1,1,0,0,-1,-1,0,0,-2,-1,-3,-1,-3,-3,-2,
/*T*/ -2,1,3,0,1,0,0,0,0,-1,-1,-1,0,-1,0,-2,0,-3,-3,-5,
/*P*/ -3,1,0,6,1,-1,-1,-1,-1,0,0,0,-1,-2,-2,-3,-1,-5,-5,-6,
/*A*/ -2,1,1,1,2,1,0,0,0,0,-1,-2,-1,-1,-1,-2,0,-4,-3,-6,
/*G*/ -3,1,0,-1,1,5,0,1,0,-1,-2,-3,-2,-3,-3,-4,-1,-5,-5,-7,
/*N*/ -4,1,0,-1,0,0,2,2,1,1,2,0,1,-2,-2,-3,-2,-4,-2,-4,
/*D*/ -5,0,0,-1,0,1,2,4,3,2,1,-1,0,-3,-2,-4,-2,-6,-4,-7,
/*E*/ -5,0,0,-1,0,0,1,3,4,2,1,-1,0,-2,-2,-3,-2,-5,-4,-7,
/*Q*/ -5,-1,-1,0,0,-1,1,2,2,4,3,1,1,-1,-2,-2,-2,-5,-4,-5,
/*H*/ -3,-1,-1,0,-1,-2,2,1,1,3,6,2,0,-2,-2,-2,-2,-2,0,-3,
/*R*/ -4,0,-1,0,-2,-3,0,-1,-1,1,2,6,3,0,-2,-3,-2,-4,-4,2,
/*K*/ -5,0,0,-1,-1,-2,1,0,0,1,0,3,5,0,-2,-3,-2,-5,-4,-3,
/*M*/ -5,-2,-1,-2,-1,-3,-2,-3,-2,-1,-2,0,0,6,2,4,2,0,-2,-4,
/*I*/ -2,-1,0,-2,-1,-3,-2,-2,-2,-2,-2,-2,-2,2,5,2,4,1,-1,-5,
/*L*/ -6,-3,-2,-3,-2,-4,-3,-4,-3,-2,-2,-3,-3,4,2,6,2,2,-1,-2,
/*V*/ -2,-1,0,-1,0,-1,-2,-2,-2,-2,-2,-2,-2,2,4,2,4,-1,-2,-6,
/*F*/ -4,-3,-3,-5,-4,-5,-4,-6,-5,-5,-2,-4,-5,0,1,2,-1,9,7,0,
/*Y*/ 0,-3,-3,-5,-3,-5,-2,-4,-4,-4,0,-4,-4,-2,-1,-1,-2,7,10,0,
/*W*/ -8,-2,-5,-6,-6,-7,-4,-7,-7,-5,-3,2,-3,-4,-5,-2,-6,0,0,17
};

const std::array<std::string, ELMT_CNT> SYMBOL {
/*  UNKNOWN  */ "UCS",
/*   1 -  10 */ "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne",
/*  11 -  20 */ "Na", "Mg", "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca",
/*  21 -  30 */ "Sc", "Ti", "V", "Cr", "Mn", "Fe", "Co", "Ni", "Cu", "Zn",
/*  31 -  40 */ "Ga", "Ge", "As", "Se", "Br", "Kr", "Rb", "Sr", "Y", "Zr",
/*  41 -  50 */ "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", "Ag", "Cd", "In", "Sn",
/*  51 -  60 */ "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", "Ce", "Pr", "Nd",
/*  61 -  70 */ "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", "Tm", "Yb",
/*  71 -  80 */ "Lu", "Hf", "Ta", "V", "Re", "Os", "Ir", "Pt", "Au", "Hg",
/*  81 -  90 */ "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th",
/*  91 - 100 */ "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm",
/* 101 - 110 */ "Md", "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds",
/* 111 - 118 */ "Rg", "Uub", "Uut", "Uuq", "Uup", "Uuh", "Uus", "Uuo"
};

//原子間の距離を表すデータは一部修正が必要なので，クラスを作ってみた
class Atom_Distance {
 private:
//https://www.hulinks.co.jp/support/c-maker/qa_05.html の共有結合半径
const std::array<double, ELMT_CNT> COV_0 = {
/* UCS 用  */ -1.00,
/*   1 -  10 */  0.37,  0.32,  1.34,  0.90,  0.82,  0.77,  0.75,  0.73,  0.71,  0.69,
/*  11 -  20 */  1.54,  1.30,  1.18,  1.11,  1.06,  1.02,  0.99,  0.97,  1.96,  1.74,
/*  21 -  30 */  1.44,  1.36,  1.25,  1.27,  1.39,  1.25,  1.26,  1.21,  1.38,  1.31,
/*  41 -  50 */  1.26,  1.22,  1.19,  1.16,  1.14,  1.10,  2.11,  1.92,  1.62,  1.48,
/*  51 -  60 */  1.37,  1.45,  1.56,  1.26,  1.35,  1.31,  1.53,  1.48,  1.44,  1.41,
/*  61 -  70 */  1.38,  1.35,  1.33,  1.30,  2.25,  1.98,  1.69, -1.00, -1.00, -1.00,
/*  71 -  80 */ -1.00, -1.00, -1.00, -1.00, -1.00, -1.00, -1.00, -1.00, -1.00, -1.00,
/*  81 -  90 */  1.60,  1.50,  1.38,  1.46,  1.59,  1.28,  1.37,  1.28,  1.44,  1.49,
/*  91 - 100 */  1.48,  1.47,  1.46, -1.00, -1.00,  1.45, -1.00, -1.00, -1.00, -1.00,
/* 101 - 110 */ -1.00, -1.00, -1.00, -1.00, -1.00, -1.00, -1.00, -1.00, -1.00, -1.00,
/* 111 - 118 */ -1.00, -1.00, -1.00, -1.00, -1.00, -1.00, -1.00, -1.00
};

//'http://ja.wikipedia.org/wiki/共有結合半径' の単結合を Å で表記したもの
const std::array<double, ELMT_CNT> COV_1 = {
/* UCS 用  */ -1.00,
/*   1 -  10 */  0.32,  0.46,  1.33,  1.02,  0.85,  0.75,  0.71,  0.63,  0.64,  0.67,
/*  11 -  20 */  1.55,  1.39,  1.26,  1.16,  1.11,  1.03,  0.99,  0.96,  1.96,  1.71,
/*  21 -  30 */  1.48,  1.36,  1.34,  1.22,  1.19,  1.16,  1.11,  1.10,  1.12,  1.18,
/*  31 -  40 */  1.24,  1.24,  1.21,  1.16,  1.14,  1.17,  2.10,  1.85,  1.63,  1.54,
/*  41 -  50 */  1.47,  1.38,  1.28,  1.25,  1.25,  1.20,  1.28,  1.36,  1.42,  1.40,
/*  51 -  60 */  1.40,  1.36,  1.33,  1.31,  2.32,  1.96,  1.80,  1.63,  1.76,  1.74,
/*  61 -  70 */  1.73,  1.72,  1.68,  1.69,  1.68,  1.67,  1.66,  1.65,  1.64,  1.70,
/*  71 -  80 */  1.62,  1.52,  1.46,  1.37,  1.31,  1.29,  1.22,  1.23,  1.24,  1.33,
/*  81 -  90 */  1.44,  1.44,  1.51,  1.45,  1.47,  1.42,  2.23,  2.01,  1.86,  1.75,
/*  91 - 100 */  1.69,  1.70,  1.71,  1.72,  1.66,  1.66,  1.66,  1.68,  1.65,  1.67,
/* 101 - 110 */  1.73,  1.76,  1.61,  1.57,  1.49,  1.43,  1.41,  1.34,  1.29,  1.28,
/* 111 - 118 */  1.21,  1.22,  1.36,  1.43,  1.62,  1.75,  1.65,  1.57
};

//https://www.hulinks.co.jp/support/c-maker/qa_05.html のファンデルワールス半径
const std::array<double, ELMT_CNT> VDW_0 = {
/* UCS 用  */ -1.00,
/*   1 -  10 */  1.20,  1.40,  1.82, -1.00, -1.00,  1.70,  1.55,  1.52,  1.47,  1.54,
/*  11 -  20 */  2.27,  1.73, -1.00,  2.10,  1.80,  1.80,  1.75,  1.88,  2.75, -1.00,
/*  21 -  30 */ -1.00, -1.00, -1.00, -1.00, -1.00, -1.00, -1.00,  1.63,  1.40,  1.39,
/*  31 -  40 */  1.87, -1.00,  1.85,  1.90,  1.85,  2.02, -1.00, -1.00, -1.00, -1.00,
/*  41 -  50 */ -1.00, -1.00, -1.00, -1.00, -1.00,  1.63,  1.72,  1.58,  1.93,  2.17,
/*  51 -  60 */ -1.00,  2.06,  1.98,  2.16, -1.00, -1.00, -1.00, -1.00, -1.00, -1.00,
/*  61 -  70 */ -1.00, -1.00, -1.00, -1.00, -1.00, -1.00, -1.00, -1.00, -1.00, -1.00,
/*  71 -  80 */ -1.00, -1.00, -1.00, -1.00, -1.00, -1.00, -1.00,  1.75,  1.66,  1.55,
/*  81 -  90 */  1.96,  2.02, -1.00, -1.00, -1.00, -1.00, -1.00, -1.00, -1.00, -1.00,
/*  91 - 100 */ -1.00,  1.86, -1.00, -1.00, -1.00, -1.00, -1.00, -1.00, -1.00, -1.00,
/* 101 - 110 */ -1.00, -1.00, -1.00, -1.00, -1.00, -1.00, -1.00, -1.00, -1.00, -1.00,
/* 111 - 118 */ -1.00, -1.00, -1.00, -1.00, -1.00, -1.00, -1.00, -1.00,
};

//https://www.hulinks.co.jp/support/c-maker/qa_05.html のイオン半径
const std::array<double, ELMT_CNT> ION_0 = {
/* UCS 用  */ -1.00,
/*   1 -  10 */  0.25,  0.31,  1.45,  1.05,  0.85,  0.70,  0.65,  0.60,  0.50,  0.38,
/*  11 -  20 */  1.80,  1.50,  1.25,  1.10,  1.00,  1.00,  1.00,  0.71,  2.20,  1.80,
/*  21 -  30 */  1.60,  1.40,  1.35,  1.40,  1.40,  1.40,  1.35,  1.35,  1.35,  1.35,
/*  31 -  40 */  1.30,  1.25,  1.15,  1.15,  1.15,  0.88,  2.35,  2.00,  1.85,  1.55,
/*  41 -  50 */  1.45,  1.45,  1.35,  1.30,  1.35,  1.40,  1.60,  1.55,  1.55,  1.45,
/*  51 -  60 */  1.45,  1.40,  1.40,  1.08,  2.60,  2.15,  1.95,  1.85,  1.85,  1.85,
/*  61 -  70 */  1.85,  1.85,  1.85,  1.80,  1.75,  1.75,  1.75,  1.75,  1.75,  1.75,
/*  71 -  80 */  1.75,  1.55,  1.45,  1.35,  1.35,  1.30,  1.35,  1.35,  1.35,  1.50,
/*  81 -  90 */  1.90,  1.80,  1.60,  1.90,  1.27,  1.20, -1.00,  2.15,  1.95,  1.80,
/*  91 - 100 */  1.80,  1.75,  1.75,  1.75,  1.75  -1.00, -1.00, -1.00, -1.00, -1.00,
/* 101 - 110 */ -1.00, -1.00, -1.00, -1.00, -1.00, -1.00, -1.00, -1.00, -1.00, -1.00,
/* 111 - 118 */ -1.00, -1.00, -1.00, -1.00, -1.00, -1.00, -1.00, -1.00
};

  std::array<double, ELMT_CNT> covRadius;
  std::array<double, ELMT_CNT> vdwRadius;
  std::array<double, ELMT_CNT> ionRadius;
  std::array<std::array<double, ELMT_CNT>, ELMT_CNT> vdwContact;
  std::array<std::array<double, ELMT_CNT>, ELMT_CNT> covLim;

 public:
  Atom_Distance();

  const std::array<double, ELMT_CNT> &cov_radius() { return covRadius; }
  const std::array<double, ELMT_CNT> &vdw_radius() { return vdwRadius; }
  const std::array<double, ELMT_CNT> &ion_radius() { return ionRadius; }
  const std::array<std::array<double, ELMT_CNT>, ELMT_CNT> &vdw_contact() { return vdwContact; }
  const std::array<std::array<double, ELMT_CNT>, ELMT_CNT> &cov_lim() { return covLim; }
};

static Atom_Distance ATOM_DISTANCE;

class AA_Order {
 private:
  std::map<char, int> aaOrder;
 public:
  AA_Order();

  const std::map<char, int> &aa_order() { return aaOrder; }
};

static AA_Order AA_ORDER;

//描画用定値オブジェクト．float 型なのは，GLfloat 型として使うので
const double viewAngle(2.0 * asin(0.1) * (180.0 / M_PI));
const float ballRadiusH(0.35f);
const float ballRadiusX(0.5f);
const float stickRadius(0.15f);
const Eigen::Vector3d zAxis{0.0, 0.0, 1.0};

const std::array<std::array<float, 4>, 7> molColor = {
 1.000000f, 0.000000f, 0.000000f, 1.0f,  //赤色
 0.000000f, 0.000000f, 1.000000f, 1.0f,  //青色
 1.000000f, 1.000000f, 0.000000f, 1.0f,  //黄色
 0.000000f, 1.000000f, 0.000000f, 1.0f,  //緑色
 0.000000f, 1.000000f, 1.000000f, 1.0f,  //シアン
 1.000000f, 0.000000f, 1.000000f, 1.0f,  //マゼンダ
 0.000000f, 0.000000f, 0.000000f, 1.0f   //黒色
};

const std::array<std::array<float, 4>, 121> atomColor = {
 0.800000f, 0.800000f, 0.800000f, 1.0f ,  //0 : 結合の色．水素と炭素の中間色である
 0.920000f, 1.000000f, 1.000000f, 1.0f ,  //1
 0.850980f, 1.000000f, 1.000000f, 1.0f ,  //2
 0.800000f, 0.501961f, 1.000000f, 1.0f ,  //3
 0.760784f, 1.000000f, 0.000000f, 1.0f ,  //4
 1.000000f, 0.709804f, 0.709804f, 1.0f ,  //5
 0.564706f, 0.564706f, 0.564706f, 1.0f ,  //6
 0.188235f, 0.313725f, 0.972549f, 1.0f ,  //7
 1.000000f, 0.050980f, 0.050980f, 1.0f ,  //8
 0.564706f, 0.878431f, 0.313725f, 1.0f ,  //9
 0.701961f, 0.890196f, 0.960784f, 1.0f ,  //10
 0.670588f, 0.360784f, 0.949020f, 1.0f ,  //11
 0.054118f, 1.000000f, 0.000000f, 1.0f ,  //12
 0.749020f, 0.650980f, 0.650980f, 1.0f ,  //13
 0.941176f, 0.784314f, 0.627451f, 1.0f ,  //14
 1.000000f, 0.501961f, 0.000000f, 1.0f ,  //15
 1.000000f, 1.000000f, 0.188235f, 1.0f ,  //16
 0.012157f, 0.941176f, 0.121569f, 1.0f ,  //17
 0.501960f, 0.819601f, 0.890196f, 1.0f ,  //18
 0.560784f, 0.250980f, 0.831373f, 1.0f ,  //19
 0.239216f, 1.000000f, 0.000000f, 1.0f ,  //20
 0.901961f, 0.901961f, 0.901961f, 1.0f ,  //21
 0.749020f, 0.760784f, 0.780392f, 1.0f ,  //22
 0.650980f, 0.650980f, 0.670588f, 1.0f ,  //23
 0.541176f, 0.600000f, 0.780392f, 1.0f ,  //24
 0.611765f, 0.478431f, 0.780392f, 1.0f ,  //25
 0.878431f, 0.400000f, 0.200000f, 1.0f ,  //26
 0.941176f, 0.564706f, 0.627451f, 1.0f ,  //27
 0.313725f, 0.815686f, 0.313725f, 1.0f ,  //28
 0.784314f, 0.501961f, 0.200000f, 1.0f ,  //29
 0.490196f, 0.501961f, 0.690196f, 1.0f ,  //30
 0.760784f, 0.560784f, 0.560784f, 1.0f ,  //31
 0.400000f, 0.560784f, 0.560784f, 1.0f ,  //32
 0.741176f, 0.501961f, 0.890196f, 1.0f ,  //33
 1.000000f, 0.631373f, 0.000000f, 1.0f ,  //34
 0.650980f, 0.160784f, 0.160784f, 1.0f ,  //35
 0.360784f, 0.721569f, 0.819608f, 1.0f ,  //36
 0.439216f, 0.180392f, 0.690196f, 1.0f ,  //37
 0.000000f, 1.000000f, 0.000000f, 1.0f ,  //38
 0.580392f, 1.000000f, 1.000000f, 1.0f ,  //39
 0.580392f, 0.878431f, 0.878431f, 1.0f ,  //40
 0.450980f, 0.760784f, 0.788235f, 1.0f ,  //41
 0.329412f, 0.709804f, 0.709804f, 1.0f ,  //42
 0.231372f, 0.619608f, 0.619608f, 1.0f ,  //43
 0.141176f, 0.560784f, 0.560784f, 1.0f ,  //44
 0.039220f, 0.490196f, 0.549020f, 1.0f ,  //45
 0.000000f, 0.411765f, 0.521569f, 1.0f ,  //46
 0.752941f, 0.752941f, 0.752941f, 1.0f ,  //47
 1.000000f, 0.850980f, 0.560784f, 1.0f ,  //48
 0.650980f, 0.458824f, 0.450980f, 1.0f ,  //49
 0.400000f, 0.501961f, 0.501961f, 1.0f ,  //50
 0.619608f, 0.388235f, 0.709804f, 1.0f ,  //51
 0.831373f, 0.478431f, 0.000000f, 1.0f ,  //52
 0.580392f, 0.000000f, 0.580392f, 1.0f ,  //53
 0.258824f, 0.619608f, 0.690196f, 1.0f ,  //54
 0.341176f, 0.090196f, 0.560784f, 1.0f ,  //55
 0.000000f, 0.788235f, 0.000000f, 1.0f ,  //56
 0.439216f, 0.831373f, 1.000000f, 1.0f ,  //57
 1.000000f, 1.000000f, 1.000000f, 1.0f ,  //58 : 色未指定
 0.850980f, 1.000000f, 0.780392f, 1.0f ,  //59
 1.000000f, 1.000000f, 1.000000f, 1.0f ,  //60 : 色未指定
 1.000000f, 1.000000f, 1.000000f, 1.0f ,  //61 : 色未指定
 1.000000f, 1.000000f, 1.000000f, 1.0f ,  //62 : 色未指定
 1.000000f, 1.000000f, 1.000000f, 1.0f ,  //63 : 色未指定
 1.000000f, 1.000000f, 1.000000f, 1.0f ,  //64 : 色未指定
 1.000000f, 1.000000f, 1.000000f, 1.0f ,  //65 : 色未指定
 1.000000f, 1.000000f, 1.000000f, 1.0f ,  //66 : 色未指定
 0.000000f, 1.000000f, 0.611765f, 1.0f ,  //67
 1.000000f, 1.000000f, 1.000000f, 1.0f ,  //68 : 色未指定
 1.000000f, 1.000000f, 1.000000f, 1.0f ,  //69 : 色未指定
 1.000000f, 1.000000f, 1.000000f, 1.0f ,  //70 : 色未指定
 0.000000f, 0.670588f, 0.121569f, 1.0f ,  //71
 0.301961f, 0.721569f, 1.000000f, 1.0f ,  //72
 0.301961f, 0.650980f, 1.000000f, 1.0f ,  //73
 0.129412f, 0.580392f, 0.839216f, 1.0f ,  //74
 0.149020f, 0.490196f, 0.670588f, 1.0f ,  //75
 0.149020f, 0.400000f, 0.588235f, 1.0f ,  //76
 0.090196f, 0.329412f, 0.529412f, 1.0f ,  //77
 0.815686f, 0.815686f, 0.878431f, 1.0f ,  //78
 1.000000f, 0.819608f, 0.137255f, 1.0f ,  //79
 0.721569f, 0.721569f, 0.815686f, 1.0f ,  //80
 0.650980f, 0.329412f, 0.301961f, 1.0f ,  //81
 0.341176f, 0.349020f, 0.380392f, 1.0f ,  //82
 0.619608f, 0.309804f, 0.709804f, 1.0f ,  //83
 1.000000f, 1.000000f, 1.000000f, 1.0f ,  //84 : 色未指定
 0.458824f, 0.309804f, 0.270588f, 1.0f ,  //85
 0.258824f, 0.309804f, 0.588235f, 1.0f ,  //86
 1.000000f, 1.000000f, 1.000000f, 1.0f ,  //87 : 色未指定
 1.000000f, 1.000000f, 1.000000f, 1.0f ,  //88 : 色未指定
 1.000000f, 1.000000f, 1.000000f, 1.0f ,  //89 : 色未指定
 1.000000f, 1.000000f, 1.000000f, 1.0f ,  //90 : 色未指定
 1.000000f, 1.000000f, 1.000000f, 1.0f ,  //91 : 色未指定
 1.000000f, 1.000000f, 1.000000f, 1.0f ,  //92 : 色未指定
 1.000000f, 1.000000f, 1.000000f, 1.0f ,  //93 : 色未指定
 1.000000f, 1.000000f, 1.000000f, 1.0f ,  //94 : 色未指定
 1.000000f, 1.000000f, 1.000000f, 1.0f ,  //95 : 色未指定
 1.000000f, 1.000000f, 1.000000f, 1.0f ,  //96 : 色未指定
 1.000000f, 1.000000f, 1.000000f, 1.0f ,  //97 : 色未指定
 1.000000f, 1.000000f, 1.000000f, 1.0f ,  //98 : 色未指定
 1.000000f, 1.000000f, 1.000000f, 1.0f ,  //99 : 色未指定
 1.000000f, 1.000000f, 1.000000f, 1.0f ,  //100 : 色未指定
 1.000000f, 1.000000f, 1.000000f, 1.0f ,  //101 : 色未指定
 1.000000f, 1.000000f, 1.000000f, 1.0f ,  //102 : 色未指定
 1.000000f, 1.000000f, 1.000000f, 1.0f ,  //103 : 色未指定
 0.800000f, 0.000000f, 0.349020f, 1.0f ,  //104
 0.819608f, 0.000000f, 0.309804f, 1.0f ,  //105
 1.000000f, 1.000000f, 1.000000f, 1.0f ,  //106 : 色未指定
 1.000000f, 1.000000f, 1.000000f, 1.0f ,  //107 : 色未指定
 1.000000f, 1.000000f, 1.000000f, 1.0f ,  //108 : 色未指定
 1.000000f, 1.000000f, 1.000000f, 1.0f ,  //109 : 色未指定
 1.000000f, 1.000000f, 1.000000f, 1.0f ,  //110 : 色未指定
 1.000000f, 1.000000f, 1.000000f, 1.0f ,  //111 : 色未指定
 1.000000f, 1.000000f, 1.000000f, 1.0f ,  //112 : 色未指定
 1.000000f, 1.000000f, 1.000000f, 1.0f ,  //113 : 色未指定
 1.000000f, 1.000000f, 1.000000f, 1.0f ,  //114 : 色未指定
 1.000000f, 1.000000f, 1.000000f, 1.0f ,  //115 : 色未指定
 1.000000f, 1.000000f, 1.000000f, 1.0f ,  //116 : 色未指定
 1.000000f, 1.000000f, 1.000000f, 1.0f ,  //117 : 色未指定
 1.000000f, 1.000000f, 1.000000f, 1.0f ,  //118 : 色未指定
 1.000000f, 1.000000f, 1.000000f, 1.0f ,  //119 : 色未指定
 0.980392f, 0.086275f, 0.568627f, 1.0f    //120 : pick された原子の色
};

#endif
