#ifndef ___MOL_H
#define ___MOL_H

#include "amino_acid.h"
#include "adjacent_atom.h"
#include "atom.h"
#include <map>
#include <vector>

struct Mol {
 std::vector<int> atomSerial;  //この分子に属する原子

 std::vector<std::vector<Amino_Acid>> aaTable;  //検知されたペプチド

 std::vector<Amino_Acid> detectedAA; //アミノ酸の検知用
 std::vector<char> peptSeq;  //情報開示用．必要に応じて aaTable から作成

 std::vector<Atom> *atomVect;
 const std::map<int, int> *serialToIdx;

 Adjacent_Atom adjAtom;

 Mol(std::vector<Atom> *atom_vect, const std::map<int, int> *map);

 void detect_main_chain();
 void scan_C();
 void scan_CA(Amino_Acid &aa);
 void scan_N(Amino_Acid &aa);
 void clear_ser_duplication(int aa0, int aa1);
 int search_next_aa_pos(int next_n);
 bool is_modifyed_n_ter(int aa_pos);

 void capture_side_chain();
 void capture_side_chain(Amino_Acid &aa);
 void capture_lv(Amino_Acid &aa, int lv);
 bool is_bound(int serial0, int serial1);

 void sequencing();
 void sequencing(int aa_pos);

 void update_protein_num_data();  //分子単位で処理する場合があるので，ここにも作成

 //アミノ酸配列は，アラインメントなどの必要に応じて aaTable から作成する
 const std::vector<char> *get_aa_seq(int pept_num);
};

#endif
