#include "libbuilcule_global.h"
#include "superimpose.h"

Superimpose::Superimpose()
 : Rreal(Eigen::MatrixXd::Zero(3, 3))
{}

void Superimpose::init()
{
 Rreal <<
        0.0, 0.0, 0.0,
        0.0, 0.0, 0.0,
        0.0, 0.0, 0.0;
 AlignCenter0 << 0.0, 0.0, 0.0;
 AlignCenter1 << 0.0, 0.0, 0.0;
}

bool Superimpose::create_rotation_matrix_core (
        const std::vector<Eigen::Vector3d> *v0,
        const std::vector<Eigen::Vector3d> *v1)
{
 int size0 = v0->size();

 //列どうしの内積を成分とする行列を作成する
 Eigen::MatrixXcd A = Eigen::MatrixXcd::Zero(3, 3);  //明示的にゼロ初期化しないと結果が異常値になる

 //winXYZ[0] を回転して winXYZ[1] に重ねるとする
 for(int i = 0; i != size0; ++i) {
  for(int j = 0; j != 3; ++j) {
   for(int k = 0; k != 3; ++k) {
    A(j, k) += (*v0)[i][j] * (*v1)[i][k];
   }
  }
 }

 Eigen::MatrixXcd B = Eigen::MatrixXcd::Zero(3, 3);
 B = A.transpose() * A;

 //B を固有値分解して B の平方根を求める
 Eigen::ComplexEigenSolver<Eigen::MatrixXcd> ces;
 ces.compute(B);

 Eigen::MatrixXcd Vl = Eigen::MatrixXcd::Zero(3, 3);
 Vl = ces.eigenvectors();

 Eigen::MatrixXcd D = Eigen::MatrixXcd::Zero(3, 3);
 D = ces.eigenvalues().asDiagonal();

 Eigen::MatrixXcd Dsqrt = Eigen::MatrixXcd::Zero(3, 3);
 for(int i = 0; i < 3; ++i)
  Dsqrt(i, i) = sqrt(D(i, i));

 Eigen::MatrixXcd Bsqrt = Eigen::MatrixXcd::Zero(3, 3);
 Bsqrt = Vl * Dsqrt * Vl.inverse();

 //回転行列
 Eigen::MatrixXcd R = Eigen::MatrixXcd::Zero(3, 3);
 R = Bsqrt * A.inverse();
 Rreal = R.real();

 for(int i = 0; i < 3; ++i)
  for(int j = 0; j < 3; ++j)
   if(abs(Rreal(i, j)) > 1.0
        || isinf(Rreal(i, j))
        || isnan(Rreal(i, j)))
    return false;
 return true;
}

void Superimpose::rotation_core(
        const std::vector<Eigen::Vector3d> *v0,
        std::vector<Eigen::Vector3d> *v1)
{
 int size = v0->size();
 for(int i = 0; i != size; ++i)
  (*v1)[i] = Rreal * (*v0)[i];
}

void Superimpose::set_standard(
        const std::vector<Eigen::Vector3d> *v1) {
 XYZ1 = *v1;
 AlignCenter1 = centering(&XYZ1);
}

void Superimpose::set_target(
        const std::vector<Eigen::Vector3d> *v0) {
 XYZ0 = *v0;
 AlignCenter0 = centering(&XYZ0);
}

void Superimpose::rotate(std::vector<Atom> *atom_vect)
{
 for(Atom &atom : *atom_vect) {
  atom.XYZ -= AlignCenter1;
  atom.XYZ = Rreal * atom.XYZ;
  atom.XYZ += AlignCenter1;
 }
}

void Superimpose::rotate_point_for_adjust_structure(Eigen::Vector3d *point)
{
 *point -= AlignCenter0;
 *point = Rreal * (*point);
 *point += AlignCenter1;
}

