#ifndef ___SUPERIMPOSE_H
#define ___SUPERIMPOSE_H

/*
改良点
(1) 中心を集約
 private:
  Eigen::Vector3d UnitCenter;
  Eigen::Vector3d RotationCenter;
  Eigen::Vector3d EyePos;
(2) アフィン変換による重ね合わせ対応
 private:
  std::vector<std::vector<Atom>> *atomVect;
(3) 継承関係
 Dinamic_Programming : public Affine
*/

#include "atom.h"
#include <Eigen/Dense>
#include <vector>

//v1 を基準にして v0 を回転する

class Superimpose {
 private:
  Eigen::MatrixXd Rreal;  //回転行列

  std::vector<Eigen::Vector3d> XYZ0;  //基準
  Eigen::Vector3d AlignCenter0;

  std::vector<Eigen::Vector3d> XYZ1;  //ターゲット
  Eigen::Vector3d AlignCenter1;

 public:
  Superimpose();
  void init();

  //構造アラインメント用．センタリング済みとする
  bool create_rotation_matrix_core(
        const std::vector<Eigen::Vector3d> *v0,
        const std::vector<Eigen::Vector3d> *v1);
  void rotation_core(
        const std::vector<Eigen::Vector3d> *v0,
        std::vector<Eigen::Vector3d> *v1);

  //通常版
  void set_standard(const std::vector<Eigen::Vector3d> *v0);
  void set_target(const std::vector<Eigen::Vector3d> *v1);
  bool create_rotation_matrix()
        { return create_rotation_matrix_core(&XYZ0, &XYZ1); }
  void rotate(std::vector<Atom> *atom_vect);
  const Eigen::Vector3d *get_align_center(int unit)
        { return unit ? &AlignCenter1 : &AlignCenter0; };
  void rotate_point_for_adjust_structure(Eigen::Vector3d *point);
};

#endif
