#ifndef ___UNIT_H
#define ___UNIT_H





/*
複数の GUI オブジェクト(Main_Window, Draw_Widget, etc)からアクセスされる
グローバルオブジェクト（Data とか）に内包すべし
*/





#include "atom.h"
#include "mol.h"
#include "file_io.h"
#include "atom_near.h"
#include "charge.h"
#include <map>
#include <memory>

class Unit {
 protected:
  //グローバルオブジェクトの参照
  const std::array<double, ELMT_CNT> &covRadius;
  const std::array<double, ELMT_CNT> &vdwRadius;
  const std::array<double, ELMT_CNT> &ionRadius;

  int unitNum;

  //下記 3 個のデータ構造はクラス化を検討するのがよいかも
  std::vector<Atom> atomVect;
  std::map<int, int> serialToIdx;
  std::vector<Mol> molVect;

  Atom_Near AtomNear;  //近傍の検知用クラス
  Charge CHarge;  //電荷計算用クラス

  std::string Comment;  //ファイルに記述されているコメントはそのまま残したい

  bool judgement_cov(int elmt0, int elmt1);  //共有結合と見なすかどうか
  void clear();

 private:
  //グローバルオブジェクトの参照
  std::map<std::string, int> symbolToNum;
  const std::array<std::array<double, ELMT_CNT>, ELMT_CNT> &covLim;

  //データ構造の構築用関数
  //原子検知
  bool read_xyz(const std::string *name);
  bool read_bcl(const std::string *name);
  bool read_pdb(const std::string *name);
  bool read_cif(const std::string *name);

  void set_atom_num();

 protected:
  //分子検知
  void detect_bond();
  void detect_one_way_bond();  //BCL 形式を読み取るとき専用

  void create_mol_vect();

  //タンパク質主鎖検知
  void detect_main_chain();
  void sequencing();

  //タンパク質側鎖検知
  void capture_side_chain();
  void update_protein_num_data();  //分子単位で処理する場合 があるので Mol にも作成する
  void capture_mol(int atom_idx, int mol_idx);

 public:
  Unit();

  void set_unit_num(int num) { unitNum = num; }
  void calc_charge() { CHarge.calc_charge(); }
  void calc_hydrogen_bond() {/* AtomNear.calc_hydrogen_bond(); */}

  //ファイル処理
  bool read_file(const std::string *name, const std::string *type);
  bool save(const std::string *name, const std::string *type);
  bool export_fasta(const std::string *name);
  bool import_via_babel(const std::string *name, const std::string *type);
  bool export_via_babel(const std::string *name, const std::string *type);

  void create_data_structure();  //内容がわかりにくいので削除の方向で

  //情報開示


  //マウスによる回転で atomVect の内容を書き換える場合がある
  //回転はこちらに移すべし
  std::vector<Atom> *atom_vect() { return &atomVect; }
  const std::vector<Atom> *atom_vect() const { return &atomVect; }

  int element(int serial) const
        { return atomVect[serialToIdx.at(serial)].Elmt; }

  const std::vector<Mol> *mol_vect() const { return &molVect; }

  const std::vector<std::vector<Amino_Acid>> *aa_table(int mol)
        const { return &molVect[mol].aaTable; }

  const std::vector<Amino_Acid> *peptide(int mol, int pept) const
        { return &molVect[mol].aaTable[pept]; }


  const std::map<int, int> *serial_to_idx() const
      { return &serialToIdx; }

  int atom_cnt() const { return atomVect.size(); }
  int mol_atom_cnt(int num) const
        { return molVect[num].atomSerial.size(); }
  int mol_cnt() const { return molVect.size(); }
  bool contain_peptide() const;
  int pept_cnt(int mol) const
        { return molVect[mol].aaTable.size(); }
  int aa_cnt(int mol, int pept) const
      { return molVect[mol].aaTable[pept].size(); }
  const std::vector<char> *get_aa_seq(int mol, int pept)  //用時調製
        { return molVect[mol].get_aa_seq(pept); }
  const Eigen::Vector3d *get_xyz(int serial) const
        { return &atomVect[serialToIdx.at(serial)].XYZ; }
  void get_xyz_for_superimpose
        (int layer, int mol, int pept,
        const std::array<std::vector<int>, 2> *aa_num,
        std::vector<Eigen::Vector3d> *container) const;
  void get_xyz_for_superimpose(const std::vector<int> *serial,
        std::vector<Eigen::Vector3d> *container) const;

  //検知
  const std::vector<std::array<int, 3>> *atom_to_neighbor_aa(const std::vector<int> *atom_serial, double range)
      { return AtomNear.atom_to_neighbor_aa(atom_serial, range); }

  const std::vector<std::array<int, 3>> *aa_to_neighbor_aa(const std::vector<std::array<int, 3>> *aa, double range)
      { return AtomNear.aa_to_neighbor_aa(aa, range); }

  const std::vector<std::array<int, 3>> *mol_to_neighbor_aa(int mol, double range)
      { return AtomNear.mol_to_neighbor_aa(mol, range); }

  void set_orbital();

  //編集
  void translate(const Eigen::Vector3d *vect);
};

#endif
